/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import com.oxygenxml.examples.webdav.CredentialsStore;
import com.oxygenxml.examples.webdav.WebdavUrlStreamHandler;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.LockHandlerWithContext;
import ro.sync.exml.plugin.lock.LockException;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.net.protocol.http.WebdavLockHelper;

public class WebdavLockHandler
extends LockHandlerWithContext {
    private WebdavLockHelper webdavLockHelper = new WebdavLockHelper();

    public boolean isSaveAllowed(String contextId, URL url, int timeoutSeconds) {
        url = WebdavUrlStreamHandler.addCredentials(contextId, url);
        return this.webdavLockHelper.isSaveAllowed(contextId, url, timeoutSeconds);
    }

    public void unlock(String contextId, URL url) throws LockException {
        url = WebdavUrlStreamHandler.addCredentials(contextId, url);
        List<String> headerKeys = Collections.singletonList("X-Requested-With");
        List<String> headerValues = Collections.singletonList("x");
        this.webdavLockHelper.unlock(contextId, url, headerKeys, headerValues);
    }

    public void updateLock(String contextId, URL url, int timeoutSeconds) throws LockException {
        url = WebdavUrlStreamHandler.addCredentials(contextId, url);
        String serverId = WebdavUrlStreamHandler.computeServerId("webdav-" + url.toExternalForm());
        PasswordAuthentication passwordAuthentication = CredentialsStore.get(contextId, serverId);
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        String userName = passwordAuthentication != null ? passwordAuthentication.getUserName() : rb.getMessage("Anonymous");
        List<String> headerKeys = Collections.singletonList("X-Requested-With");
        List<String> headerValues = Collections.singletonList("x");
        this.webdavLockHelper.setLockOwner(contextId, userName);
        this.webdavLockHelper.updateLock(contextId, url, timeoutSeconds, headerKeys, headerValues);
    }

    public boolean isLockEnabled() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String optionValue = optionsStorage.getOption("webdav.lock_on_open", "on");
        return "on".equals(optionValue);
    }
}

