/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import com.oxygenxml.examples.webdav.CredentialsStore;
import com.oxygenxml.examples.webdav.WebdavUrlStreamHandler;
import java.net.URL;
import java.util.Map;
import ro.sync.ecss.extensions.api.webapp.access.EditingSessionOpenVetoException;
import ro.sync.ecss.extensions.api.webapp.access.WebappEditingSessionLifecycleListener;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.plugin.workspace.WorkspaceAccessPluginExtension;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class UserNameSetterExtension
implements WorkspaceAccessPluginExtension {
    private static final String SESSION_ID = "session-id";
    private static final String USER_NAME = "userName";

    public void applicationStarted(StandalonePluginWorkspace pluginWorkspaceAccess) {
        WebappPluginWorkspace ws = (WebappPluginWorkspace)pluginWorkspaceAccess;
        ws.addEditingSessionLifecycleListener(new WebappEditingSessionLifecycleListener(){

            public void editingSessionAboutToBeStarted(String docId, String licenseeId, URL systemId, Map<String, Object> options) throws EditingSessionOpenVetoException {
                if (systemId.getProtocol().startsWith("webdav-")) {
                    String userName = (String)options.get(UserNameSetterExtension.USER_NAME);
                    if (UserNameSetterExtension.this.isAnonymousUser(userName)) {
                        return;
                    }
                    String sessionId = (String)options.get(UserNameSetterExtension.SESSION_ID);
                    if (sessionId == null) {
                        return;
                    }
                    String serverId = WebdavUrlStreamHandler.computeServerId(systemId.toExternalForm());
                    CredentialsStore.putIfAbsentWithoutSessionCookieRefresh(sessionId, serverId, userName, "");
                }
            }
        });
    }

    private boolean isAnonymousUser(String userName) {
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        return userName == null || rb.getMessage("Anonymous").equals(userName);
    }

    public boolean applicationClosing() {
        return true;
    }
}

