/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.workspace.security.Response;
import ro.sync.exml.plugin.workspace.security.TrustedHostsProviderExtension;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class TrustedHostsProvider
implements TrustedHostsProviderExtension {
    private static final Logger log = LoggerFactory.getLogger(TrustedHostsProvider.class);
    private AtomicReference<String> enforcedHostRef = new AtomicReference<Object>(null);

    public TrustedHostsProvider() {
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.updateEnforcedHost(optionsStorage);
        optionsStorage.addOptionListener(new WSOptionListener("webdav.enforced_url"){

            public void optionValueChanged(WSOptionChangedEvent event) {
                TrustedHostsProvider.this.updateEnforcedHost(optionsStorage);
            }
        });
    }

    private void updateEnforcedHost(WSOptionsStorage optionsStorage) {
        this.enforcedHostRef.set(null);
        String enforcedUrl = optionsStorage.getOption("webdav.enforced_url", "");
        if (enforcedUrl != null && !enforcedUrl.isEmpty()) {
            try {
                URL url = new URL(enforcedUrl);
                this.enforcedHostRef.set(url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort()));
            }
            catch (MalformedURLException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public Response isTrusted(String hostName) {
        String enforcedHost = this.enforcedHostRef.get();
        if (hostName.equals(enforcedHost)) {
            return TRUSTED;
        }
        return UNKNOWN;
    }
}

