/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import com.oxygenxml.examples.webdav.CredentialsStore;
import com.oxygenxml.examples.webdav.WebdavUrlStreamHandler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;

public class LoginServlet
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(LoginServlet.class);

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        String sessionId = httpRequest.getSession().getId();
        String action = httpRequest.getParameter("action");
        if ("logout".equals(action)) {
            CredentialsStore.invalidate(sessionId);
        } else {
            String serverId = WebdavUrlStreamHandler.computeServerId(httpRequest.getParameter("server"));
            String user = httpRequest.getParameter("user");
            String passwd = httpRequest.getParameter("passwd");
            log.debug("Credentials submitted for session: " + sessionId + ".\n user - " + user + ", passwd - " + passwd + ", serverId -" + serverId);
            CredentialsStore.put(sessionId, serverId, user, passwd);
        }
    }

    public String getPath() {
        return "login";
    }
}

