/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webdav;

import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class CredentialsStore {
    public static synchronized void put(String sessionId, String serverId, String userName, String password) {
        String encryptedPass = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(password);
        HashMap<String, UsrPass> webdavServersCredentials = (HashMap<String, UsrPass>)CredentialsStore.getSessionStore().get(sessionId, CredentialsStore.getCredentialsKey());
        if (webdavServersCredentials == null) {
            webdavServersCredentials = new HashMap<String, UsrPass>();
            CredentialsStore.getSessionStore().put(sessionId, CredentialsStore.getCredentialsKey(), webdavServersCredentials);
        }
        webdavServersCredentials.put(serverId, new UsrPass(userName, encryptedPass));
    }

    public static synchronized void putIfAbsentWithoutSessionCookieRefresh(String sessionId, String serverId, String userName, String password) {
        String encryptedPass = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(password);
        HashMap<String, UsrPass> webdavServersCredentials = (HashMap<String, UsrPass>)CredentialsStore.getSessionStore().get(sessionId, CredentialsStore.getCredentialsKey());
        if (webdavServersCredentials == null) {
            webdavServersCredentials = new HashMap<String, UsrPass>();
            webdavServersCredentials.put(serverId, new UsrPass(userName, encryptedPass));
            CredentialsStore.getSessionStore().putWithoutSessionCookieRefresh(sessionId, CredentialsStore.getCredentialsKey(), webdavServersCredentials);
        } else {
            webdavServersCredentials.putIfAbsent(serverId, new UsrPass(userName, encryptedPass));
        }
    }

    public static synchronized PasswordAuthentication get(String sessionId, String serverId) {
        UsrPass usrPass;
        Map webdavServersCredentials = (Map)CredentialsStore.getSessionStore().get(sessionId, CredentialsStore.getCredentialsKey());
        if (webdavServersCredentials != null && (usrPass = (UsrPass)webdavServersCredentials.get(serverId)) != null) {
            String decryptedPass = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(usrPass.encryptedPassword);
            return new PasswordAuthentication(usrPass.username, decryptedPass.toCharArray());
        }
        return null;
    }

    public static synchronized void invalidate(String sessionId) {
        CredentialsStore.getSessionStore().remove(sessionId, CredentialsStore.getCredentialsKey());
    }

    private static String getCredentialsKey() {
        return "webdav.creds";
    }

    private static SessionStore getSessionStore() {
        WebappPluginWorkspace workspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        return workspace.getSessionStore();
    }

    private static final class UsrPass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String username;
        String encryptedPassword;

        UsrPass(String userName, String encryptedPassword) {
            this.username = userName;
            this.encryptedPassword = encryptedPassword;
        }
    }
}

