/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.allplatforms;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class KeystoreVerifier {
    private File keystoreFile;

    public KeystoreVerifier(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public void canLoadWithoutPassword() {
        KeyStore ks = this.loadKeystore();
        X509Certificate cert = this.getCertificate(ks);
        if (cert == null) {
            throw new IllegalStateException("Could not extract certificate from keystore " + this.keystoreFile + " Make sure the certificates can be extracted without providing a password by using the following command 'keytool.exe -list -v -keystore <kestore-file>'");
        }
    }

    private KeyStore loadKeystore() {
        KeyStore keyStore;
        FileInputStream keystore = new FileInputStream(this.keystoreFile);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(keystore, null);
            keyStore = ks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)keystore).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalStateException(e);
            }
        }
        ((InputStream)keystore).close();
        return keyStore;
    }

    private X509Certificate getCertificate(KeyStore keyStore) {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            return (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }
}

