/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.allplatforms;

import com.oxygenxml.webapp.allplatforms.KeystoreVerifier;
import com.oxygenxml.webapp.installer.ShiroHasher;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class EntryPoint {
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static String adminUsername = null;
    private static String adminPassword = null;

    public static void main(String[] args) {
        int exitCode = 1;
        double javaVersion = EntryPoint.getJavaMajorVersion(System.getProperty("java.version"));
        if (javaVersion > 1.7) {
            try {
                File keystoreFile = new File("tomcat/conf/web-author.keystore");
                EntryPoint.generateKeystore(keystoreFile);
                EntryPoint.verifyKeystore(keystoreFile);
            }
            catch (IOException | InterruptedException e) {
                EntryPoint.log("Failed to configure HTTPS " + e.getMessage());
            }
            EntryPoint.handleShiroUsersSettings();
            exitCode = 0;
        }
        System.exit(exitCode);
    }

    private static void verifyKeystore(File keystoreFile) {
        KeystoreVerifier verifier = new KeystoreVerifier(keystoreFile);
        verifier.canLoadWithoutPassword();
    }

    static void generateKeystore(File keystoreFile) throws IOException, InterruptedException {
        if (keystoreFile.exists()) {
            return;
        }
        String keytoolPath = new File(System.getProperty("java.home"), "bin/keytool" + (System.getProperty("os.name").startsWith("Windows") ? ".exe" : "")).getAbsolutePath();
        ProcessBuilder processBuilder = new ProcessBuilder(keytoolPath, "-genkey", "-alias", "web-author", "-keyalg", "RSA", "-keystore", keystoreFile.getAbsolutePath(), "-storepass", DEFAULT_KEYSTORE_PASSWORD, "-keypass", DEFAULT_KEYSTORE_PASSWORD, "-dname", "CN=CA", "-validity", "3650", "-keysize", "2048", "-noprompt", "-deststoretype", "JKS");
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        int errCode = process.waitFor();
        if (errCode != 0) {
            EntryPoint.printStream(process.getInputStream());
            EntryPoint.printStream(process.getErrorStream());
        }
    }

    private static void printStream(InputStream inputStream) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line = null;
            while ((line = br.readLine()) != null) {
                EntryPoint.log(line);
            }
        }
    }

    static double getJavaMajorVersion(String javaVersionSystemPropertyValue) {
        double javaVersion;
        if (javaVersionSystemPropertyValue.matches("\\d[.]\\d.*")) {
            javaVersion = Double.parseDouble(javaVersionSystemPropertyValue.substring(0, 3));
        } else {
            javaVersionSystemPropertyValue = javaVersionSystemPropertyValue.replaceAll("[^\\d].*$", "");
            javaVersion = Double.parseDouble(javaVersionSystemPropertyValue);
        }
        return javaVersion;
    }

    private static void handleShiroUsersSettings() {
        File settingsFile = new File("tomcat/work/Catalina/localhost/oxygen-xml-web-author/shiro-users.ini");
        String settingFileNewContent = EntryPoint.getNewShiroSettingsContent(settingsFile);
        if (settingFileNewContent != null) {
            EntryPoint.replaceFileContent(settingsFile, settingFileNewContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void replaceFileContent(File file, String settingFileNewContent) {
        File tempFile = null;
        BufferedWriter writer = null;
        boolean replaceFile = false;
        try {
            tempFile = new File(file.getParentFile(), file.getName() + ".temp");
            FileOutputStream fos = new FileOutputStream(tempFile);
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                fos.close();
            }
            writer.write(settingFileNewContent.toString());
            replaceFile = true;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    replaceFile = false;
                    e.printStackTrace();
                }
                finally {
                    if (!replaceFile) {
                        tempFile.delete();
                    } else {
                        file.delete();
                        tempFile.renameTo(file);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNewShiroSettingsContent(File settingsFile) {
        String userConfigPlaceholder = "${installer:shiroUsernameConfig}";
        boolean placeholdersReplaced = false;
        StringBuilder settingFileNewContent = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(settingsFile)));
            String currentLine = null;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.indexOf("${installer:shiroUsernameConfig}") != -1) {
                    String adminConfig = EntryPoint.getShiroAdminConfig();
                    currentLine = currentLine.replace("${installer:shiroUsernameConfig}", adminConfig);
                    placeholdersReplaced = true;
                }
                settingFileNewContent.append(currentLine).append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            placeholdersReplaced = false;
            EntryPoint.log(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    EntryPoint.log(e.getMessage());
                }
            }
        }
        if (placeholdersReplaced) {
            return settingFileNewContent.toString();
        }
        return null;
    }

    private static String getShiroAdminConfig() {
        String shiroAdminUsername = EntryPoint.getAdminUsername();
        String shiroAdminPassword = EntryPoint.getAdminPassword();
        Properties props = new Properties();
        props.setProperty("user." + shiroAdminUsername, shiroAdminPassword + ", admin");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.store(baos, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toString();
    }

    private static String trimConsecutiveWhitespaces(String credential) {
        return credential.replaceAll("(\\s)\\s+", "$1");
    }

    private static String getAdminUsername() {
        if (adminUsername == null) {
            EntryPoint.log("Set up administrator account");
            while (adminUsername == null || adminUsername.isEmpty()) {
                adminUsername = EntryPoint.trimConsecutiveWhitespaces(System.console().readLine("Admin user name:", new Object[0]));
                if (adminUsername.length() >= 1) continue;
                EntryPoint.log("The username must not be empty.");
                adminUsername = null;
            }
        }
        return adminUsername;
    }

    private static String getAdminPassword() {
        if (adminPassword == null) {
            boolean passwordsMatch = false;
            do {
                if ((adminPassword = EntryPoint.trimConsecutiveWhitespaces(new String(System.console().readPassword("Password:", new Object[0])))).length() < 12) {
                    EntryPoint.log("The password must have at least 12 characters.");
                    adminPassword = null;
                    continue;
                }
                if (adminPassword.length() > 128) {
                    EntryPoint.log("The password must have at most 128 characters.");
                    adminPassword = null;
                    continue;
                }
                if (adminPassword.equals(EntryPoint.trimConsecutiveWhitespaces(new String(System.console().readPassword("Confirm password:", new Object[0]))))) {
                    adminPassword = ShiroHasher.shiroDigestPassword((String)adminPassword);
                    passwordsMatch = true;
                    continue;
                }
                EntryPoint.log("Passwords do not match, try again !");
            } while (!passwordsMatch);
        }
        return adminPassword;
    }

    private static boolean isWindows() {
        boolean isWindows = false;
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS != null && OS.indexOf("win") != -1) {
            isWindows = true;
        }
        return isWindows;
    }

    private static void log(String message) {
        System.out.println(message);
    }
}

