/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.webapp.installer;

import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.crypto.hash.format.DefaultHashFormatFactory;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;
import org.apache.shiro.lang.util.ByteSource;

public class ShiroHasher {
    public static String shiroDigestPassword(String password) {
        SecureRandomNumberGenerator generator = new SecureRandomNumberGenerator();
        ByteSource salt = generator.nextBytes(32);
        SimpleHash hash = new SimpleHash("SHA-256", (Object)password.toCharArray(), salt);
        return ShiroHasher.shiroHash(hash);
    }

    public static String shiroDigestPassword(String password, String algorithmName, byte[] salt, int iterations) {
        if (algorithmName == null) {
            algorithmName = "SHA-256";
        }
        SimpleHash hash = new SimpleHash(algorithmName, password.toCharArray(), ByteSource.Util.bytes(salt), iterations);
        return ShiroHasher.shiroHash(hash);
    }

    private static String shiroHash(SimpleHash hash) {
        DefaultHashFormatFactory hashFactory = new DefaultHashFormatFactory();
        HashFormat format = hashFactory.getInstance(Shiro1CryptFormat.class.getName());
        return format.format(hash);
    }
}

