/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.authflow.UserPassEmailCredentialsProvider;
import com.oxygenxml.examples.bitbucket.BitbucketAccessToken;
import com.oxygenxml.examples.bitbucket.BitbucketApi;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerAccessToken;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerApi;
import com.oxygenxml.examples.git.GitAccess;
import com.oxygenxml.examples.git.RESTGitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.github.apiclient.GitHubV3Api;
import com.oxygenxml.examples.gitlab.GitlabAccessToken;
import com.oxygenxml.examples.gitlab.GitlabApi;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitReadApi;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;

public class WebAuthorGitApis {
    private WebAuthorGitApis() {
    }

    public static WebAuthorGitReadApi create(String contextId, CredentialTypes type) throws UserActionRequiredException {
        switch (type) {
            case GITHUB: {
                return WebAuthorGitApis.createGitHubApi(contextId);
            }
            case BITBUCKET: {
                return WebAuthorGitApis.createBitbucketApi(contextId);
            }
            case BITBUCKET_SERVER: {
                return WebAuthorGitApis.createBitbucketServerApi(contextId);
            }
            case GITLAB: {
                return WebAuthorGitApis.createGitlabApi(contextId, false);
            }
            case GITLAB_E: {
                return WebAuthorGitApis.createGitlabApi(contextId, true);
            }
        }
        return WebAuthorGitApis.createGenericGitApi(contextId);
    }

    public static GitHubV3Api createGitHubApi(String contextId) throws UserActionRequiredException {
        String apiUrl = GitCredentialsProvider.getGitHubApiUrl();
        String accessToken = (String)GitCredentialsProvider.getAccessToken(contextId, CredentialTypes.GITHUB);
        WebAuthorGitApis.ensureAuthenticated(accessToken);
        return new GitHubV3Api(apiUrl, accessToken);
    }

    public static BitbucketApi createBitbucketApi(String contextId) throws UserActionRequiredException {
        BitbucketAccessToken accessToken = (BitbucketAccessToken)GitCredentialsProvider.getAccessToken(contextId, CredentialTypes.BITBUCKET);
        WebAuthorGitApis.ensureAuthenticated(accessToken);
        UserPassEmailCredentialsProvider credentialsProvider = GitCredentialsProvider.getCredentials(contextId, CredentialTypes.BITBUCKET);
        WebAuthorGitApis.ensureAuthenticated((Object)credentialsProvider);
        return new BitbucketApi(contextId, accessToken, new GitAccess(RESTGitAccess.repositoryProvider, RESTGitAccess.merger, credentialsProvider));
    }

    public static BitbucketServerApi createBitbucketServerApi(String sessionId) throws UserActionRequiredException {
        BitbucketServerAccessToken accessToken = (BitbucketServerAccessToken)GitCredentialsProvider.getAccessToken(sessionId, CredentialTypes.BITBUCKET_SERVER);
        WebAuthorGitApis.ensureAuthenticated(accessToken);
        return new BitbucketServerApi(accessToken);
    }

    public static GitlabApi createGitlabApi(String contextId, boolean isOnPremise) throws UserActionRequiredException {
        CredentialTypes credentialTypes = isOnPremise ? CredentialTypes.GITLAB_E : CredentialTypes.GITLAB;
        GitlabAccessToken accessToken = (GitlabAccessToken)GitCredentialsProvider.getAccessToken(contextId, credentialTypes);
        String apiPrefix = isOnPremise ? GitCredentialsProvider.getGitlabEnterpriseApiUrl() : "https://gitlab.com";
        WebAuthorGitApis.ensureAuthenticated(accessToken);
        UserPassEmailCredentialsProvider credentialsProvider = GitCredentialsProvider.getCredentials(contextId, credentialTypes);
        WebAuthorGitApis.ensureAuthenticated((Object)credentialsProvider);
        return new GitlabApi(isOnPremise, apiPrefix, new GitAccess(RESTGitAccess.repositoryProvider, RESTGitAccess.merger, credentialsProvider), contextId);
    }

    public static GitAccess createGenericGitApi(String contextId) throws UserActionRequiredException {
        UserPassEmailCredentialsProvider credentialsProvider = GitCredentialsProvider.getCredentials(contextId, CredentialTypes.USERPASS);
        WebAuthorGitApis.ensureAuthenticated((Object)credentialsProvider);
        return new GitAccess(RESTGitAccess.repositoryProvider, RESTGitAccess.merger, credentialsProvider);
    }

    public static GitAccess createGenericGitApiWithGithubCredentials(String contextId) throws UserActionRequiredException {
        UserPassEmailCredentialsProvider credentialsProvider = GitCredentialsProvider.getCredentials(contextId, CredentialTypes.GITHUB);
        WebAuthorGitApis.ensureAuthenticated((Object)credentialsProvider);
        return new GitAccess(RESTGitAccess.repositoryProvider, RESTGitAccess.merger, credentialsProvider);
    }

    private static void ensureAuthenticated(Object credentials) throws UserActionRequiredException {
        if (credentials == null) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
    }
}

