/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitReadApi;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmodulesResolver {
    private static final Logger log = LoggerFactory.getLogger(SubmodulesResolver.class);
    private static final String SUBMODULE_SECTION_NAME = "submodule";
    private static final Pattern GIT_TO_HTTPS_PATTERN = Pattern.compile("^git@([^:]+):(.*)$");
    private static final Cache<RepositoryLocation, List<RepositoryLocation>> SUBMODULES_CACHE = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(8L, TimeUnit.MINUTES).build();

    public RepositoryLocation resolveSubmodule(RepositoryLocation location, WebAuthorGitReadApi reader) throws NotAuthorizedException {
        if (!"on".equals(GitCredentialsProvider.isGitResolveSubmodules())) {
            return location;
        }
        RepositoryLocation resolvedLocation = location;
        Optional<RepositoryLocation> locationSubmodule = this.getSubmoduleForLocation(location, reader);
        if (locationSubmodule.isPresent()) {
            RepositoryLocation submoduleDescriptor;
            try {
                submoduleDescriptor = this.normalizeSubmoduleDescriptor(location.getRepositoryUri(), locationSubmodule.get());
            }
            catch (URISyntaxException e) {
                throw new UnexpectedException(e.getMessage(), e);
            }
            String submodulePath = submoduleDescriptor.getPath();
            String filePath = location.getPath();
            String resolvedFilePath = filePath.substring(filePath.indexOf(submodulePath) + submodulePath.length());
            if (resolvedFilePath.startsWith("/")) {
                resolvedFilePath = resolvedFilePath.substring(1);
            }
            resolvedLocation = new RepositoryLocation(submoduleDescriptor.getRepositoryUri(), submoduleDescriptor.getBranch(), resolvedFilePath);
        }
        if (!resolvedLocation.equals(location)) {
            resolvedLocation = this.resolveSubmodule(resolvedLocation, reader);
        }
        return resolvedLocation;
    }

    private Optional<RepositoryLocation> getSubmoduleForLocation(RepositoryLocation location, WebAuthorGitReadApi reader) throws NotAuthorizedException {
        List<RepositoryLocation> descriptors = this.getSubmoduleDescriptors(location, reader);
        return descriptors.stream().filter(d -> {
            String submodulePath;
            String locationPath = location.getPath();
            return locationPath.equals(submodulePath = d.getPath()) || locationPath.startsWith(submodulePath + "/");
        }).findFirst();
    }

    @VisibleForTesting
    RepositoryLocation normalizeSubmoduleDescriptor(String parentRepositoryUri, RepositoryLocation descriptor) throws URISyntaxException {
        RepositoryLocation normalized;
        boolean isRelativePath;
        Object url = descriptor.getRepositoryUri();
        Matcher m = GIT_TO_HTTPS_PATTERN.matcher((CharSequence)url);
        if (m.matches()) {
            url = new URI(parentRepositoryUri).getScheme() + "://" + m.group(1) + "/" + m.group(2);
        }
        boolean bl = isRelativePath = !new URI((String)url).isAbsolute();
        if (isRelativePath) {
            if (!((String)url).startsWith("/")) {
                url = "/" + (String)url;
            }
            URI normalizedUrl = new URI(parentRepositoryUri + (String)url).normalize();
            normalized = new RepositoryLocation(normalizedUrl.toString(), descriptor.getBranch(), descriptor.getPath());
        } else {
            normalized = new RepositoryLocation((String)url, descriptor.getBranch(), descriptor.getPath());
        }
        return normalized;
    }

    @VisibleForTesting
    List<RepositoryLocation> getSubmoduleDescriptors(RepositoryLocation repositoryLocation, WebAuthorGitReadApi reader) throws NotAuthorizedException {
        RepositoryLocation gitModulesLocation = repositoryLocation.getGitModulesLocation();
        List descriptors = Collections.emptyList();
        try {
            descriptors = (List)SUBMODULES_CACHE.get((Object)gitModulesLocation, () -> {
                try (InputStream submodulesSource = reader.read(gitModulesLocation);){
                    String defaultBranch = gitModulesLocation.getBranch();
                    List<RepositoryLocation> list = this.extractSubmodulesLocations(submodulesSource, defaultBranch);
                    return list;
                }
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NotFoundException) {
                SUBMODULES_CACHE.put((Object)gitModulesLocation, (Object)descriptors);
            }
            if (cause instanceof NotAuthorizedException) {
                throw (NotAuthorizedException)cause;
            }
            if (cause instanceof UnexpectedException) {
                throw (UnexpectedException)cause;
            }
            throw new UnexpectedException(cause.getMessage(), cause);
        }
        return descriptors;
    }

    List<RepositoryLocation> extractSubmodulesLocations(InputStream submodulesSource, String currentBranch) throws ConfigInvalidException, IOException {
        ArrayList<RepositoryLocation> descr = new ArrayList<RepositoryLocation>();
        BlobBasedConfig submodules = new BlobBasedConfig(new Config(), IOUtils.toByteArray((InputStream)submodulesSource));
        for (String section : submodules.getSubsections(SUBMODULE_SECTION_NAME)) {
            String branch = submodules.getString(SUBMODULE_SECTION_NAME, section, "branch");
            if (branch == null) {
                branch = "master";
            } else if (branch.equals(".")) {
                branch = currentBranch;
            }
            String repositoryUri = submodules.getString(SUBMODULE_SECTION_NAME, section, "url");
            String path = submodules.getString(SUBMODULE_SECTION_NAME, section, "path");
            if (repositoryUri != null && path != null) {
                descr.add(new RepositoryLocation(repositoryUri, branch, path));
                continue;
            }
            log.warn(".gitmodules module missing required params: " + section);
        }
        return descr;
    }
}

