/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.examples.webauthorgitapi.GitCommitMessagesHistoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.access.IWebappAuthorEditorAccess;

@WebappRestSafe
public class RetrieveCommitMessagesHistoryOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(RetrieveCommitMessagesHistoryOperation.class);

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws IllegalArgumentException, AuthorOperationException {
        GitCommitMessagesHistoryManager commitMessagesManager = new GitCommitMessagesHistoryManager();
        String sessionId = this.getUserInfoFromEditorLocation(model);
        String response = "{}";
        try {
            response = new ObjectMapper().writeValueAsString(commitMessagesManager.getLastCommitMessagesHistory(sessionId));
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private String getUserInfoFromEditorLocation(AuthorDocumentModel model) {
        IWebappAuthorEditorAccess editorAccess = (IWebappAuthorEditorAccess)model.getAuthorAccess().getEditorAccess();
        return URLUtil.getUserInfo((String)editorAccess.getEditorLocation().toString());
    }
}

