/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.oxygenxml.examples.webauthorgitapi.RepositoryBranch;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Collectors;
import ro.sync.basic.util.URLUtil;

public class RepositoryLocation {
    private String repositoryUri;
    private String branch;
    private String path;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.repositoryUri == null ? 0 : this.repositoryUri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryLocation other = (RepositoryLocation)obj;
        if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.repositoryUri == null ? other.repositoryUri != null : !this.repositoryUri.equals(other.repositoryUri));
    }

    public RepositoryLocation(String repositoryUri, String branch, String path) {
        this.repositoryUri = repositoryUri.replaceAll("\\\\", "/");
        this.branch = branch;
        this.path = path.replaceAll("\\\\", "/");
    }

    public RepositoryLocation(URL gitUrl) {
        String[] branchAndPath = gitUrl.getPath().split("/", 3);
        this.repositoryUri = URLUtil.decodeURIComponent((String)gitUrl.getHost());
        this.branch = URLUtil.decodeURIComponent((String)branchAndPath[1]);
        this.path = branchAndPath.length > 2 ? Arrays.asList(branchAndPath[2].split("/")).stream().map(URLUtil::decodeURIComponent).collect(Collectors.joining("/")) : "";
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }

    public String getBranch() {
        return this.branch;
    }

    public RepositoryBranch getRepositoryBranch() {
        return new RepositoryBranch(this.repositoryUri, this.branch);
    }

    public String getPath() {
        return this.path;
    }

    @JsonIgnore
    public RepositoryLocation getGitModulesLocation() {
        return new RepositoryLocation(this.repositoryUri, this.branch, ".gitmodules");
    }

    public String toString() {
        return "RepositoryLocation [repositoryUri=" + this.repositoryUri + ", branch=" + this.branch + ", path=" + this.path + "]";
    }
}

