/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.bitbucketserver.oauth.RsaKeysGenerator;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.GitDocumentInfo;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApis;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultFail;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultMerge;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultOK;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.ecss.extensions.api.webapp.plugin.WebappServletPluginExtension;
import ro.sync.merge.MergeResult;

public class RESTGitApi
extends WebappServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(RESTGitApi.class);
    private static final String REPOSITORY_URI = "repositoryUri";
    private static final String BRANCH = "branch";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String STATUS_HEADER_NAME = "OXY-C-STATUS";
    private static final String MERGE_RESULT_HEADER_NAME = "OXY-Merge-Result";
    private static final String LATEST_SHA_HEADER_NAME = "OXY-LATEST-SHA";

    public String getPath() {
        return "gitapi";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqPath = req.getPathInfo();
        if (reqPath.indexOf("/getuserinfo") != -1) {
            this.handleGetUserInfoRequest(req, resp);
        } else if (reqPath.indexOf("/getuserrepos") != -1) {
            this.handleGetUserReposRequest(req, resp);
        } else if (reqPath.indexOf("/getbranches") != -1) {
            this.handleGetBranchesRequest(req, resp);
        } else if (reqPath.indexOf("/getdocument") != -1) {
            this.handleGetDocumentRequest(req, resp);
        } else if (reqPath.indexOf("/canpush") != -1) {
            this.handleCanPushRequest(req, resp);
        } else if (reqPath.indexOf("/branchexists") != -1) {
            this.handleBranchExistsRequest(req, resp);
        } else if (reqPath.indexOf("/generate-bbsv-keys") != -1) {
            this.handleGenerateBbsvKeysRequest(resp);
        } else {
            resp.setStatus(404);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqPath = req.getPathInfo();
        if (reqPath.indexOf("/commit") != -1 || reqPath.indexOf("/write") != -1) {
            this.handleCommitAndWriteRequests(req, resp);
        } else if (reqPath.indexOf("/pullrequest") != -1) {
            this.handlePullRequestRequest(req, resp);
        } else if (reqPath.indexOf("/createfork") != -1) {
            this.handleCreateForkRequest(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    private void handleGetUserInfoRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            UserInformation userInformation = gitApi.getUserInformation();
            OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), (Object)userInformation);
        }
        catch (NotAuthorizedException | UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleGetUserReposRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            List<String> userRepos = gitApi.getUserRepositories();
            OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), userRepos);
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(401);
        }
        catch (UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleGetBranchesRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            String repositoryUri = Functions.getQueryParamFromQueryString(REPOSITORY_URI, req.getQueryString());
            List<String> repoBranches = gitApi.getRepoBranches(repositoryUri);
            OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), repoBranches);
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(401);
        }
        catch (UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleGetDocumentRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            String queryString = req.getQueryString();
            String repositoryUri = Functions.getQueryParamFromQueryString(REPOSITORY_URI, queryString);
            String branch = Functions.getQueryParamFromQueryString(BRANCH, queryString);
            String path = Functions.getQueryParamFromQueryString("path", queryString);
            RepositoryLocation location = new RepositoryLocation(repositoryUri, branch, path);
            GitDocumentInfo documentInfo = gitApi.getDocument(location);
            OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), (Object)documentInfo);
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(401);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            resp.setStatus(404);
        }
        catch (UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleCanPushRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            String queryString = req.getQueryString();
            String repositoryUri = Functions.getQueryParamFromQueryString(REPOSITORY_URI, queryString);
            String branch = Functions.getQueryParamFromQueryString(BRANCH, queryString);
            boolean canPushInRepository = gitApi.canPushInRepository(repositoryUri);
            boolean canPushOnBranch = gitApi.canPushOnBranch(repositoryUri, branch);
            ArrayList<Boolean> canPush = new ArrayList<Boolean>();
            canPush.add(canPushInRepository);
            canPush.add(canPushOnBranch);
            OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), canPush);
        }
        catch (NotAuthorizedException | UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            resp.setStatus(500);
        }
    }

    private void handleCommitAndWriteRequests(HttpServletRequest req, HttpServletResponse resp) {
        try {
            CommitResult commitResult;
            Map<String, Object> requestBody;
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            try (ServletInputStream requestBodyInputStream = req.getInputStream();){
                String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)requestBodyInputStream);
                requestBody = GitUtil.parseJSON(requestBodyString);
            }
            String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
            String branch = (String)requestBody.get(BRANCH);
            String path = (String)requestBody.get("path");
            RepositoryLocation location = new RepositoryLocation(repositoryUri, branch, path);
            String content = (String)requestBody.get("content");
            String message = (String)requestBody.get("message");
            Map docInfo = (Map)requestBody.get("docInfo");
            if (docInfo == null) {
                commitResult = gitApi.write(location, content, message);
            } else {
                String commitSha = (String)docInfo.get("commitSha");
                String documentSha = (String)docInfo.get("documentSha");
                String documentContent = (String)docInfo.get("documentContent");
                GitDocumentInfo documentInfo = new GitDocumentInfo(documentContent, documentSha, commitSha);
                commitResult = gitApi.commit(location, content, message, documentInfo);
            }
            if (commitResult instanceof CommitResultOK) {
                resp.addHeader(STATUS_HEADER_NAME, "ok");
                OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), (Object)commitResult);
            } else if (commitResult instanceof CommitResultMerge) {
                resp.addHeader(STATUS_HEADER_NAME, "merge");
                CommitResultMerge merge = (CommitResultMerge)commitResult;
                MergeResult mergeResult = merge.getMergeResult();
                MergeResult.ResultType resultType = mergeResult.getResultType();
                resp.addHeader(MERGE_RESULT_HEADER_NAME, resultType.name());
                resp.addHeader(LATEST_SHA_HEADER_NAME, merge.getLatestFileSha());
                String mergedFileContent = mergeResult.getMergedString();
                resp.setCharacterEncoding(StandardCharsets.UTF_8.toString());
                resp.setContentType("text/plain");
                resp.getWriter().write(mergedFileContent);
                resp.flushBuffer();
            } else if (commitResult instanceof CommitResultFail) {
                resp.addHeader(STATUS_HEADER_NAME, "fail");
                CommitResultFail fail = (CommitResultFail)commitResult;
                resp.setContentType("text/plain");
                resp.getWriter().write(fail.getReason());
            }
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.addHeader(STATUS_HEADER_NAME, "no-access");
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(401);
        }
        catch (NotFoundException | UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            resp.addHeader(STATUS_HEADER_NAME, "fail");
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleBranchExistsRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            String queryString = req.getQueryString();
            String repositoryUri = Functions.getQueryParamFromQueryString(REPOSITORY_URI, queryString);
            String branch = Functions.getQueryParamFromQueryString(BRANCH, queryString);
            branch = branch.replace(" ", "_");
            branch = branch.replace("~", "_");
            branch = branch.replace("^", "_");
            branch = branch.replace(":", "_");
            branch = branch.replace("\\", "_");
            List<String> repoBranches = gitApi.getRepoBranches(repositoryUri);
            String newBranch = Functions.branchExistsInListOfBranches(branch, repoBranches);
            resp.addHeader("Content-Type", "application/json; charset=utf-8");
            resp.addHeader(STATUS_HEADER_NAME, "success");
            if (!branch.equals(newBranch)) {
                resp.setContentType("application/json");
                resp.getWriter().write("{\"branchExists\": true,\"nextAvailable\": " + OBJECT_MAPPER.writeValueAsString((Object)newBranch) + "}");
            } else {
                resp.setContentType("application/json");
                resp.getWriter().write("{\"branchExists\": false,\"nextAvailable\": " + OBJECT_MAPPER.writeValueAsString((Object)branch) + "}");
            }
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(401);
        }
        catch (UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handlePullRequestRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            Map<String, Object> requestBody;
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            try (ServletInputStream requestBodyInputStream = req.getInputStream();){
                String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)requestBodyInputStream);
                requestBody = GitUtil.parseJSON(requestBodyString);
            }
            String sourceRepositoryUri = (String)requestBody.get("sourceRepositoryUri");
            String destinationRepositoryUri = (String)requestBody.get("destinationRepositoryUri");
            String sourceBranch = (String)requestBody.get("sourceBranch");
            String destinationBranch = (String)requestBody.get("destinationBranch");
            String pullRequestMessage = (String)requestBody.get("pullRequestMessage");
            String pullRequestTitle = (String)requestBody.get("pullRequestTitle");
            String openedPullRequestUrl = gitApi.openPullRequest(sourceRepositoryUri, destinationRepositoryUri, sourceBranch, destinationBranch, pullRequestMessage, pullRequestTitle);
            resp.setContentType("text/plain");
            resp.getWriter().write(openedPullRequestUrl);
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(401);
        }
        catch (UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleCreateForkRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            Map<String, Object> requestBody;
            WebAuthorGitApi gitApi = this.parseAndCreateGitApi(req);
            try (ServletInputStream requestBodyInputStream = req.getInputStream();){
                String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)requestBodyInputStream);
                requestBody = GitUtil.parseJSON(requestBodyString);
            }
            String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
            String forkRepositoryUri = gitApi.createFork(repositoryUri);
            resp.setContentType("text/plain");
            resp.getWriter().write(forkRepositoryUri);
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            log.error(e.getMessage(), e);
            resp.setStatus(401);
        }
        catch (UnexpectedException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.writeErrorMessage(e.getMessage(), resp);
            resp.setStatus(500);
        }
    }

    private void handleGenerateBbsvKeysRequest(HttpServletResponse resp) {
        Base64.Encoder encoder = Base64.getEncoder();
        KeyPair rsaKeys = RsaKeysGenerator.generateRsaKeys();
        String bitbucketServerPrivateKey = encoder.encodeToString(rsaKeys.getPrivate().getEncoded());
        String bitbucketServerPublicKey = encoder.encodeToString(rsaKeys.getPublic().getEncoded());
        try {
            String responseBody = "{\"privateKey\": " + OBJECT_MAPPER.writeValueAsString((Object)bitbucketServerPrivateKey) + ",\"publicKey\": " + OBJECT_MAPPER.writeValueAsString((Object)bitbucketServerPublicKey) + "}";
            resp.setContentType("application/json");
            resp.getWriter().write(responseBody);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private WebAuthorGitApi parseAndCreateGitApi(HttpServletRequest req) throws IOException {
        CredentialTypes apiType = CredentialTypes.getCredentialType(req.getPathInfo().split("/")[2]);
        String sessionId = req.getSession().getId();
        WebAuthorGitApi gitApi = (WebAuthorGitApi)WebAuthorGitApis.create(sessionId, apiType);
        return gitApi;
    }

    private void writeErrorMessage(String errorMessage, HttpServletResponse resp) {
        try {
            resp.setContentType("text/plain");
            resp.getWriter().write(errorMessage);
        }
        catch (IOException e1) {
            log.error("Error while writing the error message to the body of the HTTP response.", (Throwable)e1);
        }
    }
}

