/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import java.util.ArrayList;
import java.util.List;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class GitCommitMessagesHistoryManager {
    private static final String SIGNED_OFF_BY_MARKER = "Signed-off-by: ";
    private static final String GIT_LAST_COMMIT_MESSAGES = "git.last.commit.messages";

    private SessionStore getSessionStore() {
        WebappPluginWorkspace workspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        return workspace.getSessionStore();
    }

    public void addCommitMessageInHistory(String commitMessage, String sessionId, CredentialTypes credentialType) {
        if (GitCredentialsProvider.isUsingEnforcedCredentials() || GitCredentialsProvider.sessionContainsCredentials(sessionId, credentialType)) {
            commitMessage = this.removeSignedOffPart(commitMessage);
            List<String> lastCommitMessages = this.getLastCommitMessagesHistory(sessionId);
            lastCommitMessages.remove(commitMessage);
            lastCommitMessages.add(0, commitMessage);
            this.getSessionStore().putWithoutSessionCookieRefresh(sessionId, GIT_LAST_COMMIT_MESSAGES, lastCommitMessages);
        }
    }

    public List<String> getLastCommitMessagesHistory(String sessionId) {
        List messages = (List)this.getSessionStore().get(sessionId, GIT_LAST_COMMIT_MESSAGES);
        return messages != null ? messages : new ArrayList(0);
    }

    private String removeSignedOffPart(String commitMessage) {
        int indexOfSignedOffMarker = commitMessage.indexOf(SIGNED_OFF_BY_MARKER);
        if (indexOfSignedOffMarker != -1) {
            commitMessage = commitMessage.substring(0, indexOfSignedOffMarker).trim();
        }
        return commitMessage;
    }
}

