/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.webauthorgitapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerApi;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.common.ThreeWayMerger;
import com.oxygenxml.examples.webauthorgitapi.DocumentToCommit;
import com.oxygenxml.examples.webauthorgitapi.GitBranchInfo;
import com.oxygenxml.examples.webauthorgitapi.GitCommitMessagesHistoryManager;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApis;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitDocumentsOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResultType;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.FailCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.MergeCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.UnsavedContentReferenceManager;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.AuthorOperationWithResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.api.webapp.access.IWebappAuthorEditorAccess;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.merge.MergeConflictResolutionMethods;
import ro.sync.merge.MergeResult;

@WebappRestSafe
public class CommitDocumentsOperation
extends AuthorOperationWithResult {
    private static final Logger log = LoggerFactory.getLogger(CommitDocumentsOperation.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public String doOperation(AuthorDocumentModel model, ArgumentsMap args) throws AuthorOperationException {
        String extraErrorDetails = null;
        WebAuthorGitApi gitApi = null;
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        try {
            String connectorType = (String)args.getArgumentValue("connector");
            gitApi = this.getGitApi(model, connectorType);
            String repositoryUri = (String)args.getArgumentValue("repositoryUri");
            String forkedRepositoryUri = (String)args.getArgumentValue("forkedRepositoryUri");
            String sourceBranch = (String)args.getArgumentValue("sourceBranch");
            String destinationBranch = (String)args.getArgumentValue("destinationBranch");
            String freshDestinationBranch = (String)args.getArgumentValue("freshDestinationBranch");
            Map sourceBranchInfoMap = (Map)args.getArgumentValue("sourceBranchInfo");
            GitBranchInfo sourceBranchInfo = new GitBranchInfo((String)sourceBranchInfoMap.get("initialCommitSha"), (String)sourceBranchInfoMap.get("latestCommitSha"));
            String commitMessage = (String)args.getArgumentValue("commitMessage");
            String conflictResolution = this.parsePossibleConflictResolution(args);
            this.saveLastCommitMessageInHistory(model, commitMessage, connectorType);
            List<DocumentToCommit> documentsToCommit = this.getDocumentsToCommit(model);
            Optional<DocumentToCommit> mainDocument = this.addMainDocumentToCommitList(model, gitApi, sourceBranchInfo.getLatestCommitSha(), documentsToCommit);
            if (conflictResolution != null && conflictResolution.equals("merge_and_commit")) {
                try {
                    this.mergeDocuments(gitApi, documentsToCommit, sourceBranchInfo, true);
                }
                catch (NotAuthorizedException | NotFoundException | UnsupportedEncodingException e) {
                    if (rb != null) {
                        extraErrorDetails = rb.getMessage("Failed_merge_conflict_docs");
                    }
                    throw e;
                }
            }
            if (this.shouldCreateBranch(sourceBranch, destinationBranch, conflictResolution, freshDestinationBranch)) {
                try {
                    this.createBranch(gitApi, sourceBranch, destinationBranch, repositoryUri, forkedRepositoryUri);
                }
                catch (NotAuthorizedException e) {
                    if (rb != null) {
                        extraErrorDetails = rb.getMessage("Failed_create_branch_pull_request");
                    }
                    throw e;
                }
            }
            CommitOperationResult commitResult = this.commitDocuments(gitApi, repositoryUri, forkedRepositoryUri, destinationBranch, sourceBranchInfo.getLatestCommitSha(), documentsToCommit, commitMessage, conflictResolution);
            List<DocumentToCommit> committedDocuments = commitResult.getCommittedDocuments();
            mainDocument.ifPresent(committedDocuments::remove);
            this.markReferencesAsSaved(model, committedDocuments);
            documentsToCommit.removeAll(committedDocuments);
            return this.obtainOperationResult(gitApi, commitResult, documentsToCommit, sourceBranchInfo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleException(gitApi, e, extraErrorDetails);
        }
    }

    @VisibleForTesting
    void saveLastCommitMessageInHistory(AuthorDocumentModel model, String commitMessage, String connectorType) {
        if (commitMessage != null && !commitMessage.isEmpty()) {
            GitCommitMessagesHistoryManager commitMessagesManager = new GitCommitMessagesHistoryManager();
            String sessionId = this.getUserInfoFromEditorLocation(model);
            CredentialTypes credentialType = CredentialTypes.getCredentialType(connectorType);
            commitMessagesManager.addCommitMessageInHistory(commitMessage, sessionId, credentialType);
        }
    }

    private Optional<DocumentToCommit> addMainDocumentToCommitList(AuthorDocumentModel model, WebAuthorGitApi gitApi, String latestCommitSha, List<DocumentToCommit> documentsToCommit) throws IOException, NotAuthorizedException, NotFoundException {
        IWebappAuthorEditorAccess editorAccess = (IWebappAuthorEditorAccess)model.getAuthorAccess().getEditorAccess();
        UnsavedContentReferenceManager unsavedContentReferenceManager = editorAccess.getUnsavedContentReferenceManager();
        DocumentToCommit mainDocumentRef = null;
        if (unsavedContentReferenceManager != null) {
            String latestDocumentContent;
            String documentContent;
            if (unsavedContentReferenceManager.isDocumentUnsaved() && !(documentContent = new String((mainDocumentRef = this.getMainDocumentContent(model)).getContentToCommit(), mainDocumentRef.getEncoding())).equals(latestDocumentContent = gitApi.getContentAtCommit(mainDocumentRef.getLocation(), latestCommitSha, mainDocumentRef.getEncoding()))) {
                documentsToCommit.add(mainDocumentRef);
            }
        } else {
            documentsToCommit.add(this.getMainDocumentContent(model));
        }
        return Optional.ofNullable(mainDocumentRef);
    }

    private DocumentToCommit getMainDocumentContent(AuthorDocumentModel model) throws IOException {
        byte[] editorContentToCommit;
        IWebappAuthorEditorAccess editorAccess = (IWebappAuthorEditorAccess)model.getAuthorAccess().getEditorAccess();
        URL editorUrl = editorAccess.getEditorLocation();
        RepositoryLocation editorLocation = new RepositoryLocation(editorUrl);
        try (InputStream editorContent = model.getWSEditor().createContentInputStream();){
            editorContentToCommit = IOUtils.toByteArray((InputStream)editorContent);
        }
        String encoding = model.getEncoding();
        return new DocumentToCommit(editorLocation, editorUrl, editorContentToCommit, encoding);
    }

    public String getDescription() {
        return "Commits documents to a Git location.";
    }

    @VisibleForTesting
    WebAuthorGitApi getGitApi(AuthorDocumentModel model, String connector) throws UserActionRequiredException {
        String sessionId = this.getUserInfoFromEditorLocation(model);
        CredentialTypes credentialType = CredentialTypes.getCredentialType(connector);
        return (WebAuthorGitApi)WebAuthorGitApis.create(sessionId, credentialType);
    }

    private String getUserInfoFromEditorLocation(AuthorDocumentModel model) {
        IWebappAuthorEditorAccess editorAccess = (IWebappAuthorEditorAccess)model.getAuthorAccess().getEditorAccess();
        return URLUtil.getUserInfo((String)editorAccess.getEditorLocation().toString());
    }

    private String parsePossibleConflictResolution(ArgumentsMap args) {
        String conflictResolution = null;
        Map conflict = (Map)args.getArgumentValue("conflict");
        if (conflict != null) {
            conflictResolution = (String)conflict.get("resolution");
        }
        return conflictResolution;
    }

    @VisibleForTesting
    List<DocumentToCommit> getDocumentsToCommit(AuthorDocumentModel model) throws IOException {
        ArrayList<DocumentToCommit> documentsToCommit = new ArrayList<DocumentToCommit>();
        String encoding = model.getEncoding();
        IWebappAuthorEditorAccess editorAccess = (IWebappAuthorEditorAccess)model.getAuthorAccess().getEditorAccess();
        UnsavedContentReferenceManager unsavedReferencesManager = editorAccess.getUnsavedContentReferenceManager();
        if (unsavedReferencesManager != null) {
            for (URL editedReferenceUrl : unsavedReferencesManager.getUnsavedReferencesList()) {
                byte[] referenceContentToCommit;
                RepositoryLocation referenceLocation = new RepositoryLocation(editedReferenceUrl);
                try (InputStream referenceContent = unsavedReferencesManager.getUnsavedReferenceInputStream(editedReferenceUrl);){
                    referenceContentToCommit = IOUtils.toByteArray((InputStream)referenceContent);
                }
                documentsToCommit.add(new DocumentToCommit(referenceLocation, editedReferenceUrl, referenceContentToCommit, encoding));
            }
        }
        return documentsToCommit;
    }

    private String handleException(WebAuthorGitApi gitApi, Exception e, String extraErrorDetails) {
        Object message = e.getMessage();
        if (extraErrorDetails != null) {
            message = extraErrorDetails + " " + e.getMessage();
        }
        FailCommitOperationResult failResult = new FailCommitOperationResult(Functions.getExceptionStatus(e), (String)message);
        try {
            if (gitApi != null) {
                return this.obtainOperationResult(gitApi, failResult, null, null);
            }
            throw e;
        }
        catch (Exception e1) {
            try {
                return "{\"type\":\"fail\",\"result\":{\"error\":{\"status\":" + Functions.getExceptionStatus(e) + ",\"message\":" + OBJECT_MAPPER.writeValueAsString((Object)e.getMessage()) + "}}}";
            }
            catch (JsonProcessingException e2) {
                throw new UnexpectedException(e2.getMessage(), e2);
            }
        }
    }

    private MergeResult.ResultType mergeDocuments(WebAuthorGitApi gitApi, List<DocumentToCommit> documents, GitBranchInfo branchInfo, boolean updateDocuments) throws NotAuthorizedException, NotFoundException, UnsupportedEncodingException {
        ThreeWayMerger merger = new ThreeWayMerger();
        MergeResult.ResultType mergeResultType = MergeResult.ResultType.CLEAN;
        log.debug("Starting to merge documents.");
        for (DocumentToCommit document : documents) {
            String right;
            String left;
            String encoding = document.getEncoding();
            String ancestor = gitApi.getContentAtCommitOrContentAtCreation(document.getLocation(), branchInfo.getInitialCommitSha(), encoding);
            MergeResult mergeResult = merger.merge(ancestor, left = new String(document.getContentToCommit(), encoding), right = gitApi.getContentAtCommit(document.getLocation(), branchInfo.getLatestCommitSha(), encoding), MergeConflictResolutionMethods.USE_LEFT);
            mergeResultType = mergeResult.getResultType();
            if (mergeResultType == MergeResult.ResultType.WITH_CONFLICTS || mergeResultType == MergeResult.ResultType.FAILED) {
                log.debug("Merge aborted due to conflicts or a failure.");
                break;
            }
            if (!updateDocuments) continue;
            document.setContentToCommit(mergeResult.getMergedString().getBytes(StandardCharsets.UTF_8));
        }
        if (mergeResultType == MergeResult.ResultType.CLEAN) {
            log.debug("Merged documents.");
        }
        return mergeResultType;
    }

    private boolean shouldCreateBranch(String sourceBranch, String destinationBranch, String conflictResolution, String freshDestinationBranch) {
        boolean shouldCreateBranch = false;
        if (!sourceBranch.equals(destinationBranch) && !freshDestinationBranch.equals(destinationBranch)) {
            shouldCreateBranch = conflictResolution == null || conflictResolution.equals("commit_on_new_branch");
        }
        return shouldCreateBranch;
    }

    private void createBranch(WebAuthorGitApi gitApi, String sourceBranch, String destinationBranch, String repositoryUri, String forkedRepositoryUri) throws NotAuthorizedException {
        log.debug("Creating branch %s.", (Object)destinationBranch);
        if (forkedRepositoryUri != null) {
            gitApi.createBranch(forkedRepositoryUri, destinationBranch, repositoryUri, sourceBranch);
        } else {
            gitApi.createBranch(repositoryUri, destinationBranch, repositoryUri, sourceBranch);
        }
        log.debug("Created branch %s.", (Object)destinationBranch);
    }

    private CommitOperationResult commitDocuments(WebAuthorGitApi gitApi, String repositoryUri, String forkedRepositoryUri, String destinationBranch, String latestCommitSha, List<DocumentToCommit> documentsToCommit, String commitMessage, String conflictResolution) {
        CommitOperationResult commitResult;
        log.debug("Starting to commit documents.");
        if (forkedRepositoryUri != null) {
            commitResult = gitApi.commitDocuments(documentsToCommit, forkedRepositoryUri, destinationBranch, latestCommitSha, commitMessage, false);
        } else if (conflictResolution != null && conflictResolution.equals("keep_only_my_changes")) {
            commitResult = gitApi.commitDocuments(documentsToCommit, repositoryUri, destinationBranch, latestCommitSha, commitMessage, true);
        } else if (conflictResolution != null && (conflictResolution.equals("commit_on_new_branch") || conflictResolution.equals("commit_on_previously_created_new_branch")) && gitApi instanceof BitbucketServerApi) {
            DocumentToCommit firstDocument = documentsToCommit.remove(0);
            ArrayList<DocumentToCommit> auxiliaryList = new ArrayList<DocumentToCommit>();
            auxiliaryList.add(firstDocument);
            commitResult = gitApi.commitDocuments(auxiliaryList, repositoryUri, destinationBranch, latestCommitSha, commitMessage, false);
            if (commitResult.getType() != CommitOperationResultType.OK) {
                return commitResult;
            }
            destinationBranch = firstDocument.getLocation().getBranch();
            if (!documentsToCommit.isEmpty()) {
                commitResult = gitApi.commitDocuments(documentsToCommit, repositoryUri, destinationBranch, latestCommitSha, commitMessage, false);
                commitResult.getCommittedDocuments().add(firstDocument);
            }
        } else {
            commitResult = gitApi.commitDocuments(documentsToCommit, repositoryUri, destinationBranch, latestCommitSha, commitMessage, false);
        }
        return commitResult;
    }

    private String obtainOperationResult(WebAuthorGitApi gitApi, CommitOperationResult commitResult, List<DocumentToCommit> documentsToCommit, GitBranchInfo branchInfo) throws NotAuthorizedException, NotFoundException, IOException {
        CommitDocumentsOperationResult operationResult = this.parseCommitResult(gitApi, commitResult, documentsToCommit, branchInfo);
        String operationResultJson = OBJECT_MAPPER.writeValueAsString((Object)operationResult);
        return operationResultJson;
    }

    private CommitDocumentsOperationResult parseCommitResult(WebAuthorGitApi gitApi, CommitOperationResult commitResult, List<DocumentToCommit> documentsToCommit, GitBranchInfo branchInfo) throws NotAuthorizedException, NotFoundException, UnsupportedEncodingException {
        CommitOperationResultType commitResultType = commitResult.getType();
        if (commitResultType == CommitOperationResultType.OK) {
            log.debug("Documents committed successfully.");
        } else if (commitResultType == CommitOperationResultType.MERGE) {
            MergeCommitOperationResult mergeResult = (MergeCommitOperationResult)commitResult;
            boolean clean = this.mergeDocuments(gitApi, documentsToCommit, branchInfo = new GitBranchInfo(branchInfo.getInitialCommitSha(), mergeResult.getLatestCommitSha()), false) == MergeResult.ResultType.CLEAN;
            commitResult = new MergeCommitOperationResult(clean, mergeResult.getLatestCommitSha(), mergeResult.getDiffUrl());
        } else if (commitResultType == CommitOperationResultType.FAIL) {
            FailCommitOperationResult failResult = (FailCommitOperationResult)commitResult;
            FailCommitOperationResult.HttpError error = failResult.getError();
            log.debug("Error while committing documents: %d %s", (Object)error.getStatus(), (Object)error.getMessage());
        }
        return new CommitDocumentsOperationResult(commitResultType, commitResult);
    }

    private void markReferencesAsSaved(AuthorDocumentModel model, List<DocumentToCommit> documents) {
        IWebappAuthorEditorAccess editorAccess = (IWebappAuthorEditorAccess)model.getAuthorAccess().getEditorAccess();
        UnsavedContentReferenceManager unsavedReferencesManager = editorAccess.getUnsavedContentReferenceManager();
        if (unsavedReferencesManager != null) {
            for (DocumentToCommit document : documents) {
                unsavedReferencesManager.markReferenceAsSaved(document.getDocumentUrl());
            }
        }
    }
}

