/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.oauther;

import com.oxygenxml.examples.oauther.OAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public abstract class OAuthServiceDispatcher<AccessTokenType>
extends ServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(OAuthServiceDispatcher.class);
    private static final long serialVersionUID = 1L;
    private OAuthService<AccessTokenType> oAuthService;
    private Pattern callbackPattern;
    private Pattern authzUrlPattern;
    private Pattern refreshPattern;
    private Pattern syncWithClientPattern;

    public final void init() throws ServletException {
        this.callbackPattern = Pattern.compile("/callback/?$");
        this.authzUrlPattern = Pattern.compile("/authzurl$");
        this.refreshPattern = Pattern.compile("/refresh$");
        this.syncWithClientPattern = Pattern.compile("/sync$");
        this.oAuthService = this.getOAuthService();
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Expires", "0");
            super.service(req, resp);
        }
        catch (Throwable e) {
            log.error("Unexpected error in OAuthServiceDispatcher", e);
            resp.setStatus(500);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestPath = req.getPathInfo();
        if (this.syncWithClientPattern.matcher(requestPath).find()) {
            if (this.oAuthService == null) return;
            try (Scanner s = new Scanner((InputStream)req.getInputStream(), "UTF-8");){
                String accessToken;
                String string = accessToken = s.useDelimiter("\\A").hasNext() ? s.next() : null;
                if (accessToken == null) return;
                AccessTokenType accessTokenObj = this.oAuthService.toAccessTokenType(accessToken);
                String sessionId = req.getSession().getId();
                this.oAuthService.onAccessTokenRefreshed(accessTokenObj, sessionId);
                return;
            }
        } else {
            resp.setStatus(404);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestPath = req.getPathInfo();
        if (this.callbackPattern.matcher(requestPath).find()) {
            if (this.oAuthService != null) {
                OAuthState savedState = this.getStoredState(req.getSession().getId());
                boolean validState = this.validateState(savedState, this.oAuthService.getStateFromAuthorizationCallback(req));
                String code = this.oAuthService.getAuthorizedCode(req, savedState);
                boolean validCode = this.validateCode(code);
                if (!validState || !validCode) {
                    resp.setStatus(400);
                    return;
                }
                String sessionId = req.getSession().getId();
                this.oAuthService.onAccessTokenReceived(this.oAuthService.extractAccessToken(code), sessionId, savedState);
                if (savedState.isForAuthentication()) {
                    resp.sendRedirect("../../app/authenticate.html");
                } else {
                    resp.setHeader("Content-Type", "text/html");
                    resp.setHeader("Content-Security-Policy", "default-src 'none'; script-src 'unsafe-inline';");
                    resp.getWriter().write("<!DOCTYPE html>\n<html lang=\"en\"><head><meta charset=\"UTF-8\"><title>t</title><script>window.open('', '_self').close();</script></head></html>");
                }
                return;
            }
        } else if (this.authzUrlPattern.matcher(requestPath).find()) {
            if (this.oAuthService != null) {
                OAuthState state = this.oAuthService.createStateForAuthorizationUrl(req.getSession().getId());
                resp.sendRedirect(this.oAuthService.getAuthorizationUrl(state));
                return;
            }
        } else if (this.refreshPattern.matcher(requestPath).find() && this.oAuthService != null) {
            AccessTokenType refreshedAccessToken = this.refreshAccessToken(req, this.oAuthService);
            String sessionId = req.getSession().getId();
            this.oAuthService.onAccessTokenRefreshed(refreshedAccessToken, sessionId);
            return;
        }
        resp.setStatus(404);
    }

    public boolean validateState(OAuthState savedState, OAuthState receivedState) {
        boolean ok = true;
        if (savedState == null) {
            log.error("Saved state is null during oauth callback");
            ok = false;
        } else if (!savedState.equals(receivedState)) {
            log.error("Saved state differs from request state during oauth callback");
            ok = false;
        }
        return ok;
    }

    private OAuthState getStoredState(String sessionId) {
        WebappPluginWorkspace pluginWorkspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        SessionStore sessionStore = pluginWorkspace.getSessionStore();
        OAuthState savedState = (OAuthState)sessionStore.get(sessionId, "oauth::sess::key");
        sessionStore.remove(sessionId, "oauth::sess::key");
        return savedState;
    }

    private boolean validateCode(String code) {
        boolean ok = true;
        if (code == null || code.isEmpty()) {
            log.error("Code is null or empty during oauth callback");
            ok = false;
        }
        return ok;
    }

    protected abstract AccessTokenType refreshAccessToken(HttpServletRequest var1, OAuthService<AccessTokenType> var2);

    protected abstract OAuthService<AccessTokenType> getOAuthService();

    public String getPath() {
        throw new UnsupportedOperationException();
    }
}

