/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.oauther;

import com.oxygenxml.examples.oauther.OAuthState;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public interface OAuthService<AccessTokenType> {
    public AccessTokenType toAccessTokenType(String var1);

    default public String getAuthorizedCode(HttpServletRequest req, OAuthState savedState) {
        return req.getParameter("code");
    }

    default public OAuthState createStateForAuthorizationUrl(String sessionId) {
        OAuthState state = new OAuthState();
        WebappPluginWorkspace pluginWorkspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        SessionStore sessionStore = pluginWorkspace.getSessionStore();
        sessionStore.putWithoutSessionCookieRefresh(sessionId, "oauth::sess::key", (Object)state);
        return state;
    }

    default public OAuthState createStateForAuthenticationUrl(String sessionId) {
        OAuthState state = new OAuthState(true);
        WebappPluginWorkspace pluginWorkspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        SessionStore sessionStore = pluginWorkspace.getSessionStore();
        sessionStore.putWithoutSessionCookieRefresh(sessionId, "oauth::sess::key", (Object)state);
        return state;
    }

    default public OAuthState getStateFromAuthorizationCallback(HttpServletRequest req) {
        return new OAuthState(req.getParameter("state"));
    }

    public String getAuthorizationUrl(OAuthState var1);

    public AccessTokenType extractAccessToken(String var1);

    public AccessTokenType refreshAccessToken(AccessTokenType var1);

    public void onAccessTokenReceived(AccessTokenType var1, String var2, OAuthState var3);

    public void onAccessTokenRefreshed(AccessTokenType var1, String var2);
}

