/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.gitlab;

import com.oxygenxml.examples.common.BaseUrlConnection;
import com.oxygenxml.examples.git.RESTGitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.gitlab.GitlabApi;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.List;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class GitlabUrlConnection
extends BaseUrlConnection {
    private GitlabApi gitlabApi;
    private RepositoryLocation location;

    public GitlabUrlConnection(RepositoryLocation location, URLConnection delegateConnection, GitlabApi gitlabApi) {
        super(delegateConnection);
        this.location = location;
        this.gitlabApi = gitlabApi;
    }

    public InputStream getInputStream() throws IOException {
        try {
            RepositoryLocation repoLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(this.location, this.gitlabApi);
            return this.gitlabApi.read(repoLocation);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
        catch (NotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    RepositoryLocation repoLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(GitlabUrlConnection.this.location, GitlabUrlConnection.this.gitlabApi);
                    GitlabUrlConnection.this.gitlabApi.writeFile(repoLocation, this.toByteArray());
                }
                catch (NotAuthorizedException e) {
                    throw GitUtil.getNotAuthorizedAndNoLoginEx();
                }
            }
        };
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        try {
            RepositoryLocation repoLocation = RESTGitAccess.submodulesResolver.resolveSubmodule(this.location, this.gitlabApi);
            return this.gitlabApi.listFiles(repoLocation);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
    }
}

