/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.gitlab;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.common.Cipher;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.gitlab.GitlabAccessToken;
import com.oxygenxml.examples.gitlab.GitlabApi;
import com.oxygenxml.examples.oauther.OAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApis;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.QuietClosable;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.InternalWebappPluginWorkspace;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationManager;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationProvider;
import ro.sync.ecss.webapp.auth.ApplicationUser;
import ro.sync.ecss.webapp.auth.ApplicationUserStore;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public abstract class GitlabOAuthService
implements OAuthService<GitlabAccessToken> {
    private static final Logger log = LoggerFactory.getLogger(GitlabOAuthService.class);
    public static final String GITLAB_API_URL = "https://gitlab.com";
    private static final Cipher CIPHER = new Cipher();
    private boolean useApiPrefix;
    private ApplicationAuthenticationProvider gitLabAuthenticationProvider = this.buildAuthProvider();

    public GitlabOAuthService(boolean useApiPrefix) {
        this.useApiPrefix = useApiPrefix;
    }

    public void tryAccess(String sessionId, GitlabAccessToken accessToken, CheckedFunction method) throws IOException, NotAuthorizedException {
        try {
            try {
                method.call(accessToken);
            }
            catch (HttpExceptionWithDetails e) {
                if (e.getReasonCode() == 401) {
                    GitlabAccessToken refreshedAccessToken = this.refreshAccessToken(accessToken);
                    GitCredentialsProvider.setCredentials(sessionId, this.getCredentialsType(), refreshedAccessToken);
                    method.call(refreshedAccessToken);
                    return;
                }
                throw e;
            }
        }
        catch (HttpExceptionWithDetails e) {
            int statusCode = e.getReasonCode();
            if (statusCode == 401) {
                throw new NotAuthorizedException(e);
            }
            throw e;
        }
    }

    @Override
    public String getAuthorizationUrl(OAuthState state) {
        String apiPrefix = GITLAB_API_URL;
        String clientId = GitCredentialsProvider.getGitlabClientId();
        String redirectUri = GitCredentialsProvider.getGitlabRedirectUri();
        if (this.useApiPrefix) {
            apiPrefix = GitCredentialsProvider.getGitlabEnterpriseApiUrl();
            clientId = GitCredentialsProvider.getGitlabEnterpriseClientId();
            redirectUri = GitCredentialsProvider.getGitlabEnterpriseRedirectUri();
        }
        return apiPrefix + "/oauth/authorize?client_id=" + clientId + "&redirect_uri=" + URLUtil.encodeURIComponent((String)redirectUri) + "&response_type=code&state=" + state.getCode();
    }

    @Override
    public GitlabAccessToken extractAccessToken(String code) {
        try {
            String githubResponseBody;
            String clientId = GitCredentialsProvider.getGitlabClientId();
            String clientSecret = GitCredentialsProvider.getGitlabClientSecret();
            String redirectUri = GitCredentialsProvider.getGitlabRedirectUri();
            String apiPrefix = GITLAB_API_URL;
            if (this.useApiPrefix) {
                clientId = GitCredentialsProvider.getGitlabEnterpriseClientId();
                clientSecret = GitCredentialsProvider.getGitlabEnterpriseClientSecret();
                redirectUri = GitCredentialsProvider.getGitlabEnterpriseRedirectUri();
                apiPrefix = GitCredentialsProvider.getGitlabEnterpriseApiUrl();
            }
            URL url = new URL(apiPrefix + "/oauth/token");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            String requestBody = "client_id=" + clientId + "&client_secret=" + clientSecret + "&grant_type=authorization_code&code=" + code + "&redirect_uri=" + URLUtil.encodeURIComponent((String)redirectUri);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", "" + requestBody.length());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(requestBody);
            }
            try (InputStream responseInputStream = QuietClosable.from((InputStream)conn.getInputStream());){
                githubResponseBody = GitUtil.utf8InputStreamToString(responseInputStream);
            }
            Map<String, Object> tokenInfo = GitUtil.parseJSON(githubResponseBody);
            return new GitlabAccessToken((String)tokenInfo.get("access_token"), (String)tokenInfo.get("refresh_token"), CIPHER);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public GitlabAccessToken refreshAccessToken(GitlabAccessToken accessToken) {
        GitlabAccessToken gitlabAccessToken;
        block17: {
            String apiPrefix = GITLAB_API_URL;
            String clientId = GitCredentialsProvider.getGitlabClientId();
            String clientSecret = GitCredentialsProvider.getGitlabClientSecret();
            String redirectUri = GitCredentialsProvider.getGitlabRedirectUri();
            if (this.useApiPrefix) {
                apiPrefix = GitCredentialsProvider.getGitlabEnterpriseApiUrl();
                clientId = GitCredentialsProvider.getGitlabEnterpriseClientId();
                clientSecret = GitCredentialsProvider.getGitlabEnterpriseClientSecret();
                redirectUri = GitCredentialsProvider.getGitlabEnterpriseRedirectUri();
            }
            URL url = new URL(apiPrefix + "/oauth/token");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            String requestBody = "client_id=" + clientId + "&client_secret=" + clientSecret + "&grant_type=refresh_token&refresh_token=" + accessToken.getRefreshToken() + "&scope=api&redirect_uri=" + redirectUri;
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", String.valueOf(requestBody.length()));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(requestBody);
            }
            catch (IOException e) {
                log.error("Error refreshing token {}", (Object)this.getErrorMessage(conn), (Object)e);
                throw e;
            }
            InputStream responseInputStream = QuietClosable.from((InputStream)conn.getInputStream());
            try {
                String githubResponseBody = GitUtil.utf8InputStreamToString(responseInputStream);
                Map<String, Object> tokenInfo = GitUtil.parseJSON(githubResponseBody);
                gitlabAccessToken = new GitlabAccessToken((String)tokenInfo.get("access_token"), (String)tokenInfo.get("refresh_token"), CIPHER);
                if (responseInputStream == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (responseInputStream != null) {
                        try {
                            responseInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            responseInputStream.close();
        }
        return gitlabAccessToken;
    }

    private String getErrorMessage(HttpURLConnection conn) {
        InputStream errorStream = conn.getErrorStream();
        try {
            return IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "<error reading server response>" + e.getMessage();
        }
    }

    @Override
    public GitlabAccessToken toAccessTokenType(String accessToken) {
        return new GitlabAccessToken(accessToken, null, CIPHER);
    }

    @Override
    public void onAccessTokenReceived(GitlabAccessToken accessToken, String sessionId, OAuthState state) {
        GitCredentialsProvider.setCredentials(sessionId, this.getCredentialsType(), accessToken);
        if (state.isForAuthentication()) {
            try {
                GitlabApi gitlabApi = WebAuthorGitApis.createGitlabApi(sessionId, this.useApiPrefix);
                UserInformation userInformation = gitlabApi.getUserInformation();
                InternalWebappPluginWorkspace pluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
                ApplicationAuthenticationManager applicationAuthenticationManager = pluginWorkspace.getApplicationAuthenticationManager();
                ApplicationUser applicationUser = new ApplicationUser(userInformation.getId(), userInformation.getDisplayName(), userInformation.getEmail());
                ApplicationUserStore applicationUserStore = applicationAuthenticationManager.getApplicationUserStore();
                applicationUserStore.authenticateApplicationUser(sessionId, applicationUser);
            }
            catch (NotAuthorizedException e) {
                throw new IllegalStateException();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void onAccessTokenRefreshed(GitlabAccessToken accessToken, String sessionId) {
        GitCredentialsProvider.setCredentials(sessionId, this.getCredentialsType(), accessToken);
    }

    public CredentialTypes getCredentialsType() {
        return this.useApiPrefix ? CredentialTypes.GITLAB_E : CredentialTypes.GITLAB;
    }

    public abstract ApplicationAuthenticationProvider buildAuthProvider();

    public ApplicationAuthenticationProvider getAuthenticationProvider() {
        return this.gitLabAuthenticationProvider;
    }

    @FunctionalInterface
    public static interface CheckedFunction {
        public void call(GitlabAccessToken var1) throws IOException, NotAuthorizedException;
    }
}

