/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.gitlab;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Ints;
import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.git.GitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.gitlab.GitLabApiVersion;
import com.oxygenxml.examples.gitlab.GitLabFile;
import com.oxygenxml.examples.gitlab.GitlabAccessToken;
import com.oxygenxml.examples.gitlab.GitlabOAuthService;
import com.oxygenxml.examples.webauthorgitapi.DocumentToCommit;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.FailCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.MergeCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.OkCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.net.http.HttpException;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationProvider;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.FolderEntryDescriptor;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class GitlabApi
implements WebAuthorGitApi {
    private static final Logger log = LoggerFactory.getLogger(GitlabApi.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String API_V3_PROJECTS = "/api/v3/projects/";
    private static final String API_V4_PROJECTS = "/api/v4/projects/";
    private static final Cache<String, String> REPOSITORY_IDS = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final Pattern NEXT_PAGE_PATTERN = Pattern.compile("<([^>]+)>;\\srel=\"next\"");
    private static final String UNEXPECTED_API_VERSION_MESSAGE = "Unexpected Gitlab API version: ";
    private final boolean onPremise;
    private final String apiPrefix;
    private final GitAccess jGitAccess;
    private String contextId;

    public GitlabApi(boolean onPremise, String apiPrefix, GitAccess jGitAccess, String contextId) {
        this.onPremise = onPremise;
        this.apiPrefix = apiPrefix;
        this.jGitAccess = jGitAccess;
        this.contextId = contextId;
    }

    @Override
    public InputStream read(RepositoryLocation fileLocation) throws NotAuthorizedException, NotFoundException {
        String repositoryUri = fileLocation.getRepositoryUri();
        String branch = fileLocation.getBranch();
        String path = fileLocation.getPath();
        try {
            URL getDocumentUrl;
            GitLabApiVersion apiVersion = this.getApiVersion();
            String id = this.getRepoId(repositoryUri, apiVersion);
            if (apiVersion == GitLabApiVersion.V3) {
                getDocumentUrl = new URL(this.apiPrefix + API_V3_PROJECTS + id + "/repository/files?file_path=" + URLUtil.encodeURIComponent((String)path) + "&" + this.getBranchRefUrlParam(branch));
            } else if (apiVersion == GitLabApiVersion.V4) {
                getDocumentUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/files/" + URLUtil.encodeURIComponent((String)path) + "?" + this.getBranchRefUrlParam(branch));
            } else {
                throw new UnexpectedException(UNEXPECTED_API_VERSION_MESSAGE + apiVersion);
            }
            AtomicReference<Object> ret = new AtomicReference<Object>(null);
            try {
                this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> ret.set(this.readInternal(fileLocation, getDocumentUrl, refreshedAccessToken)));
            }
            catch (HttpException e) {
                if (e.getReasonCode() == 404) {
                    throw new NotFoundException(fileLocation);
                }
                throw e;
            }
            return ret.get();
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private GitlabOAuthService getAuthService() {
        return new GitlabOAuthService(this.onPremise){

            @Override
            public ApplicationAuthenticationProvider buildAuthProvider() {
                return null;
            }
        };
    }

    private InputStream readInternal(RepositoryLocation fileLocation, URL getDocumentUrl, GitlabAccessToken accessToken) throws IOException, NotAuthorizedException {
        ByteArrayInputStream byteArrayInputStream;
        block9: {
            HttpURLConnection conn = (HttpURLConnection)getDocumentUrl.openConnection();
            this.setConnAuthorization(conn, accessToken);
            InputStream inputStream = conn.getInputStream();
            try {
                String json = GitUtil.utf8InputStreamToString(inputStream);
                Map<String, Object> body = GitUtil.parseJSON(json);
                String base64Content = (String)body.get("content");
                byte[] decodedContent = Base64.decodeBase64((String)base64Content);
                byteArrayInputStream = new ByteArrayInputStream(decodedContent);
                if (inputStream == null) break block9;
            }
            catch (Throwable json) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            json.addSuppressed(throwable);
                        }
                    }
                    throw json;
                }
                catch (HttpException e) {
                    int reasonCode = e.getReasonCode();
                    if (reasonCode == 401 || reasonCode == 403) {
                        throw new NotAuthorizedException(e);
                    }
                    throw e;
                }
            }
            inputStream.close();
        }
        return byteArrayInputStream;
    }

    public void writeFile(RepositoryLocation fileLocation, byte[] content) throws IOException, NotAuthorizedException {
        URL commitUrl;
        String repositoryUri = fileLocation.getRepositoryUri();
        String branch = fileLocation.getBranch();
        String path = fileLocation.getPath();
        GitLabApiVersion apiVersion = this.getApiVersion();
        String id = this.getRepoId(repositoryUri, apiVersion);
        if (apiVersion == GitLabApiVersion.V3) {
            commitUrl = new URL(this.apiPrefix + API_V3_PROJECTS + id + "/repository/files");
        } else if (apiVersion == GitLabApiVersion.V4) {
            commitUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/files/" + URLUtil.encodeURIComponent((String)path));
        } else {
            throw new IOException("");
        }
        String encodedContent = Base64.encodeBase64String((byte[])content);
        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
        String createdWithWAMsg = rb.getMessage("Created_with_oxygen_web_author");
        String data = "file_path=" + URLUtil.encodeURIComponent((String)path) + "&branch_name=" + branch + "&encoding=base64&commit_message=" + URLUtil.encodeURIComponent((String)createdWithWAMsg) + "&content=" + URLUtil.encodeURIComponent((String)encodedContent) + "&branch=" + branch;
        this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> {
            try {
                this.writeFileInternal(commitUrl, "POST", data);
            }
            catch (HttpException e1) {
                if (this.shouldIgnoreAndRetry(e1)) {
                    try {
                        this.writeFileInternal(commitUrl, "PUT", data);
                    }
                    catch (HttpException e2) {
                        throw this.getMeaningfulException(e2);
                    }
                }
                throw this.getMeaningfulException(e1);
            }
        });
    }

    private void writeFileInternal(URL commitUrl, String requestMethod, String data) throws IOException, NotAuthorizedException {
        HttpURLConnection conn = (HttpURLConnection)commitUrl.openConnection();
        try {
            conn.setDoOutput(true);
            conn.setRequestMethod(requestMethod);
            this.setConnAuthorization(conn, this.getKnownAccessToken());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            try (OutputStream outputStream = conn.getOutputStream();){
                outputStream.write(data.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (HttpException e) {
            if (e.getReasonCode() != 404) {
                log.error(e.getMessage() + ": " + e.getReason());
            }
            if (e.getReasonCode() == 403) {
                throw new NotAuthorizedException(e);
            }
            throw e;
        }
        finally {
            conn.disconnect();
        }
    }

    private IOException getMeaningfulException(HttpException e) {
        Map<String, Object> reasonMap = GitUtil.parseJSON(e.getReason());
        Object message = reasonMap != null ? reasonMap.get("message") : null;
        Throwable processsed = message instanceof String ? new IOException((String)message, e) : e;
        return processsed;
    }

    private boolean shouldIgnoreAndRetry(HttpException e) {
        return e.getReason() != null && e.getReason().contains("A file with this name already exists");
    }

    @Override
    public CommitOperationResult commitDocuments(List<DocumentToCommit> documents, String repositoryUri, String branch, String latestCommitSha, String commitMessage, boolean forcePush) {
        return this.commitDocumentsHelper(documents, repositoryUri, branch, latestCommitSha, commitMessage, forcePush, 15);
    }

    private CommitOperationResult commitDocumentsHelper(List<DocumentToCommit> documents, String repositoryUri, String branch, String latestCommitSha, String commitMessage, boolean forcePush, int times) {
        try {
            List<GitLabFile> latestGitLabFiles;
            GitLabApiVersion apiVersion = this.getApiVersion();
            if (apiVersion != GitLabApiVersion.V4) {
                throw new UnexpectedException(UNEXPECTED_API_VERSION_MESSAGE + apiVersion);
            }
            if (!documents.isEmpty() && !forcePush) {
                latestGitLabFiles = this.getLatestGitLabFiles(documents);
                if (branch.equals(documents.get(0).getLocation().getBranch()) && this.isPossibleConflict(documents, latestGitLabFiles, latestCommitSha)) {
                    String headSha = this.getBranchHash(repositoryUri, branch);
                    return new MergeCommitOperationResult(false, headSha, null);
                }
            } else {
                latestGitLabFiles = null;
            }
            String id = this.getRepoId(repositoryUri, apiVersion);
            AtomicReference<Object> ret = new AtomicReference<Object>(null);
            this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> ret.set(this.commitInternal(documents, branch, commitMessage, forcePush, latestGitLabFiles, id)));
            return ret.get();
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReason().contains("The file has changed since you started editing it")) {
                try {
                    String headSha = this.getBranchHash(repositoryUri, branch);
                    return new MergeCommitOperationResult(false, headSha, null);
                }
                catch (NotAuthorizedException | NotFoundException e1) {
                    return new FailCommitOperationResult(Functions.getExceptionStatus(e1), e1.getMessage());
                }
            }
            if (e.getReasonCode() == 400 && e.getReason().contains("Could not update") && times > 0) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    return new FailCommitOperationResult(e.getReasonCode(), e.getReason());
                }
                return this.commitDocumentsHelper(documents, repositoryUri, branch, latestCommitSha, commitMessage, forcePush, --times);
            }
            return new FailCommitOperationResult(e.getReasonCode(), this.parseErrorMessage(e));
        }
        catch (NotAuthorizedException | NotFoundException | IOException e) {
            return new FailCommitOperationResult(Functions.getExceptionStatus(e), e.getMessage());
        }
    }

    private CommitOperationResult commitInternal(List<DocumentToCommit> documents, String branch, String commitMessage, boolean forcePush, List<GitLabFile> latestGitLabFiles, String id) throws MalformedURLException, IOException, ProtocolException {
        URL commitUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/commits");
        String data = this.buildCommitData(documents, latestGitLabFiles, branch, commitMessage, forcePush);
        HttpURLConnection conn = (HttpURLConnection)commitUrl.openConnection();
        this.setConnAuthorization(conn, this.getKnownAccessToken());
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        try (OutputStream out = conn.getOutputStream();){
            out.write(data.getBytes(StandardCharsets.UTF_8));
        }
        try (InputStream inputStream = conn.getInputStream();){
            String response = GitUtil.utf8InputStreamToString(inputStream);
            Map<String, Object> jsonResponse = GitUtil.parseJSON(response);
            OkCommitOperationResult okCommitOperationResult = new OkCommitOperationResult((String)jsonResponse.get("id"), documents);
            return okCommitOperationResult;
        }
    }

    private List<GitLabFile> getLatestGitLabFiles(List<DocumentToCommit> documents) throws NotAuthorizedException, NotFoundException {
        ArrayList<GitLabFile> latestFiles = new ArrayList<GitLabFile>();
        try {
            GitLabApiVersion apiVersion = this.getApiVersion();
            if (apiVersion != GitLabApiVersion.V4) {
                throw new UnexpectedException(UNEXPECTED_API_VERSION_MESSAGE + apiVersion);
            }
            String id = this.getRepoId(documents.get(0).getLocation().getRepositoryUri(), apiVersion);
            for (DocumentToCommit document : documents) {
                RepositoryLocation location = document.getLocation();
                String branch = location.getBranch();
                String path = location.getPath();
                URL getFileUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/files/" + URLUtil.encodeURIComponent((String)path) + "?ref=" + URLUtil.encodeURIComponent((String)branch));
                try {
                    this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> {
                        HttpURLConnection conn = (HttpURLConnection)getFileUrl.openConnection();
                        this.setConnAuthorization(conn, this.getKnownAccessToken());
                        try (InputStream inputStream = conn.getInputStream();){
                            String jsonResponse = GitUtil.utf8InputStreamToString(inputStream);
                            Map<String, Object> response = GitUtil.parseJSON(jsonResponse);
                            String base64Content = (String)response.get("content");
                            byte[] decodedContent = Base64.decodeBase64((String)base64Content);
                            String lastCommitId = (String)response.get("last_commit_id");
                            latestFiles.add(new GitLabFile(location, decodedContent, lastCommitId));
                        }
                    });
                }
                catch (HttpExceptionWithDetails e) {
                    int reasonCode = e.getReasonCode();
                    if (reasonCode == 401 || reasonCode == 403) {
                        throw new NotAuthorizedException(e);
                    }
                    if (reasonCode == 404) {
                        throw new NotFoundException(document.getLocation());
                    }
                    throw new UnexpectedException(this.parseErrorMessage(e), e);
                }
            }
            return latestFiles;
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private boolean isPossibleConflict(List<DocumentToCommit> documents, List<GitLabFile> latestGitLabFiles, String latestCommitSha) throws NotAuthorizedException, NotFoundException, UnsupportedEncodingException {
        for (int i = 0; i < documents.size(); ++i) {
            String latestContent;
            String encoding;
            RepositoryLocation documentLocation = documents.get(i).getLocation();
            String initialContent = this.getContentAtCommitOrContentAtCreation(documentLocation, latestCommitSha, encoding = documents.get(i).getEncoding());
            if (initialContent.equals(latestContent = new String(latestGitLabFiles.get(i).getContent(), encoding))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getShaOfCommitThatCreatedDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        List<String> commits = this.getCommitsOfDocument(location);
        return commits.get(commits.size() - 1);
    }

    List<String> getCommitsOfDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        try {
            GitLabApiVersion apiVersion = this.getApiVersion();
            if (apiVersion != GitLabApiVersion.V4) {
                throw new UnexpectedException(UNEXPECTED_API_VERSION_MESSAGE + apiVersion);
            }
            String id = this.getRepoId(location.getRepositoryUri(), apiVersion);
            String commitsUrl = this.apiPrefix + API_V4_PROJECTS + id + "/repository/commits?ref_name=" + URLUtil.encodeURIComponent((String)location.getBranch()) + "&path=" + URLUtil.encodeURIComponent((String)location.getPath());
            URL commitsOfFileUrl = new URL(commitsUrl);
            AtomicReference<Object> ret = new AtomicReference<Object>(null);
            this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> {
                List<String> commits = this.getCommitsOfDocument(commitsOfFileUrl);
                ret.set(commits);
            });
            return ret.get();
        }
        catch (HttpExceptionWithDetails e) {
            int reasonCode = e.getReasonCode();
            if (reasonCode == 401 || reasonCode == 403) {
                throw new NotAuthorizedException(e);
            }
            if (reasonCode == 404) {
                throw new NotFoundException(location);
            }
            throw new UnexpectedException(e.getReason(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private List<String> getCommitsOfDocument(URL commitsOfFileUrl) throws IOException {
        String responseString;
        HttpURLConnection conn = (HttpURLConnection)commitsOfFileUrl.openConnection();
        this.setConnAuthorization(conn, this.getKnownAccessToken());
        try (InputStream response = conn.getInputStream();){
            responseString = GitUtil.utf8InputStreamToString(response);
        }
        List commits = (List)OBJECT_MAPPER.readValue(responseString, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        return commits.stream().map(commit -> commit.get("id").toString()).collect(Collectors.toList());
    }

    private String buildCommitData(List<DocumentToCommit> documents, List<GitLabFile> latestGitLabFiles, String branch, String commitMessage, boolean forcePush) throws IOException {
        StringBuilder actions = new StringBuilder();
        actions.append("[");
        for (int i = 0; i < documents.size(); ++i) {
            String path = documents.get(i).getLocation().getPath();
            String encodedContent = Base64.encodeBase64String((byte[])documents.get(i).getContentToCommit());
            actions.append("{");
            actions.append("\"action\":\"update\",");
            actions.append("\"file_path\":").append(OBJECT_MAPPER.writeValueAsString((Object)path)).append(",");
            actions.append("\"content\":").append(OBJECT_MAPPER.writeValueAsString((Object)encodedContent)).append(",");
            actions.append("\"encoding\":\"base64\"");
            if (!forcePush) {
                actions.append(",\"last_commit_id\":\"").append(latestGitLabFiles.get(i).getLastCommitId()).append("\"");
            }
            actions.append("},");
        }
        if (!documents.isEmpty()) {
            actions.deleteCharAt(actions.length() - 1);
        }
        actions.append("]");
        StringBuilder data = new StringBuilder();
        data.append("{");
        data.append("\"branch\":").append(OBJECT_MAPPER.writeValueAsString((Object)branch)).append(",");
        data.append("\"commit_message\":").append(OBJECT_MAPPER.writeValueAsString((Object)commitMessage)).append(",");
        data.append("\"actions\":").append(actions.toString());
        data.append("}");
        return data.toString();
    }

    public List<FolderEntryDescriptor> listFiles(RepositoryLocation fileLocation) throws IOException, NotAuthorizedException {
        String repositoryUri = fileLocation.getRepositoryUri();
        String branch = fileLocation.getBranch();
        String path = fileLocation.getPath();
        Stream soFar = Stream.empty();
        URL filesUrl = null;
        GitLabApiVersion apiVersion = this.getApiVersion();
        String id = this.getRepoId(repositoryUri, apiVersion);
        if (apiVersion == GitLabApiVersion.V3) {
            filesUrl = new URL(this.apiPrefix + API_V3_PROJECTS + id + "/repository/tree?path=" + URLUtil.encodeURIComponent((String)path) + "&ref_name=" + URLUtil.encodeURIComponent((String)branch) + "&" + this.getBranchRefUrlParam(branch));
        } else if (apiVersion == GitLabApiVersion.V4) {
            filesUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/tree?path=" + URLUtil.encodeURIComponent((String)path) + "&" + this.getBranchRefUrlParam(branch));
        } else {
            throw new IOException("");
        }
        boolean done = false;
        int currentPage = 1;
        while (!done) {
            try {
                AtomicReference<Object> ret = new AtomicReference<Object>(null);
                URL filesUrlFinal = filesUrl;
                this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> ret.set(this.listFilesInternal(filesUrlFinal)));
                ListFilesResult result = ret.get();
                soFar = Stream.of(soFar, result.flies.stream()).flatMap(s -> s);
                if (result.nextPage.isPresent()) {
                    ++currentPage;
                    filesUrl = new URL(result.nextPage.get());
                    continue;
                }
                done = true;
            }
            catch (IOException e) {
                if (currentPage != 1) {
                    log.warn((Object)e, (Throwable)e);
                    done = true;
                    continue;
                }
                throw e;
            }
            catch (NotAuthorizedException e) {
                throw e;
            }
        }
        return soFar.map(entry -> {
            String type = (String)entry.get("type");
            Object absolutePath = (String)entry.get("path");
            String mode = (String)entry.get("mode");
            if (absolutePath == null) {
                String name = (String)entry.get("name");
                absolutePath = path + "/" + name;
            }
            if ("tree".equals(type) || "on".equals(GitCredentialsProvider.isGitResolveSubmodules()) && "160000".equals(mode)) {
                absolutePath = (String)absolutePath + "/";
            }
            return new FolderEntryDescriptor(GitUtil.encodePath((String)absolutePath));
        }).collect(Collectors.toList());
    }

    private ListFilesResult listFilesInternal(URL filesUrl) throws IOException, NotAuthorizedException, HttpException {
        ListFilesResult listFilesResult;
        block11: {
            URLConnection conn = filesUrl.openConnection();
            this.setConnAuthorization(conn, this.getKnownAccessToken());
            InputStream inputStream = conn.getInputStream();
            try {
                Matcher matcher;
                String linkHeader = conn.getHeaderField("Link");
                String next = null;
                if (linkHeader != null && !linkHeader.isEmpty() && (matcher = NEXT_PAGE_PATTERN.matcher(linkHeader)).find()) {
                    next = matcher.group(1);
                }
                String responseText = GitUtil.utf8InputStreamToString(inputStream);
                List<HashMap<String, Object>> files = GitUtil.parseListJson(responseText);
                listFilesResult = new ListFilesResult(files, Optional.ofNullable(next));
                if (inputStream == null) break block11;
            }
            catch (Throwable linkHeader) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            linkHeader.addSuppressed(throwable);
                        }
                    }
                    throw linkHeader;
                }
                catch (HttpException e) {
                    int reasonCode = e.getReasonCode();
                    if (reasonCode == 401 || reasonCode == 403) {
                        throw new NotAuthorizedException(e);
                    }
                    if (reasonCode != 404) {
                        log.error(e.getMessage() + ": " + e.getReason());
                    }
                    throw e;
                }
            }
            inputStream.close();
        }
        return listFilesResult;
    }

    @Override
    public String getContentAtCommit(RepositoryLocation location, String commitSha, String encoding) throws NotAuthorizedException, NotFoundException {
        RepositoryLocation updatedLocation = new RepositoryLocation(location.getRepositoryUri(), commitSha, location.getPath());
        InputStream content = this.read(updatedLocation);
        return GitUtil.inputStreamToString(content, encoding);
    }

    @Override
    public void createBranch(String repositoryUri, String newBranch, String sourceRepositoryUri, String sourceBranch) throws NotAuthorizedException {
        if (!repositoryUri.equals(sourceRepositoryUri)) {
            this.jGitAccess.createBranch(repositoryUri, newBranch, sourceRepositoryUri, sourceBranch);
            return;
        }
        try {
            URL createBranchUrl;
            GitLabApiVersion apiVersion = this.getApiVersion();
            String id = this.getRepoId(repositoryUri, apiVersion);
            String sourceBranchHash = this.getBranchHash(sourceRepositoryUri, sourceBranch);
            if (apiVersion == GitLabApiVersion.V3) {
                createBranchUrl = new URL(this.apiPrefix + API_V3_PROJECTS + id + "/repository/branches?branch_name=" + URLUtil.encodeURIComponent((String)newBranch) + "&ref=" + sourceBranchHash);
            } else if (apiVersion == GitLabApiVersion.V4) {
                createBranchUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/branches?branch=" + URLUtil.encodeURIComponent((String)newBranch) + "&ref=" + sourceBranchHash);
            } else {
                throw new UnexpectedException(UNEXPECTED_API_VERSION_MESSAGE + apiVersion);
            }
            this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> this.createBranchInternal(createBranchUrl));
        }
        catch (HttpExceptionWithDetails e) {
            int reasonCode = e.getReasonCode();
            if (reasonCode == 401 || reasonCode == 403) {
                throw new NotAuthorizedException(e);
            }
            throw new UnexpectedException(this.parseErrorMessage(e), e);
        }
        catch (NotFoundException | IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private void createBranchInternal(URL createBranchUrl) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)createBranchUrl.openConnection();
        this.setConnAuthorization(conn, this.getKnownAccessToken());
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (OutputStream writer = conn.getOutputStream();){
            writer.write("".getBytes(StandardCharsets.UTF_8));
        }
        InputStream inputStream = conn.getInputStream();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    @VisibleForTesting
    String getBranchHash(String repositoryUri, String branch) throws NotAuthorizedException, NotFoundException {
        try {
            URL getBranchUrl;
            GitLabApiVersion apiVersion = this.getApiVersion();
            String id = this.getRepoId(repositoryUri, apiVersion);
            if (apiVersion == GitLabApiVersion.V3) {
                getBranchUrl = new URL(this.apiPrefix + API_V3_PROJECTS + id + "/repository/branches/" + URLUtil.encodeURIComponent((String)branch));
            } else if (apiVersion == GitLabApiVersion.V4) {
                getBranchUrl = new URL(this.apiPrefix + API_V4_PROJECTS + id + "/repository/branches/" + URLUtil.encodeURIComponent((String)branch));
            } else {
                throw new UnexpectedException(UNEXPECTED_API_VERSION_MESSAGE + apiVersion);
            }
            AtomicReference toReturn = new AtomicReference();
            this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> {
                HttpURLConnection conn = (HttpURLConnection)getBranchUrl.openConnection();
                this.setConnAuthorization(conn, this.getKnownAccessToken());
                try (InputStream inputStream = conn.getInputStream();){
                    String jsonResponse = GitUtil.utf8InputStreamToString(inputStream);
                    Map<String, Object> response = GitUtil.parseJSON(jsonResponse);
                    Map commit = (Map)response.get("commit");
                    toReturn.set((String)commit.get("id"));
                }
            });
            return (String)toReturn.get();
        }
        catch (HttpExceptionWithDetails e) {
            int reasonCode = e.getReasonCode();
            if (reasonCode == 401 || reasonCode == 403) {
                throw new NotAuthorizedException(e);
            }
            if (reasonCode == 404) {
                throw new NotFoundException(new RepositoryLocation(repositoryUri, branch, ""));
            }
            throw new UnexpectedException(this.parseErrorMessage(e), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private GitlabAccessToken getKnownAccessToken() {
        CredentialTypes credentialTypes = this.onPremise ? CredentialTypes.GITLAB_E : CredentialTypes.GITLAB;
        return (GitlabAccessToken)GitCredentialsProvider.getAccessToken(this.contextId, credentialTypes);
    }

    private void setConnAuthorization(URLConnection conn, GitlabAccessToken accessToken) {
        if (accessToken != null) {
            String accessTokenS = accessToken.getAccessToken();
            if (accessTokenS.startsWith("<oxy>")) {
                conn.setRequestProperty("PRIVATE-TOKEN", accessTokenS.substring(5));
            } else {
                conn.setRequestProperty("Authorization", "Bearer " + accessTokenS);
            }
        }
    }

    private String getRepoId(String repositoryUri, GitLabApiVersion apiVersion) throws IOException {
        String repoUri = repositoryUri.endsWith(".git") ? repositoryUri.substring(0, repositoryUri.lastIndexOf(".git")) : repositoryUri;
        try {
            return (String)REPOSITORY_IDS.get((Object)repoUri, () -> {
                AtomicReference<Object> ret = new AtomicReference<Object>(null);
                this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> ret.set(this.getRepoIdInternal(apiVersion, repoUri)));
                return ret.get();
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwable cause2 = cause.getCause();
                if (cause2 != null) {
                    cause = cause2;
                }
                if (cause instanceof HttpException) {
                    throw (HttpException)cause;
                }
                if (cause2 instanceof IOException) {
                    throw (IOException)cause;
                }
            }
            log.error("Error while retrieving repository Id", (Throwable)e);
            throw new IOException("");
        }
    }

    @Override
    public UserInformation getUserInformation() throws NotAuthorizedException, IOException {
        GitLabApiVersion apiVersion = this.getApiVersion();
        String apiV = apiVersion == GitLabApiVersion.V3 ? "/api/v3" : "/api/v4";
        URL userUrl = new URL(this.apiPrefix + apiV + "/user");
        HttpURLConnection conn = (HttpURLConnection)userUrl.openConnection();
        this.setConnAuthorization(conn, this.getKnownAccessToken());
        try (InputStream inputStream = conn.getInputStream();){
            String responseText = GitUtil.utf8InputStreamToString(inputStream);
            Map<String, Object> responseBody = GitUtil.parseJSON(responseText);
            UserInformation userInformation = new UserInformation(responseBody.get("id").toString(), responseBody.get("name").toString(), responseBody.get("email").toString());
            return userInformation;
        }
    }

    private String getRepoIdInternal(GitLabApiVersion apiVersion, String repoUri) throws MalformedURLException, IOException {
        String repositoryId;
        block8: {
            String encoded = URLUtil.encodeURIComponent((String)repoUri.substring(this.apiPrefix.length() + 1));
            String apiV = apiVersion == GitLabApiVersion.V3 ? "/api/v3" : "/api/v4";
            URL repoIdUrl = new URL(this.apiPrefix + apiV + "/projects/" + encoded);
            HttpURLConnection conn = (HttpURLConnection)repoIdUrl.openConnection();
            this.setConnAuthorization(conn, this.getKnownAccessToken());
            boolean onlyPossibleIOExceptionIsFromClose = false;
            repositoryId = null;
            try (InputStream inputStream = conn.getInputStream();){
                String responseText = GitUtil.utf8InputStreamToString(inputStream);
                Map<String, Object> responseBody = GitUtil.parseJSON(responseText);
                onlyPossibleIOExceptionIsFromClose = true;
                repositoryId = String.valueOf(responseBody.get("id"));
            }
            catch (IOException e) {
                if (onlyPossibleIOExceptionIsFromClose) break block8;
                throw e;
            }
        }
        return repositoryId;
    }

    private GitLabApiVersion getApiVersion() throws IOException, NotAuthorizedException {
        Integer apiVersion = this.apiVersion();
        if (apiVersion == null) {
            try {
                AtomicReference toReturn = new AtomicReference();
                this.getAuthService().tryAccess(this.contextId, this.getKnownAccessToken(), refreshedAccessToken -> toReturn.set(this.getApiVersionInternal()));
                return (GitLabApiVersion)((Object)toReturn.get());
            }
            catch (HttpException e) {
                int reasonCode = e.getReasonCode();
                if (reasonCode == 401 || reasonCode == 403) {
                    throw new NotAuthorizedException(e);
                }
                if (reasonCode == 404) {
                    return GitLabApiVersion.V3;
                }
                if (reasonCode != 404) {
                    log.error(e.getMessage() + ": " + e.getReason());
                }
                return GitLabApiVersion.V4;
            }
        }
        if (apiVersion == 3) {
            return GitLabApiVersion.V3;
        }
        return GitLabApiVersion.V4;
    }

    private GitLabApiVersion getApiVersionInternal() throws IOException {
        URL apiVersionUrl = new URL(this.apiPrefix + "/api/v4/version");
        HttpURLConnection conn = (HttpURLConnection)apiVersionUrl.openConnection();
        this.setConnAuthorization(conn, this.getKnownAccessToken());
        try (InputStream inputStream = conn.getInputStream();){
            GitLabApiVersion apiV;
            String responseText = GitUtil.utf8InputStreamToString(inputStream);
            Map<String, Object> responseBody = GitUtil.parseJSON(responseText);
            String version = "6.6.0";
            if (responseBody != null) {
                version = (String)responseBody.get("version");
            }
            if (this.cmpVersion(version, "9.0.0") < 0) {
                apiV = GitLabApiVersion.V3;
                this.apiVersion(3);
            } else {
                apiV = GitLabApiVersion.V4;
                this.apiVersion(4);
            }
            GitLabApiVersion gitLabApiVersion = apiV;
            return gitLabApiVersion;
        }
    }

    private void apiVersion(int apiVersion) {
        if (this.onPremise) {
            GitCredentialsProvider.setGitlabEnterpriseApiVersion(apiVersion);
        } else {
            GitCredentialsProvider.setGitlabApiVersion(apiVersion);
        }
    }

    private Integer apiVersion() {
        Integer apiVersion = this.onPremise ? GitCredentialsProvider.getGitlabEnterpriseApiVersion() : GitCredentialsProvider.getGitlabApiVersion();
        return apiVersion;
    }

    @VisibleForTesting
    int cmpVersion(String versionA, String versionB) {
        String[] pa = versionA.split("\\.");
        String[] pb = versionB.split("\\.");
        for (int i = 0; i < 3; ++i) {
            Integer na = Ints.tryParse((String)pa[i]);
            Integer nb = Ints.tryParse((String)pb[i]);
            if (na != null && nb == null) {
                return 1;
            }
            if (na == null && nb != null) {
                return -1;
            }
            if (na == null || nb == null) {
                return 0;
            }
            if (na > nb) {
                return 1;
            }
            if (nb <= na) continue;
            return -1;
        }
        return 0;
    }

    private String parseErrorMessage(HttpExceptionWithDetails exception) {
        String reason = exception.getReason();
        if (!reason.isEmpty()) {
            return (String)GitUtil.parseJSON(reason).get("message");
        }
        return exception.getMessage();
    }

    private String getBranchRefUrlParam(String branchName) {
        return "ref=" + URLUtil.encodeURIComponent((String)branchName);
    }

    private class ListFilesResult {
        public final List<HashMap<String, Object>> flies;
        public final Optional<String> nextPage;

        public ListFilesResult(List<HashMap<String, Object>> flies, Optional<String> nextPage) {
            this.flies = flies;
            this.nextPage = nextPage;
        }
    }
}

