/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.gitlab;

import com.oxygenxml.examples.gitlab.GitlabOAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationProvider;

public class GitLabApplicationAuthenticationProvider
implements ApplicationAuthenticationProvider {
    private GitlabOAuthService gitLabOAuthService;

    public GitLabApplicationAuthenticationProvider(GitlabOAuthService gitLabEnterpriseOAuthService) {
        this.gitLabOAuthService = gitLabEnterpriseOAuthService;
    }

    public String getName() {
        return "GitLab";
    }

    public String getIcon() {
        return "../plugin-resources/github-static/gitlab@2x.png";
    }

    public String getCallbackPath() {
        return "../plugins-dispatcher/gitlab-oauth";
    }

    public URL prepareAuthenticationRedirect(String sessionId) {
        OAuthState state = this.gitLabOAuthService.createStateForAuthenticationUrl(sessionId);
        try {
            return new URL(this.gitLabOAuthService.getAuthorizationUrl(state));
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isAskingForAuthorization() {
        return true;
    }
}

