/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github.hybrid;

import com.oxygenxml.examples.git.HttpConnectionFactoryInstaller;
import com.oxygenxml.examples.github.hybrid.GitEditingSessionId;
import com.oxygenxml.examples.github.hybrid.RepositoryAndBranch;
import com.oxygenxml.examples.github.hybrid.RepositoryCacheKey;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.DaemonThreadFactory;

class UserRepositoryCache {
    private static final Logger log = LoggerFactory.getLogger(UserRepositoryCache.class);
    private Map<RepositoryCacheKey, InMemoryRepository> clonesMap = new HashMap<RepositoryCacheKey, InMemoryRepository>();
    private Map<RepositoryCacheKey, Future<InMemoryRepository>> ongoingClonesMap = new HashMap<RepositoryCacheKey, Future<InMemoryRepository>>();
    private ReentrantLock lock = new ReentrantLock();
    private static ExecutorService repositoryClonerExecutor;

    UserRepositoryCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<InMemoryRepository> getIfCachedOrStartAsyncClone(RepositoryLocation repositoryLocation, CredentialsProvider credentialsProvider, GitEditingSessionId gitEditingSessionId) {
        this.lock.lock();
        try {
            Optional<Object> toReturn;
            RepositoryAndBranch repositoryAndBranch = new RepositoryAndBranch(repositoryLocation);
            RepositoryCacheKey repositoryCacheKey = new RepositoryCacheKey(repositoryAndBranch, gitEditingSessionId);
            if (this.clonesMap.containsKey(repositoryCacheKey)) {
                log.debug("cache hit {}", (Object)repositoryLocation);
                toReturn = Optional.of(this.clonesMap.get(repositoryCacheKey));
            } else if (this.ongoingClonesMap.containsKey(repositoryCacheKey)) {
                log.debug("cache almost hit {}", (Object)repositoryLocation);
                toReturn = Optional.empty();
            } else {
                log.debug("cache miss {}", (Object)repositoryLocation);
                this.startAsyncFetch(credentialsProvider, repositoryAndBranch, gitEditingSessionId);
                toReturn = Optional.empty();
            }
            Optional<Object> optional = toReturn;
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCachedClones(GitEditingSessionId gitEditingSessionId) {
        this.lock.lock();
        try {
            List<RepositoryCacheKey> clonesMapKeys = this.clonesMap.keySet().stream().filter(repositoryCachedKey -> gitEditingSessionId.equals(repositoryCachedKey.getGitEditingSessionId())).collect(Collectors.toList());
            log.debug("dispose clones {}", clonesMapKeys);
            clonesMapKeys.forEach(this.clonesMap::remove);
            List ongoingClonesMapKeys = this.ongoingClonesMap.keySet().stream().filter(repositoryCachedKey -> gitEditingSessionId.equals(repositoryCachedKey.getGitEditingSessionId())).collect(Collectors.toList());
            log.debug("dispose ongoing clones {}", ongoingClonesMapKeys);
            for (RepositoryCacheKey cacheKeyForPending : ongoingClonesMapKeys) {
                Future<InMemoryRepository> future = this.ongoingClonesMap.remove(cacheKeyForPending);
                if (future == null) continue;
                future.cancel(false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startAsyncFetch(CredentialsProvider credentialsProvider, RepositoryAndBranch repositoryAndBranch, GitEditingSessionId gitEditingSessionId) {
        RepositoryCacheKey repositoryCacheKey = new RepositoryCacheKey(repositoryAndBranch, gitEditingSessionId);
        Future<InMemoryRepository> future = repositoryClonerExecutor.submit(() -> {
            try {
                log.debug("clone started {} ", (Object)repositoryCacheKey);
                InMemoryRepository inMemoryRepository = this.fetchRepository(repositoryAndBranch, credentialsProvider);
                this.lock.lock();
                try {
                    this.ongoingClonesMap.remove(repositoryCacheKey);
                    if (Thread.currentThread().isInterrupted()) {
                        log.debug("clone ended but ignored {} ", (Object)repositoryCacheKey);
                    } else {
                        log.debug("clone ended {} ", (Object)repositoryCacheKey);
                        this.clonesMap.put(repositoryCacheKey, inMemoryRepository);
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return inMemoryRepository;
            }
            catch (Exception e) {
                log.warn((Object)e, (Throwable)e);
                this.lock.lock();
                try {
                    this.ongoingClonesMap.remove(repositoryCacheKey);
                }
                finally {
                    this.lock.unlock();
                }
                return null;
            }
        });
        this.ongoingClonesMap.put(repositoryCacheKey, future);
    }

    private InMemoryRepository fetchRepository(RepositoryAndBranch repositoryAndBranch, CredentialsProvider credentialsProvider) throws InvalidRemoteException, TransportException, GitAPIException {
        DfsRepositoryDescription repoDesc = new DfsRepositoryDescription();
        InMemoryRepository repository = new InMemoryRepository(repoDesc);
        try (Git git = new Git((Repository)repository);){
            String branch = repositoryAndBranch.getBranch();
            ((FetchCommand)git.fetch().setDepth(1).setCredentialsProvider(credentialsProvider)).setRemote(repositoryAndBranch.getRepositoryUri()).setRefSpecs(new RefSpec[]{new RefSpec("+refs/heads/" + branch + ":refs/heads/" + repositoryAndBranch.getBranch())}).call();
        }
        return repository;
    }

    static {
        HttpConnectionFactoryInstaller.install();
        repositoryClonerExecutor = Executors.newCachedThreadPool(DaemonThreadFactory.defaultThreadFactory());
    }
}

