/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github.hybrid;

import com.oxygenxml.examples.common.LicenseChecker;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.NotDirectoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.plugin.FilterURLConnection;
import ro.sync.exml.plugin.PluginLicensingException;
import ro.sync.net.protocol.FileBrowsingConnection;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class UrlConnectionOverGitRepository
extends FilterURLConnection
implements FileBrowsingConnection {
    private static final Logger log = LoggerFactory.getLogger(UrlConnectionOverGitRepository.class);
    private InMemoryRepository repository;
    private RepositoryLocation repositoryLocation;

    public UrlConnectionOverGitRepository(URL url, InMemoryRepository repository, RepositoryLocation repositoryLocation) {
        super(new URLConnection(url){

            @Override
            public void connect() throws IOException {
                this.connected = true;
            }
        });
        this.repository = repository;
        this.repositoryLocation = repositoryLocation;
        if (!LicenseChecker.isLicensed()) {
            throw new PluginLicensingException(LicenseChecker.ERROR_MESSAGE);
        }
    }

    public InputStream getInputStream() throws IOException {
        RevCommit headCommit = this.getBranchCommit();
        Optional<ObjectId> blobIdOpt = this.findBlob(this.repositoryLocation.getPath(), headCommit);
        if (blobIdOpt.isPresent()) {
            ObjectId blobId = blobIdOpt.get();
            return new ByteArrayInputStream(this.repository.open((AnyObjectId)blobId).getBytes());
        }
        throw new FileNotFoundException();
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        ArrayList<FolderEntryDescriptor> folderEntryDescriptors = new ArrayList<FolderEntryDescriptor>();
        RevCommit commit = this.getBranchCommit();
        String rawPath = this.repositoryLocation.getPath();
        String filePath = rawPath.endsWith("/") ? rawPath.substring(0, rawPath.length() - 1) : rawPath;
        try (TreeWalk treeWalk = new TreeWalk((Repository)this.repository);){
            RevTree tree = commit.getTree();
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(false);
            this.moveWalkerToFilePath(filePath, treeWalk);
            while (treeWalk.next()) {
                String path = treeWalk.getPathString();
                boolean isTree = treeWalk.isSubtree();
                if (isTree) {
                    folderEntryDescriptors.add(new FolderEntryDescriptor(path + "/"));
                    continue;
                }
                folderEntryDescriptors.add(new FolderEntryDescriptor(path));
            }
        }
        return folderEntryDescriptors;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    private void moveWalkerToFilePath(String filePath, TreeWalk treeWalk) throws IOException {
        if (!filePath.isEmpty() && !filePath.equals("/")) {
            while (treeWalk.next()) {
                if (!treeWalk.isSubtree()) continue;
                String treeWalkPath = treeWalk.getPathString();
                if (filePath.equals(treeWalkPath)) {
                    treeWalk.enterSubtree();
                    break;
                }
                if (!filePath.startsWith(treeWalkPath + "/")) continue;
                treeWalk.enterSubtree();
            }
            if (!filePath.equals(treeWalk.getPathString())) {
                throw new NotDirectoryException("Path not found: " + filePath);
            }
        }
    }

    private RevCommit getBranchCommit() throws FileNotFoundException {
        RevCommit revCommit;
        RevWalk revWalk = new RevWalk((Repository)this.repository);
        try {
            RevCommit commit;
            ObjectId headCommitId = this.repository.resolve("refs/heads/" + this.repositoryLocation.getBranch());
            revCommit = commit = revWalk.parseCommit((AnyObjectId)headCommitId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    revWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn("missing commit of branch {} in {}", (Object)this.repositoryLocation.getBranch(), (Object)this.repositoryLocation.getRepositoryUri());
                throw new FileNotFoundException();
            }
        }
        revWalk.close();
        return revCommit;
    }

    private Optional<ObjectId> findBlob(String filePath, RevCommit commit) throws IOException {
        try (TreeWalk treeWalk = new TreeWalk((Repository)this.repository);){
            RevTree tree = commit.getTree();
            treeWalk.addTree((AnyObjectId)tree);
            treeWalk.setRecursive(true);
            treeWalk.setFilter((TreeFilter)PathFilter.create((String)filePath));
            if (treeWalk.next()) {
                ObjectId objectId = treeWalk.getObjectId(0);
                Optional<ObjectId> optional = Optional.of(objectId);
                return optional;
            }
            log.warn("missing tree {} for commit {} in {}", new Object[]{filePath, commit.getId(), this.repositoryLocation.getRepositoryUri()});
            Optional<ObjectId> optional = Optional.empty();
            return optional;
        }
    }
}

