/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github.hybrid;

import com.oxygenxml.examples.github.GithubUrlStreamHandler;
import com.oxygenxml.examples.github.hybrid.GitEditingSessionId;
import com.oxygenxml.examples.github.hybrid.UserRepositoryCache;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.EditingSessionOpenVetoException;
import ro.sync.ecss.extensions.api.webapp.access.WebappEditingSessionLifecycleListener;

public class InMemoryRepositoryCache
extends WebappEditingSessionLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(InMemoryRepositoryCache.class);
    private static final ThreadLocal<GitEditingSessionId> LOADING_GIT_DOC_THREAD_MARKER = new ThreadLocal();
    private SessionStore sessionStore;

    public void editingSessionAboutToBeStarted(String editingSessionId, String licenseeId, URL systemId, Map<String, Object> options) throws EditingSessionOpenVetoException {
        if (this.canHandle(systemId)) {
            log.debug("git editingSessionAboutToBeStarted {}", (Object)editingSessionId);
            GitEditingSessionId gitEditingSessionId = new GitEditingSessionId(editingSessionId);
            LOADING_GIT_DOC_THREAD_MARKER.set(gitEditingSessionId);
        }
    }

    public void editingSessionStarted(String editingSessionId, AuthorDocumentModel documentModel) {
        GitEditingSessionId gitEditingSessionId = LOADING_GIT_DOC_THREAD_MARKER.get();
        if (gitEditingSessionId != null) {
            log.debug("git editingSessionStarted {}", (Object)editingSessionId);
            String contextId = (String)documentModel.getAuthorAccess().getEditorAccess().getEditingContext().getAttribute("session-id");
            this.getUserRepositoryCache(contextId).invalidateCachedClones(gitEditingSessionId);
            LOADING_GIT_DOC_THREAD_MARKER.remove();
        }
    }

    public void editingSessionFailedToStart(String editingSessionId, String licenseeId, URL systemId, Map<String, Object> options) {
        if (this.canHandle(systemId)) {
            log.debug("git editingSessionFailedToStart {}", (Object)editingSessionId);
            GitEditingSessionId gitEditingSessionId = new GitEditingSessionId(editingSessionId);
            String contextId = (String)options.get("session-id");
            this.getUserRepositoryCache(contextId).invalidateCachedClones(gitEditingSessionId);
            LOADING_GIT_DOC_THREAD_MARKER.remove();
        }
    }

    public Optional<InMemoryRepository> getOrCloneIfDocLoads(RepositoryLocation repositoryLocation, String contextId, CredentialsProvider credentialsProvider) {
        GitEditingSessionId gitEditingSessionId = LOADING_GIT_DOC_THREAD_MARKER.get();
        if (gitEditingSessionId != null) {
            UserRepositoryCache userRepositoryCache = this.getUserRepositoryCache(contextId);
            return userRepositoryCache.getIfCachedOrStartAsyncClone(repositoryLocation, credentialsProvider, gitEditingSessionId);
        }
        return Optional.empty();
    }

    private UserRepositoryCache getUserRepositoryCache(String contextId) {
        UserRepositoryCache userRepositoryCache = (UserRepositoryCache)this.sessionStore.get(contextId, UserRepositoryCache.class.getName());
        if (userRepositoryCache == null) {
            userRepositoryCache = new UserRepositoryCache();
            log.debug("getUserRepositoryCache contextId:{} created", (Object)contextId);
            this.sessionStore.put(contextId, UserRepositoryCache.class.getName(), (Object)userRepositoryCache);
        }
        return userRepositoryCache;
    }

    private boolean canHandle(URL url) {
        if (!GithubUrlStreamHandler.GitProtocol.canHandle(url)) {
            return false;
        }
        GithubUrlStreamHandler.GitProtocol gitProtocol = GithubUrlStreamHandler.GitProtocol.valueOf(url);
        switch (gitProtocol) {
            case GITHUB: 
            case GITHUB1: 
            case BITBUCKET: 
            case BITBUCKET_SERVER: 
            case GITLAB: 
            case GITLAB_ENTERPRISE: {
                return true;
            }
        }
        return false;
    }

    public InMemoryRepositoryCache(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }
}

