/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github.apiclient;

import com.oxygenxml.examples.github.GitHubOAuthService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OwnerAndRepo {
    private String owner;
    private String repo;

    private OwnerAndRepo(String owner, String repo) {
        this.owner = owner;
        this.repo = repo;
    }

    public static OwnerAndRepo from(String repositoryUri) {
        Matcher m = Pattern.compile(Pattern.quote(GitHubOAuthService.getGitHubLoginBase()) + "/([^/]+)/([^/]+)").matcher(repositoryUri);
        if (m.find()) {
            String owner = m.group(1);
            String repo = m.group(2);
            if (repo.endsWith(".git")) {
                repo = repo.substring(0, repo.length() - ".git".length());
            }
            return new OwnerAndRepo(owner, repo);
        }
        throw new IllegalArgumentException("Invalid repositoryUri: " + repositoryUri);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }
}

