/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github.apiclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.github.apiclient.OwnerAndRepo;
import com.oxygenxml.examples.github.apiclient.model.GitFileContent;
import com.oxygenxml.examples.github.apiclient.model.GitHubUser;
import com.oxygenxml.examples.github.apiclient.model.GitObject;
import com.oxygenxml.examples.github.apiclient.model.GitRef;
import com.oxygenxml.examples.github.apiclient.model.GitTree;
import com.oxygenxml.examples.github.apiclient.model.GitTreeLeaf;
import com.oxygenxml.examples.webauthorgitapi.DocumentToCommit;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.FailCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.MergeCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.OkCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class GitHubV3Api
implements WebAuthorGitApi {
    private String apiUrl;
    private String accessToken;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public GitHubV3Api(String apiUrl, String accessToken) {
        this.apiUrl = apiUrl == null ? "https://api.github.com" : apiUrl + "/api/v3";
        this.accessToken = accessToken;
    }

    @Override
    public UserInformation getUserInformation() throws NotAuthorizedException, IOException {
        String url = this.apiUrl + "/user?" + System.currentTimeMillis();
        HttpURLConnection connection = this.createApiConnection("GET", url);
        int responseCode = connection.getResponseCode();
        if (401 == responseCode || 403 == responseCode) {
            throw new NotAuthorizedException("");
        }
        try (InputStream inputStream = connection.getInputStream();){
            GitHubUser githubUser = Functions.parseJson(inputStream, GitHubUser.class);
            UserInformation userInformation = new UserInformation(githubUser.getId(), githubUser.getName() != null ? githubUser.getName() : githubUser.getLogin(), githubUser.getEmail());
            return userInformation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContents(RepositoryLocation location, byte[] content) throws IOException, NotAuthorizedException {
        GitFileContent gitFileContent;
        block13: {
            gitFileContent = null;
            try {
                gitFileContent = this.getGitFileContent(location);
            }
            catch (HttpExceptionWithDetails e) {
                if (e.getReasonCode() == 404 && e.getReason().contains("\"message\":\"Not Found\"")) break block13;
                throw e;
            }
        }
        String createdWithWebAuthorMsg = GitHubV3Api.getMessage("Created_with_oxygen_web_author");
        String encodedContent = Base64.encodeBase64String((byte[])content);
        String apiRequestBody = gitFileContent != null ? "{\"message\":\"" + createdWithWebAuthorMsg + "\",\"content\":\"" + encodedContent + "\",\"sha\":\"" + gitFileContent.getSha() + "\",\"branch\":\"" + location.getBranch() + "\"}" : "{\"message\":\"" + createdWithWebAuthorMsg + "\",\"content\":\"" + encodedContent + "\",\"branch\":\"" + location.getBranch() + "\"}";
        String url = this.getApiUrl(location);
        HttpURLConnection putApiConnection = this.createApiConnection("PUT", url);
        try {
            try (OutputStream outputStream = putApiConnection.getOutputStream();){
                outputStream.write(apiRequestBody.getBytes(StandardCharsets.UTF_8));
                outputStream.close();
            }
            catch (HttpExceptionWithDetails e) {
                throw new NotAuthorizedException(e);
            }
        }
        finally {
            putApiConnection.disconnect();
        }
    }

    private static String getMessage(String tag) {
        PluginResourceBundle rb;
        WebappPluginWorkspace ws = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        if (ws != null && (rb = ws.getResourceBundle()) != null) {
            return rb.getMessage(tag);
        }
        return tag;
    }

    @Override
    public CommitOperationResult commitDocuments(List<DocumentToCommit> documents, String repositoryUri, String branch, String latestCommitSha, String commitMessage, boolean forcePush) {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(repositoryUri);
        String commitSha = null;
        try {
            String headSha = this.getSha(ownerAndRepo, branch);
            GitTree tree = this.getTree(ownerAndRepo, headSha);
            GitTree updatedTree = this.updateTree(ownerAndRepo, tree.getSha(), documents);
            commitSha = this.commit(ownerAndRepo, updatedTree.getSha(), headSha, commitMessage);
            if (!headSha.equals(latestCommitSha) && !forcePush) {
                String diffUrl = this.getDiffUrl(ownerAndRepo, headSha, commitSha);
                return new MergeCommitOperationResult(false, headSha, diffUrl);
            }
            this.updateRef(ownerAndRepo, branch, commitSha, forcePush, 15);
            return new OkCommitOperationResult(commitSha, documents);
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReason().contains("Update is not a fast forward")) {
                return this.handleCommitConflict(ownerAndRepo, branch, commitSha);
            }
            return new FailCommitOperationResult(e.getReasonCode(), this.parseErrorMessage(e.getReason()));
        }
        catch (IOException e) {
            return new FailCommitOperationResult(Functions.getExceptionStatus(e), e.getMessage());
        }
    }

    @Override
    public String getContentAtCommit(RepositoryLocation location, String commitSha, String encoding) throws NotAuthorizedException, NotFoundException {
        try {
            GitFileContent fileContent = this.getGitFileContent(location, commitSha);
            byte[] decodedContent = Base64.decodeBase64((String)fileContent.getB64Content());
            return new String(decodedContent, encoding);
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 401 || e.getMessage().startsWith("403 Forbidden")) {
                throw new NotAuthorizedException(e);
            }
            if (e.getReasonCode() == 404) {
                throw new NotFoundException(location);
            }
            throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public void createBranch(String repositoryUri, String newBranch, String sourceRepositoryUri, String sourceBranch) throws NotAuthorizedException {
        block2: {
            try {
                this.createBranchInternal(repositoryUri, newBranch, sourceRepositoryUri, sourceBranch);
            }
            catch (NotAuthorizedException ex) {
                if (ex.getHttpErrorCode() != 404 || repositoryUri.equals(sourceRepositoryUri)) break block2;
                this.syncForkWithUpstream(OwnerAndRepo.from(repositoryUri), sourceBranch);
                this.createBranchInternal(repositoryUri, newBranch, sourceRepositoryUri, sourceBranch);
            }
        }
    }

    private void createBranchInternal(String repositoryUri, String newBranch, String sourceRepositoryUri, String sourceBranch) throws NotAuthorizedException {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(repositoryUri);
        OwnerAndRepo sourceOwnerAndRepo = OwnerAndRepo.from(sourceRepositoryUri);
        try {
            String branchSha = this.getSha(sourceOwnerAndRepo, sourceBranch);
            this.createRef(ownerAndRepo, newBranch, branchSha);
        }
        catch (HttpExceptionWithDetails e) {
            this.handleHttpException(e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private void handleHttpException(HttpExceptionWithDetails e) throws NotAuthorizedException {
        int reasonCode = e.getReasonCode();
        if (reasonCode == 401 || reasonCode == 403) {
            NotAuthorizedException ex = new NotAuthorizedException(e);
            throw ex;
        }
        if (reasonCode == 404) {
            NotAuthorizedException ex = new NotAuthorizedException(GitHubV3Api.getMessage("Possibly_not_authorized_to_make_changes"), e, reasonCode);
            throw ex;
        }
        throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GitTreeLeaf[] listFiles(RepositoryLocation location) throws NotFoundException, NotAuthorizedException {
        String url = this.getApiUrl(location);
        try (InputStream inputStream = this.createApiConnection("GET", url).getInputStream();){
            GitTreeLeaf[] leafs = Functions.parseJson(inputStream, GitTreeLeaf[].class);
            if (leafs.length >= 1000) {
                GitTreeLeaf[] gitTreeLeafArray2 = this.listManyFiles(location);
                return gitTreeLeafArray2;
            }
            GitTreeLeaf[] gitTreeLeafArray = leafs;
            return gitTreeLeafArray;
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("401")) throw new NotAuthorizedException(e);
            if (e.getMessage().startsWith("403 Forbidden")) {
                throw new NotAuthorizedException(e);
            }
            if (!e.getMessage().startsWith("404")) throw new UnexpectedException(e.getMessage(), e);
            throw new NotFoundException(location);
        }
    }

    public boolean haveRepositoryAccess(RepositoryLocation location) {
        boolean haveAccess;
        block3: {
            haveAccess = true;
            OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(location.getRepositoryUri());
            String apiBase = this.getApiBase(ownerAndRepo);
            try {
                HttpURLConnection conn = this.createApiConnection("GET", apiBase);
                int responseCode = conn.getResponseCode();
                if (responseCode == 404 || responseCode == 401) {
                    haveAccess = false;
                }
            }
            catch (IOException e) {
                if (!e.getMessage().startsWith("404") && !e.getMessage().startsWith("401")) break block3;
                haveAccess = false;
            }
        }
        return haveAccess;
    }

    @Override
    public InputStream read(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        try {
            GitFileContent gitFileContent = this.getGitFileContent(location);
            byte[] decodedContent = Base64.decodeBase64((String)gitFileContent.getB64Content());
            return new ByteArrayInputStream(decodedContent);
        }
        catch (HttpExceptionWithDetails e) {
            if (e.getReasonCode() == 404) {
                throw new NotFoundException(location);
            }
            if (e.getReasonCode() == 401 || e.getMessage().startsWith("403 Forbidden")) {
                throw new NotAuthorizedException(e);
            }
            throw new UnexpectedException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public String getShaOfCommitThatCreatedDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        String string;
        block11: {
            String url = this.getApiBase(OwnerAndRepo.from(location.getRepositoryUri())) + "/commits?sha=" + location.getBranch() + "&path=" + GitUtil.encodePath(location.getPath());
            InputStream response = this.createApiConnection("GET", url).getInputStream();
            try {
                String responseString = GitUtil.utf8InputStreamToString(response);
                List commits = (List)OBJECT_MAPPER.readValue(responseString, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                string = (String)((Map)commits.get(commits.size() - 1)).get("sha");
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpExceptionWithDetails e) {
                    if (e.getReasonCode() == 401 || e.getMessage().startsWith("403 Forbidden")) {
                        throw new NotAuthorizedException(e);
                    }
                    if (e.getReasonCode() == 404) {
                        throw new NotFoundException(location);
                    }
                    throw new UnexpectedException(this.parseErrorMessage(e.getReason()), e);
                }
                catch (IOException e) {
                    throw new UnexpectedException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return string;
    }

    GitTreeLeaf[] listManyFiles(RepositoryLocation location) throws IOException {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(location.getRepositoryUri());
        String refSha = this.getSha(ownerAndRepo, location.getBranch());
        GitTree tree = this.getTree(ownerAndRepo, refSha);
        String fileInLocationRegexp = Pattern.quote(location.getPath()) + "/[^/]+$";
        return (GitTreeLeaf[])tree.getLeafs().stream().filter(leaf -> leaf.getPath().matches(fileInLocationRegexp)).toArray(GitTreeLeaf[]::new);
    }

    private String commit(OwnerAndRepo ownerAndRepo, String treeSha, String parentSha, String commitMessage) throws IOException {
        String commitUrl = this.getApiBase(ownerAndRepo) + "/git/commits";
        HttpURLConnection postApiConnection = this.createApiConnection("POST", commitUrl);
        try {
            String string;
            block16: {
                StringBuilder body = new StringBuilder();
                body.append("{\"message\":").append(OBJECT_MAPPER.writeValueAsString((Object)commitMessage)).append(",");
                body.append("\"tree\":\"").append(treeSha).append("\",");
                body.append("\"parents\":[\"").append(parentSha).append("\"]}");
                try (OutputStream outputStream = postApiConnection.getOutputStream();){
                    outputStream.write(body.toString().getBytes(StandardCharsets.UTF_8));
                }
                InputStream inputStream = postApiConnection.getInputStream();
                try {
                    Map<String, Object> parsedResponse = GitUtil.parseJSON(GitUtil.utf8InputStreamToString(inputStream));
                    string = (String)parsedResponse.get("sha");
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string;
        }
        finally {
            postApiConnection.disconnect();
        }
    }

    private String getDiffUrl(OwnerAndRepo ownerAndRepo, String baseSha, String headSha) throws IOException {
        String compareUrl = this.getApiBase(ownerAndRepo) + "/compare/" + baseSha + "..." + headSha;
        HttpURLConnection getApiConnection = this.createApiConnection("GET", compareUrl);
        try (InputStream inputStream = getApiConnection.getInputStream();){
            Map<String, Object> parsedResponse = GitUtil.parseJSON(GitUtil.utf8InputStreamToString(inputStream));
            String string = (String)parsedResponse.get("html_url");
            return string;
        }
    }

    private String createBlob(OwnerAndRepo ownerAndRepo, byte[] content) throws IOException {
        String encodedContent = Base64.encodeBase64String((byte[])content);
        String createBlobUrl = this.getApiBase(ownerAndRepo) + "/git/blobs";
        HttpURLConnection postApiConnection = this.createApiConnection("POST", createBlobUrl);
        try {
            String string;
            block16: {
                StringBuilder body = new StringBuilder();
                body.append("{\"content\":").append(OBJECT_MAPPER.writeValueAsString((Object)encodedContent)).append(",");
                body.append("\"encoding\":\"base64\"}");
                try (OutputStream outputStream = postApiConnection.getOutputStream();){
                    outputStream.write(body.toString().getBytes(StandardCharsets.UTF_8));
                }
                InputStream inputStream = postApiConnection.getInputStream();
                try {
                    Map<String, Object> parsedResponse = GitUtil.parseJSON(GitUtil.utf8InputStreamToString(inputStream));
                    string = (String)parsedResponse.get("sha");
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string;
        }
        finally {
            postApiConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRef(OwnerAndRepo ownerAndRepo, String ref, String sha) throws IOException {
        String refWithPrefix = "refs/heads/" + ref;
        String createRefUrl = this.getApiBase(ownerAndRepo) + "/git/refs";
        HttpURLConnection postApiConnection = this.createApiConnection("POST", createRefUrl);
        try {
            StringBuilder body = new StringBuilder();
            body.append("{\"ref\":").append(OBJECT_MAPPER.writeValueAsString((Object)refWithPrefix)).append(",");
            body.append("\"sha\":\"").append(sha).append("\"}");
            try (OutputStream outputStream = postApiConnection.getOutputStream();){
                outputStream.write(body.toString().getBytes(StandardCharsets.UTF_8));
            }
            InputStream inputStream = postApiConnection.getInputStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        finally {
            postApiConnection.disconnect();
        }
    }

    @VisibleForTesting
    public String getSha(OwnerAndRepo ownerAndRepo, String branchName) throws IOException {
        String string;
        block9: {
            String url = this.getApiBase(ownerAndRepo) + "/git/refs/heads/" + URLUtil.encodeURIComponent((String)branchName);
            InputStream inputStream = this.createApiConnection("GET", url).getInputStream();
            try {
                string = Functions.parseJson(inputStream, GitRef.class).getObject().getSha();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HttpExceptionWithDetails e) {
                    if (e.getReasonCode() == 404) {
                        String commitSha = branchName;
                        return this.getCommit(ownerAndRepo, commitSha).getSha();
                    }
                    throw e;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private GitObject getCommit(OwnerAndRepo ownerAndRepo, String commitSha) throws IOException {
        String url = this.getApiBase(ownerAndRepo) + "/git/commits/" + URLUtil.encodeURIComponent((String)commitSha);
        try (InputStream inputStream = this.createApiConnection("GET", url).getInputStream();){
            GitObject gitObject = Functions.parseJson(inputStream, GitObject.class);
            return gitObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRef(OwnerAndRepo ownerAndRepo, String ref, String sha, boolean forcePush, int times) throws IOException {
        String updateRefUrl = this.getApiBase(ownerAndRepo) + "/git/refs/heads/" + ref;
        HttpURLConnection patchApiConnection = this.createApiConnection("POST", updateRefUrl);
        try {
            patchApiConnection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
            StringBuilder body = new StringBuilder();
            body.append("{\"sha\":\"").append(sha).append("\",");
            body.append("\"force\":").append(forcePush).append("}");
            try (OutputStream outputStream = patchApiConnection.getOutputStream();){
                outputStream.write(body.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (HttpExceptionWithDetails e) {
                if (e.getReason().contains("Reference cannot be updated") && times > 0) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                    this.updateRef(ownerAndRepo, ref, sha, forcePush, --times);
                    patchApiConnection.disconnect();
                    return;
                }
                throw e;
            }
            InputStream inputStream = patchApiConnection.getInputStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        finally {
            patchApiConnection.disconnect();
        }
    }

    @VisibleForTesting
    GitTree getTree(OwnerAndRepo ownerAndRepo, String treeSha) throws IOException {
        String url = this.getApiBase(ownerAndRepo) + "/git/trees/" + treeSha + "?recursive=true";
        try (InputStream inputStream = this.createApiConnection("GET", url).getInputStream();){
            GitTree gitTree = Functions.parseJson(inputStream, GitTree.class);
            return gitTree;
        }
    }

    private GitTree updateTree(OwnerAndRepo ownerAndRepo, String baseTreeSha, List<DocumentToCommit> documents) throws IOException {
        String updateTreeUrl = this.getApiBase(ownerAndRepo) + "/git/trees";
        HttpURLConnection postApiConnection = this.createApiConnection("POST", updateTreeUrl);
        try {
            GitTree gitTree;
            block17: {
                StringBuilder body = new StringBuilder();
                body.append("{\"base_tree\":\"").append(baseTreeSha).append("\",\"tree\":[");
                for (DocumentToCommit document : documents) {
                    byte[] content = document.getContentToCommit();
                    String path = document.getLocation().getPath();
                    body.append("{");
                    body.append("\"path\":").append(OBJECT_MAPPER.writeValueAsString((Object)path)).append(",");
                    body.append("\"mode\":\"100644\",");
                    body.append("\"type\":\"blob\",");
                    body.append("\"sha\":\"").append(this.createBlob(ownerAndRepo, content)).append("\"");
                    body.append("},");
                }
                body.deleteCharAt(body.length() - 1).append("]}");
                byte[] bodyBytes = body.toString().getBytes(StandardCharsets.UTF_8);
                try (OutputStream outputStream = postApiConnection.getOutputStream();){
                    outputStream.write(bodyBytes);
                }
                InputStream inputStream = postApiConnection.getInputStream();
                try {
                    gitTree = Functions.parseJson(inputStream, GitTree.class);
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return gitTree;
        }
        finally {
            postApiConnection.disconnect();
        }
    }

    @VisibleForTesting
    GitFileContent getGitFileContent(RepositoryLocation location) throws IOException {
        String url = this.getApiUrl(location);
        try (InputStream inputStream = this.createApiConnection("GET", url).getInputStream();){
            GitFileContent gitFileContent = Functions.parseJson(inputStream, GitFileContent.class);
            if (gitFileContent.isIncomplete()) {
                GitFileContent gitFileContent2 = this.getLargeGitFileContent(location);
                return gitFileContent2;
            }
            GitFileContent gitFileContent3 = gitFileContent;
            return gitFileContent3;
        }
    }

    GitFileContent getGitFileContent(RepositoryLocation location, String commitSha) throws IOException {
        String url = this.getFileContentUrl(location, commitSha);
        try (InputStream inputStream = this.createApiConnection("GET", url).getInputStream();){
            GitFileContent fileContent = Functions.parseJson(inputStream, GitFileContent.class);
            if (fileContent.isIncomplete()) {
                GitFileContent gitFileContent = this.getLargeGitFileContent(location, commitSha);
                return gitFileContent;
            }
            GitFileContent gitFileContent = fileContent;
            return gitFileContent;
        }
    }

    @VisibleForTesting
    GitFileContent getLargeGitFileContent(RepositoryLocation location) throws IOException {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(location.getRepositoryUri());
        String refSha = this.getSha(ownerAndRepo, location.getBranch());
        GitTree tree = this.getTree(ownerAndRepo, refSha);
        GitTreeLeaf treeLeaf = tree.getLeafs().stream().filter(leaf -> leaf.getPath().equals(location.getPath())).findFirst().orElseThrow(() -> new HttpExceptionWithDetails("404 Not Found", 404, "{\"message\":\"Not Found\",\"documentation_url\":\"https://developer.github.com/v3/repos/contents/#get-contents\"}", null));
        try (InputStream inputStream = this.createApiConnection("GET", treeLeaf.getUrl()).getInputStream();){
            GitFileContent gitFileContent = Functions.parseJson(inputStream, GitFileContent.class);
            return gitFileContent;
        }
    }

    GitFileContent getLargeGitFileContent(RepositoryLocation location, String commitSha) throws IOException {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(location.getRepositoryUri());
        GitTree tree = this.getTree(ownerAndRepo, commitSha);
        GitTreeLeaf treeLeaf = tree.getLeafs().stream().filter(leaf -> leaf.getPath().equals(location.getPath())).findFirst().orElseThrow(() -> new HttpExceptionWithDetails("404 Not Found", 404, "{\"message\":\"Not Found\",\"documentation_url\":\"https://developer.github.com/v3/repos/contents/#get-contents\"}", null));
        try (InputStream inputStream = this.createApiConnection("GET", treeLeaf.getUrl()).getInputStream();){
            GitFileContent gitFileContent = Functions.parseJson(inputStream, GitFileContent.class);
            return gitFileContent;
        }
    }

    private String getApiBase(OwnerAndRepo ownerAndRepo) {
        return MessageFormat.format("{0}/repos/{1}/{2}", this.apiUrl, ownerAndRepo.getOwner(), ownerAndRepo.getRepo());
    }

    private String getApiUrl(RepositoryLocation location) {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(location.getRepositoryUri());
        return this.getApiBase(ownerAndRepo) + "/contents/" + GitUtil.encodePath(location.getPath()) + "?ref=" + URLUtil.encodeURIComponent((String)location.getBranch());
    }

    private String getFileContentUrl(RepositoryLocation location, String commitSha) {
        OwnerAndRepo ownerAndRepo = OwnerAndRepo.from(location.getRepositoryUri());
        return this.getApiBase(ownerAndRepo) + "/contents/" + GitUtil.encodePath(location.getPath()) + "?ref=" + URLUtil.encodeURIComponent((String)commitSha);
    }

    private HttpURLConnection createApiConnection(String requestMethod, String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("Authorization", "token " + this.accessToken);
        conn.setRequestProperty("Accept", "application/vnd.github+json");
        conn.setRequestMethod(requestMethod);
        if (!requestMethod.equals("GET")) {
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
        }
        return conn;
    }

    private String parseErrorMessage(String reason) {
        return (String)GitUtil.parseJSON(reason).get("message");
    }

    private CommitOperationResult handleCommitConflict(OwnerAndRepo ownerAndRepo, String branch, String commitSha) {
        try {
            String headSha = this.getSha(ownerAndRepo, branch);
            String diffUrl = this.getDiffUrl(ownerAndRepo, headSha, commitSha);
            return new MergeCommitOperationResult(false, headSha, diffUrl);
        }
        catch (IOException e1) {
            return new FailCommitOperationResult(Functions.getExceptionStatus(e1), e1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String syncForkWithUpstream(OwnerAndRepo ownerAndRepo, String sourceBranch) throws NotAuthorizedException {
        String message = null;
        try {
            String syncFork = this.getApiBase(ownerAndRepo) + "/merge-upstream";
            HttpURLConnection postApiConnection = this.createApiConnection("POST", syncFork);
            try {
                StringBuilder body = new StringBuilder();
                body.append("{\"branch\":").append(OBJECT_MAPPER.writeValueAsString((Object)sourceBranch)).append("}");
                try (OutputStream outputStream = postApiConnection.getOutputStream();){
                    outputStream.write(body.toString().getBytes(StandardCharsets.UTF_8));
                }
                try (InputStream inputStream = postApiConnection.getInputStream();){
                    message = GitUtil.utf8InputStreamToString(inputStream);
                }
            }
            finally {
                postApiConnection.disconnect();
            }
        }
        catch (HttpExceptionWithDetails e) {
            this.handleHttpException(e);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        return message;
    }
}

