/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.github.GitOptionsHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.plugin.workspace.security.Response;
import ro.sync.exml.plugin.workspace.security.TrustedHostsProviderExtension;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class TrustedHostsProvider
implements TrustedHostsProviderExtension {
    private static final Logger log = LoggerFactory.getLogger(TrustedHostsProvider.class);
    private AtomicReference<Set<String>> trustedHostsRef = new AtomicReference<Object>(null);
    private final Set<String> dependsOnOptions = new HashSet<String>(Arrays.asList("github.client_id", "github.client_secret", "github.api_url", "gitlab.client_id", "gitlab.client_secret", "gitlab.redirect_url", "gitlab-e.client_id", "gitlab-e.client_secret", "gitlab-e.redirect_url", "gitlab-e.api_url", "bitbucket.client_id", "bitbucket.client_secret", "bitbucketserver.consumer_key", "bitbucketserver.private_key", "bitbucketserver.public_key", "bitbucketserver.api_url"));

    public TrustedHostsProvider() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        this.updateTrustedHosts();
        this.dependsOnOptions.stream().map(optionKey -> new WSOptionListener((String)optionKey){

            public void optionValueChanged(WSOptionChangedEvent event) {
                TrustedHostsProvider.this.updateTrustedHosts();
            }
        }).forEach(arg_0 -> ((WSOptionsStorage)optionsStorage).addOptionListener(arg_0));
    }

    public Response isTrusted(String hostName) {
        Set<String> trustedHosts = this.trustedHostsRef.get();
        if (trustedHosts != null && trustedHosts.contains(hostName)) {
            return TRUSTED;
        }
        return UNKNOWN;
    }

    synchronized void updateTrustedHosts() {
        String trustedHost;
        URL url;
        HashSet<Object> newTrustedHosts = new HashSet<Object>();
        WSOptionsStorage options = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (GitOptionsHelper.getOption("github.client_id", null, options) != null && GitOptionsHelper.getOption("github.client_secret", null, options) != null) {
            newTrustedHosts.add("gist.githubusercontent.com:443");
            try {
                String githubApiUrl = GitOptionsHelper.getOption("github.api_url", null, options);
                if (githubApiUrl == null) {
                    githubApiUrl = "https://api.github.com";
                }
                URL url2 = new URL(githubApiUrl);
                String trustedHost2 = url2.getHost() + ":" + (url2.getPort() != -1 ? url2.getPort() : url2.getDefaultPort());
                newTrustedHosts.add(trustedHost2);
                if (GitOptionsHelper.getOption("github.api_url", null, options) == null) {
                    String githubLoginBaseHost = "github.com:443";
                    newTrustedHosts.add(githubLoginBaseHost);
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        if (GitOptionsHelper.getOption("gitlab.client_id", null, options) != null && GitOptionsHelper.getOption("gitlab.client_secret", null, options) != null && GitOptionsHelper.getOption("gitlab.redirect_url", null, options) != null) {
            try {
                url = new URL("https://gitlab.com");
                trustedHost = url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
                newTrustedHosts.add(trustedHost);
            }
            catch (MalformedURLException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        if (GitOptionsHelper.getOption("gitlab-e.client_id", null, options) != null && GitOptionsHelper.getOption("gitlab-e.client_secret", null, options) != null && GitOptionsHelper.getOption("gitlab-e.redirect_url", null, options) != null && GitOptionsHelper.getOption("gitlab-e.api_url", null, options) != null) {
            try {
                url = new URL(GitOptionsHelper.getOption("gitlab-e.api_url", null, options));
                trustedHost = url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
                newTrustedHosts.add(trustedHost);
            }
            catch (MalformedURLException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        if (GitOptionsHelper.getOption("bitbucket.client_id", null, options) != null && GitOptionsHelper.getOption("bitbucket.client_secret", null, options) != null) {
            newTrustedHosts.add("bitbucket.org:443");
            newTrustedHosts.add("api.bitbucket.org:443");
        }
        if (GitOptionsHelper.getOption("bitbucketserver.consumer_key", null, options) != null && GitOptionsHelper.getOption("bitbucketserver.private_key", null, options) != null && GitOptionsHelper.getOption("bitbucketserver.public_key", null, options) != null && GitOptionsHelper.getOption("bitbucketserver.api_url", null, options) != null) {
            try {
                url = new URL(GitOptionsHelper.getOption("bitbucketserver.api_url", null, options));
                trustedHost = url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
                newTrustedHosts.add(trustedHost);
            }
            catch (MalformedURLException e) {
                log.warn((Object)e, (Throwable)e);
            }
        }
        this.trustedHostsRef.set(newTrustedHosts);
    }
}

