/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.authflow.UserPassEmailCredentialsProvider;
import com.oxygenxml.examples.bitbucket.BitbucketApi;
import com.oxygenxml.examples.bitbucket.BitbucketUrlConnection;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerApi;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerUrlConnection;
import com.oxygenxml.examples.common.BaseUrlConnection;
import com.oxygenxml.examples.git.GitAccess;
import com.oxygenxml.examples.git.GitUrlConnection;
import com.oxygenxml.examples.github.GithubUrlConnection;
import com.oxygenxml.examples.github.apiclient.GitHubV3Api;
import com.oxygenxml.examples.github.hybrid.InMemoryRepositoryCacheInstaller;
import com.oxygenxml.examples.github.hybrid.UrlConnectionOverGitRepository;
import com.oxygenxml.examples.gitlab.GitlabApi;
import com.oxygenxml.examples.gitlab.GitlabUrlConnection;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApis;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.storage.dfs.InMemoryRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContext;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;

public class GithubUrlStreamHandler
extends URLStreamHandlerWithContext {
    private static final Logger log = LoggerFactory.getLogger(GithubUrlStreamHandler.class);
    private static final Pattern FILE_LIST_URL_PATTERN = Pattern.compile("^github:\\/\\/getFileList\\/([^/]+)\\/([^/]+)\\/(.*)$");
    private static final Pattern FILE_CONTENT_URL_PATTERN = Pattern.compile("^github:\\/\\/getFileContent\\/([^/]+)\\/([^/]+)\\/*([^/]*)\\/*(.*)$");
    private Predicate<String> isAbsolute = Pattern.compile("^[^:]+://").asPredicate();

    protected void parseURL(URL u, String spec, int start, int limit) {
        if (!this.specContainsDirTraversals(spec)) {
            super.parseURL(u, spec, start, limit);
            return;
        }
        String initialPath = u.getPath();
        String branchName = this.extractBranchName(initialPath);
        if (branchName == null || this.isAbsolute.test(spec)) {
            super.parseURL(u, spec, start, limit);
        } else {
            String pathWithoutBranch = initialPath.substring(branchName.length() + 1);
            this.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), u.getAuthority(), u.getUserInfo(), pathWithoutBranch, u.getQuery(), u.getRef());
            super.parseURL(u, spec, start, limit);
            String path = u.getPath();
            int thirdSlashIndex = this.indexOfThirdSlash(path);
            if (!path.startsWith("/../") || thirdSlashIndex == -1) {
                this.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), u.getAuthority(), u.getUserInfo(), initialPath, u.getQuery(), u.getRef());
                super.parseURL(u, spec, start, limit);
            } else {
                String repoRelativePath = path.substring(1, thirdSlashIndex);
                String gitRepoUri = URLUtil.decodeURIComponent((String)u.getHost()) + "/";
                boolean endsWithGit = gitRepoUri.endsWith(".git/");
                try {
                    String userInfo;
                    URL resolvedGitRepoUri = new URL(new URL(gitRepoUri), repoRelativePath);
                    String resolvedPath = "/" + branchName + path.substring(thirdSlashIndex);
                    Object host = URLUtil.encodeURIComponent((String)resolvedGitRepoUri.toExternalForm());
                    if (endsWithGit && !((String)host).endsWith(".git")) {
                        host = (String)host + ".git";
                    }
                    String authority = (userInfo = u.getUserInfo()) != null ? userInfo + "@" + (String)host : host;
                    this.setURL(u, u.getProtocol(), (String)host, u.getPort(), authority, userInfo, resolvedPath, u.getQuery(), u.getRef());
                }
                catch (MalformedURLException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private boolean specContainsDirTraversals(String spec) {
        return spec != null && (spec.contains("/../") || spec.startsWith("../") || spec.endsWith("/.."));
    }

    private String extractBranchName(String gitUrlPath) {
        if (gitUrlPath == null) {
            return null;
        }
        String[] split = gitUrlPath.split("/", 3);
        return split.length > 1 ? split[1] : null;
    }

    private int indexOfThirdSlash(String string) {
        int tempIndex = -1;
        int finalIndex = 0;
        for (int occurrence = 0; occurrence < 3 && (tempIndex = string.indexOf(47)) != -1; ++occurrence) {
            string = string.substring(++tempIndex);
            finalIndex += tempIndex;
        }
        --finalIndex;
        if (tempIndex != -1) {
            return finalIndex;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RepositoryLocation extractRepositoryLocation(URL url) {
        RepositoryLocation ret = null;
        if (!"github".equals(url.getProtocol())) return new RepositoryLocation(url);
        if ("getFileContent".equals(url.getHost())) {
            Matcher m = FILE_CONTENT_URL_PATTERN.matcher(url.toExternalForm());
            if (!m.find()) throw new RuntimeException("Invalid getFileContent URL");
            String owner = m.group(1);
            String repo = m.group(2);
            String repositoryUri = MessageFormat.format("https://github.com/{0}/{1}", owner, repo);
            String branch = URLUtil.decodeURIComponent((String)m.group(3));
            String path = URLUtil.decodeURIComponent((String)m.group(4));
            return new RepositoryLocation(repositoryUri, branch, path);
        }
        if (!"getFileList".equals(url.getHost())) return ret;
        Matcher m = FILE_LIST_URL_PATTERN.matcher(url.toExternalForm());
        if (!m.find()) throw new RuntimeException("Invalid getFileList URL");
        String repositoryUri = URLUtil.decodeURIComponent((String)m.group(1));
        String branch = URLUtil.decodeURIComponent((String)m.group(2));
        String path = URLUtil.decodeURIComponent((String)m.group(3));
        return new RepositoryLocation(repositoryUri, branch, path);
    }

    protected URLConnection openConnectionInContext(String contextId, URL url, Proxy proxy) throws IOException {
        GitProtocol gitProtocol = GitProtocol.valueOf(url);
        RepositoryLocation location = this.extractRepositoryLocation(url);
        if (gitProtocol == GitProtocol.GIT) {
            GitAccess gitAccess = WebAuthorGitApis.createGenericGitApi(contextId);
            return new GitUrlConnection(location, this.buildDummy(url), gitAccess);
        }
        if (this.isHybridStrategy(gitProtocol)) {
            UserPassEmailCredentialsProvider credentialsProvider = GitCredentialsProvider.getCredentials(contextId, this.getCredentialType(gitProtocol));
            Optional<InMemoryRepository> inMemoryRepositoryOpt = InMemoryRepositoryCacheInstaller.IN_MEMORY_REPOSITORY_CACHE.getOrCloneIfDocLoads(location, contextId, (CredentialsProvider)credentialsProvider);
            if (inMemoryRepositoryOpt.isPresent()) {
                InMemoryRepository inMemoryRepository = inMemoryRepositoryOpt.get();
                return new UrlConnectionOverGitRepository(url, inMemoryRepository, location);
            }
            return this.getRestApiUrlConnection(gitProtocol, contextId, url, location);
        }
        return this.getRestApiUrlConnection(gitProtocol, contextId, url, location);
    }

    private CredentialTypes getCredentialType(GitProtocol gitProtocol) {
        switch (gitProtocol) {
            case GITHUB: 
            case GITHUB1: {
                return CredentialTypes.GITHUB;
            }
            case BITBUCKET: {
                return CredentialTypes.BITBUCKET;
            }
            case BITBUCKET_SERVER: {
                return CredentialTypes.BITBUCKET_SERVER;
            }
            case GITLAB: {
                return CredentialTypes.GITLAB;
            }
            case GITLAB_ENTERPRISE: {
                return CredentialTypes.GITLAB_E;
            }
            case GIT: {
                return CredentialTypes.USERPASS;
            }
        }
        throw new UnsupportedOperationException();
    }

    private boolean isHybridStrategy(GitProtocol protocol) {
        switch (protocol) {
            case GITHUB: 
            case GITHUB1: {
                return GitCredentialsProvider.isGithubHybridRetrieveStrategy();
            }
            case BITBUCKET: {
                return GitCredentialsProvider.isBitbucketHybridRetrieveStrategy();
            }
            case BITBUCKET_SERVER: {
                return GitCredentialsProvider.isBitbucketServerHybridRetrieveStrategy();
            }
            case GITLAB: {
                return GitCredentialsProvider.isGitlabHybridRetrieveStrategy();
            }
            case GITLAB_ENTERPRISE: {
                return GitCredentialsProvider.isGitlabEnterpriseHybridRetrieveStrategy();
            }
        }
        return false;
    }

    private BaseUrlConnection getRestApiUrlConnection(GitProtocol protocol, String contextId, URL url, RepositoryLocation location) throws UserActionRequiredException {
        switch (protocol) {
            case GITHUB: 
            case GITHUB1: {
                return this.openGithubRestApiConnection(contextId, this.buildDummy(url), location);
            }
            case BITBUCKET: {
                return this.openBitbucketRestApiConnection(contextId, this.buildDummy(url), location);
            }
            case BITBUCKET_SERVER: {
                return this.openBitbucketServerRestApiConnection(contextId, this.buildDummy(url), location);
            }
            case GITLAB: {
                return this.openGitlabRestApiConnection(contextId, this.buildDummy(url), location);
            }
            case GITLAB_ENTERPRISE: {
                return this.openGitlabEnterpriseRestApiConnection(contextId, this.buildDummy(url), location);
            }
        }
        throw new IllegalArgumentException();
    }

    private URLConnection buildDummy(URL url) {
        URLConnection dummyConn = new URLConnection(url){

            @Override
            public void connect() throws IOException {
                this.connected = true;
            }
        };
        return dummyConn;
    }

    private GitlabUrlConnection openGitlabEnterpriseRestApiConnection(String contextId, URLConnection dummyConn, RepositoryLocation location) throws UserActionRequiredException {
        GitlabApi gitlabApi = WebAuthorGitApis.createGitlabApi(contextId, true);
        GitlabUrlConnection httpGitlabConnection = new GitlabUrlConnection(location, dummyConn, gitlabApi);
        return httpGitlabConnection;
    }

    private GitlabUrlConnection openGitlabRestApiConnection(String contextId, URLConnection dummyConn, RepositoryLocation location) throws UserActionRequiredException {
        GitlabApi gitlabApi = WebAuthorGitApis.createGitlabApi(contextId, false);
        GitlabUrlConnection httpGitlabConnection = new GitlabUrlConnection(location, dummyConn, gitlabApi);
        return httpGitlabConnection;
    }

    private BitbucketServerUrlConnection openBitbucketServerRestApiConnection(String contextId, URLConnection dummyConn, RepositoryLocation location) throws UserActionRequiredException {
        BitbucketServerApi bitbucketServerApi = WebAuthorGitApis.createBitbucketServerApi(contextId);
        BitbucketServerUrlConnection httpBitbucketServerConnection = new BitbucketServerUrlConnection(dummyConn, location, bitbucketServerApi);
        return httpBitbucketServerConnection;
    }

    private BitbucketUrlConnection openBitbucketRestApiConnection(String contextId, URLConnection dummyConn, RepositoryLocation location) throws UserActionRequiredException {
        BitbucketApi bitbucketApi = WebAuthorGitApis.createBitbucketApi(contextId);
        BitbucketUrlConnection httpBitbucketConnection = new BitbucketUrlConnection(dummyConn, location, bitbucketApi);
        return httpBitbucketConnection;
    }

    private GithubUrlConnection openGithubRestApiConnection(String contextId, URLConnection dummyConn, RepositoryLocation location) throws UserActionRequiredException {
        GitHubV3Api githubApi = WebAuthorGitApis.createGitHubApi(contextId);
        GithubUrlConnection httpGithubConnection = new GithubUrlConnection(location, dummyConn, githubApi);
        return httpGithubConnection;
    }

    public static enum GitProtocol {
        GITHUB("gitgh"),
        GITHUB1("github"),
        BITBUCKET("gitbb"),
        BITBUCKET_SERVER("gitbbsv"),
        GITLAB("gitgl"),
        GITLAB_ENTERPRISE("gitgle"),
        GIT("git");

        private final String protocol;

        private GitProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.protocol;
        }

        public static boolean canHandle(URL url) {
            String protocol = url.getProtocol();
            for (GitProtocol gitProtocol : GitProtocol.values()) {
                if (!gitProtocol.getProtocol().equals(protocol)) continue;
                return true;
            }
            return false;
        }

        public static GitProtocol valueOf(URL url) {
            String protocol = url.getProtocol();
            for (GitProtocol gitProtocol : GitProtocol.values()) {
                if (!gitProtocol.getProtocol().equals(protocol)) continue;
                return gitProtocol;
            }
            throw new IllegalArgumentException();
        }
    }
}

