/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.common.BaseUrlConnection;
import com.oxygenxml.examples.git.RESTGitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.github.apiclient.GitHubV3Api;
import com.oxygenxml.examples.github.apiclient.model.GitTreeLeaf;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class GithubUrlConnection
extends BaseUrlConnection {
    public static final String GIT_FILE_LIST_URL_HOST = "getFileList";
    private final RepositoryLocation repoLocation;
    private final GitHubV3Api gitHubV3Api;

    public GithubUrlConnection(RepositoryLocation repoLocation, URLConnection delegateConnection, GitHubV3Api githubApi) {
        super(delegateConnection);
        this.repoLocation = repoLocation;
        this.gitHubV3Api = githubApi;
    }

    public InputStream getInputStream() throws IOException {
        RepositoryLocation location = null;
        try {
            location = RESTGitAccess.submodulesResolver.resolveSubmodule(this.repoLocation, this.gitHubV3Api);
            return this.gitHubV3Api.read(location);
        }
        catch (NotAuthorizedException e) {
            throw GitUtil.getNotAuthorizedAndNeedLoginEx();
        }
        catch (NotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    RepositoryLocation location = RESTGitAccess.submodulesResolver.resolveSubmodule(GithubUrlConnection.this.repoLocation, GithubUrlConnection.this.gitHubV3Api);
                    GithubUrlConnection.this.gitHubV3Api.writeContents(location, this.toByteArray());
                }
                catch (NotAuthorizedException e) {
                    throw GitUtil.getNotAuthorizedAndNoLoginEx();
                }
                catch (IOException e) {
                    GithubUrlConnection.this.filterClientSecret(e);
                }
            }
        };
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        ArrayList<FolderEntryDescriptor> filesList;
        block5: {
            filesList = null;
            RepositoryLocation location = null;
            try {
                location = RESTGitAccess.submodulesResolver.resolveSubmodule(this.repoLocation, this.gitHubV3Api);
                GitTreeLeaf[] fileLeafs = this.gitHubV3Api.listFiles(location);
                filesList = new ArrayList(fileLeafs.length);
                for (GitTreeLeaf fileLeaf : fileLeafs) {
                    String dirChar = "";
                    if (fileLeaf.getType().equals("dir") || fileLeaf.getType().equals("tree")) {
                        dirChar = "/";
                    }
                    filesList.add(new FolderEntryDescriptor(GitUtil.encodePath(fileLeaf.getPath() + dirChar)));
                }
            }
            catch (NotAuthorizedException e) {
                throw GitUtil.getNotAuthorizedAndNeedLoginEx();
            }
            catch (NotFoundException e) {
                if (location == null || this.gitHubV3Api.haveRepositoryAccess(location)) break block5;
                throw GitUtil.getNotAuthorizedAndNeedLoginEx();
            }
        }
        return filesList == null ? new ArrayList<FolderEntryDescriptor>() : filesList;
    }

    private void filterClientSecret(Exception e) {
        String message = e.getMessage();
        int indexOfClientSecret = message.indexOf("client_secret");
        if (indexOfClientSecret != -1) {
            throw new UnexpectedException(message.substring(0, indexOfClientSecret));
        }
        throw new UnexpectedException(e.getMessage(), e);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

