/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.bitbucketserver.oauth.RsaKeysGenerator;
import com.oxygenxml.examples.github.GitHubOAuthService;
import com.oxygenxml.examples.github.GitHubPlugin;
import com.oxygenxml.examples.gitlab.GitlabCloudOAuthService;
import com.oxygenxml.examples.gitlab.GitlabEnterpriseOAuthService;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import ro.sync.ecss.extensions.api.webapp.access.InternalWebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginConfigExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.ServletException;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletResponse;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationManager;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationProvider;
import ro.sync.exml.plugin.PluginContext;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class GithubPluginConfigExtension
extends ServletPluginConfigExtension {
    private static final String GIT_GENERIC_DISABLED = "git.generic_disabled";
    private static final String GIT_RESOLVE_SUBMODULES = "git.resolveSubmodules";
    private static final String GIT_SHOW_SIGN_OFF_TRAILER = "git.showSignOffTrailer";
    static final String GITHUB_CLIENT_ID = "github.client_id";
    static final String GITHUB_CLIENT_SECRET = "github.client_secret";
    static final String BITBUCKET_CLIENT_ID = "bitbucket.client_id";
    static final String BITBUCKET_CLIENT_SECRET = "bitbucket.client_secret";
    private static final String BITBUCKET_RETRIEVE_STRATEGY = "bitbucket.retrieveStrategy";
    static final String BITBUCKET_SERVER_CONSUMER_KEY = "bitbucketserver.consumer_key";
    static final String BITBUCKET_SERVER_PRIVATE_KEY = "bitbucketserver.private_key";
    static final String BITBUCKET_SERVER_PUBLIC_KEY = "bitbucketserver.public_key";
    static final String BITBUCKET_SERVER_API_URL = "bitbucketserver.api_url";
    private static final String BITBUCKET_SERVER_RETRIEVE_STRATEGY = "bitbucketserver.retrieveStrategy";
    static final String GITLAB_CLIENT_ID = "gitlab.client_id";
    static final String GITLAB_CLIENT_SECRET = "gitlab.client_secret";
    static final String GITLAB_REDIRECT_URL = "gitlab.redirect_url";
    private static final String GITLAB_RETRIEVE_STRATEGY = "gitlab.retrieveStrategy";
    static final String GITLAB_E_CLIENT_ID = "gitlab-e.client_id";
    static final String GITLAB_E_CLIENT_SECRET = "gitlab-e.client_secret";
    static final String GITLAB_E_API_URL = "gitlab-e.api_url";
    static final String GITLAB_E_REDIRECT_URL = "gitlab-e.redirect_url";
    static final String GITLAB_E_VERSION = "gitlab-e.version";
    private static final String GITLAB_ENTERPRISE_RETRIEVE_STRATEGY = "gitlab-e.retrieveStrategy";
    private static final String USING_ENFORCED_CREDS = "git.usingEnforcedCredentials";
    static final String GITHUB_API_URL = "github.api_url";
    private static final String GITHUB_RETRIEVE_STRATEGY = "github.retrieveStrategy";
    private static final String GIT_ENABLE_NEW_BRANCH = "git.enableNewBranch";
    static final String DEFAULT_GITHUB_API_URL = null;
    public static final String RETRIEVE_STRATEGY_REST_API = "rest-api";
    public static final String RETRIEVE_STRATEGY_HYBRID = "hybrid";
    private static final String RETRIEVE_STRATEGY_DEFAULT = "rest-api";
    private static final String DEFAULT_JGIT_REPOSITORIES = "git.default.jgit.repos";
    public static final Set<String> SECRET_OPTIONS = Set.of("github.client_id", "github.client_secret", "github.api_url", "gitlab.client_id", "gitlab.client_secret", "gitlab.redirect_url", "gitlab-e.client_id", "gitlab-e.client_secret", "gitlab-e.redirect_url", "gitlab-e.api_url", "bitbucket.client_id", "bitbucket.client_secret", "bitbucketserver.consumer_key", "bitbucketserver.private_key", "bitbucketserver.public_key", "bitbucketserver.api_url");
    @PluginContext
    private GitHubOAuthService gitHubOAuthService;
    @PluginContext
    private GitlabCloudOAuthService gitLabOAuthService;
    @PluginContext
    private GitlabEnterpriseOAuthService gitLabEnterpriseOAuthService;

    public void init() throws ServletException {
        super.init();
        HashMap<String, String> defaultOptions = new HashMap<String, String>();
        defaultOptions.put(GIT_GENERIC_DISABLED, null);
        defaultOptions.put(GIT_RESOLVE_SUBMODULES, "on");
        defaultOptions.put(GIT_SHOW_SIGN_OFF_TRAILER, null);
        defaultOptions.put(GITHUB_CLIENT_ID, null);
        defaultOptions.put(GITHUB_CLIENT_SECRET, null);
        defaultOptions.put(GITHUB_API_URL, DEFAULT_GITHUB_API_URL);
        defaultOptions.put(GITHUB_RETRIEVE_STRATEGY, "rest-api");
        defaultOptions.put(BITBUCKET_CLIENT_ID, null);
        defaultOptions.put(BITBUCKET_CLIENT_SECRET, null);
        defaultOptions.put(BITBUCKET_SERVER_CONSUMER_KEY, null);
        defaultOptions.put(BITBUCKET_SERVER_PRIVATE_KEY, null);
        defaultOptions.put(BITBUCKET_SERVER_PUBLIC_KEY, null);
        defaultOptions.put(BITBUCKET_SERVER_API_URL, null);
        defaultOptions.put(GITLAB_CLIENT_ID, null);
        defaultOptions.put(GITLAB_CLIENT_SECRET, null);
        defaultOptions.put(GITLAB_REDIRECT_URL, null);
        defaultOptions.put(GITLAB_E_CLIENT_ID, null);
        defaultOptions.put(GITLAB_E_CLIENT_SECRET, null);
        defaultOptions.put(GITLAB_E_API_URL, null);
        defaultOptions.put(GITLAB_E_REDIRECT_URL, null);
        defaultOptions.put(GITLAB_E_VERSION, null);
        defaultOptions.put(GIT_ENABLE_NEW_BRANCH, "on");
        defaultOptions.put(DEFAULT_JGIT_REPOSITORIES, "");
        this.setDefaultOptions(defaultOptions);
        GitCredentialsProvider.setGitGenericDisabled(this.getOption(GIT_GENERIC_DISABLED, null));
        GitCredentialsProvider.setGitResolveSubmodules(this.getOption(GIT_RESOLVE_SUBMODULES, "on"));
        GitCredentialsProvider.setGitHubClientId(this.getOption(GITHUB_CLIENT_ID, null));
        GitCredentialsProvider.setGitHubClientSecret(this.getOption(GITHUB_CLIENT_SECRET, null));
        GitCredentialsProvider.setGitHubApiUrl(this.getOption(GITHUB_API_URL, DEFAULT_GITHUB_API_URL));
        GitCredentialsProvider.setGithubRetrieveStrategy(this.getOption(GITHUB_RETRIEVE_STRATEGY, "rest-api"));
        GitCredentialsProvider.setBitbucketClientId(this.getOption(BITBUCKET_CLIENT_ID, null));
        GitCredentialsProvider.setBitbucketClientSecret(this.getOption(BITBUCKET_CLIENT_SECRET, null));
        GitCredentialsProvider.setBitbucketRetrieveStrategy(this.getOption(BITBUCKET_RETRIEVE_STRATEGY, "rest-api"));
        GitCredentialsProvider.setBitbucketServerConsumerKey(this.getOption(BITBUCKET_SERVER_CONSUMER_KEY, null));
        GitCredentialsProvider.setBitbucketServerPrivateKey(this.getOption(BITBUCKET_SERVER_PRIVATE_KEY, null));
        GitCredentialsProvider.setBitbucketServerPublicKey(this.getOption(BITBUCKET_SERVER_PUBLIC_KEY, null));
        GitCredentialsProvider.setBitbucketServerUrl(this.getOption(BITBUCKET_SERVER_API_URL, null));
        GitCredentialsProvider.setBitbucketServerRetrieveStrategy(this.getOption(BITBUCKET_SERVER_RETRIEVE_STRATEGY, "rest-api"));
        GitCredentialsProvider.setGitlabClientId(this.getOption(GITLAB_CLIENT_ID, null));
        GitCredentialsProvider.setGitlabClientSecret(this.getOption(GITLAB_CLIENT_SECRET, null));
        GitCredentialsProvider.setGitlabRedirectUri(this.getOption(GITLAB_REDIRECT_URL, null));
        GitCredentialsProvider.setGitlabRetrieveStrategy(this.getOption(GITLAB_RETRIEVE_STRATEGY, "rest-api"));
        GitCredentialsProvider.setGitlabEnterpriseClientId(this.getOption(GITLAB_E_CLIENT_ID, null));
        GitCredentialsProvider.setGitlabEnterpriseClientSecret(this.getOption(GITLAB_E_CLIENT_SECRET, null));
        GitCredentialsProvider.setGitlabEnterpriseApiUrl(this.getOption(GITLAB_E_API_URL, null));
        GitCredentialsProvider.setGitlabEnterpriseRedirectUri(this.getOption(GITLAB_E_REDIRECT_URL, null));
        GitCredentialsProvider.setGitlabEnterpiseVersion(this.getOption(GITLAB_E_VERSION, null));
        GitCredentialsProvider.setGitlabEnterpriseRetrieveStrategy(this.getOption(GITLAB_ENTERPRISE_RETRIEVE_STRATEGY, "rest-api"));
        try {
            this.saveOptions();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        InternalWebappPluginWorkspace pluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ApplicationAuthenticationManager authenticationManager = pluginWorkspace.getApplicationAuthenticationManager();
        if (GithubPluginConfigExtension.isGithubConfigurated()) {
            ApplicationAuthenticationProvider githubAuthenticationProvider = this.gitHubOAuthService.getGithubAuthenticationProvider();
            authenticationManager.addApplicationAuthenticationProvider(githubAuthenticationProvider);
        }
        if (GithubPluginConfigExtension.isGitlabConfigurated()) {
            ApplicationAuthenticationProvider gitLabAuthenticationProvider = this.gitLabOAuthService.getAuthenticationProvider();
            authenticationManager.addApplicationAuthenticationProvider(gitLabAuthenticationProvider);
        }
        if (GithubPluginConfigExtension.isGitlabEnterpriseConfigurated()) {
            ApplicationAuthenticationProvider gitLabEnterpriseAuthenticationProvider = this.gitLabEnterpriseOAuthService.getAuthenticationProvider();
            authenticationManager.addApplicationAuthenticationProvider(gitLabEnterpriseAuthenticationProvider);
        }
    }

    public String getPath() {
        return "github-config";
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
        GitCredentialsProvider.invalidateAll();
        this.refreshGitHubAuthProvider();
        this.refreshGitLabEnterpriseAuthProvider();
        this.refreshGitLabAuthProvider();
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
        GitCredentialsProvider.setGitGenericDisabled((String)this.getDefaultOptions().get(GIT_GENERIC_DISABLED));
        GitCredentialsProvider.setGitHubClientId((String)this.getDefaultOptions().get(GITHUB_CLIENT_ID));
        GitCredentialsProvider.setGitHubClientSecret((String)this.getDefaultOptions().get(GITHUB_CLIENT_SECRET));
        GitCredentialsProvider.setGitHubApiUrl((String)this.getDefaultOptions().get(GITHUB_API_URL));
        GitCredentialsProvider.setGithubRetrieveStrategy((String)this.getDefaultOptions().get(GITHUB_RETRIEVE_STRATEGY));
        GitCredentialsProvider.setBitbucketClientId((String)this.getDefaultOptions().get(BITBUCKET_CLIENT_ID));
        GitCredentialsProvider.setBitbucketClientSecret((String)this.getDefaultOptions().get(BITBUCKET_CLIENT_SECRET));
        GitCredentialsProvider.setBitbucketRetrieveStrategy((String)this.getDefaultOptions().get(BITBUCKET_RETRIEVE_STRATEGY));
        GitCredentialsProvider.setBitbucketServerConsumerKey((String)this.getDefaultOptions().get(BITBUCKET_SERVER_CONSUMER_KEY));
        GitCredentialsProvider.setBitbucketServerPrivateKey((String)this.getDefaultOptions().get(BITBUCKET_SERVER_PRIVATE_KEY));
        GitCredentialsProvider.setBitbucketServerPublicKey((String)this.getDefaultOptions().get(BITBUCKET_SERVER_PUBLIC_KEY));
        GitCredentialsProvider.setBitbucketServerUrl((String)this.getDefaultOptions().get(BITBUCKET_SERVER_API_URL));
        GitCredentialsProvider.setBitbucketServerRetrieveStrategy((String)this.getDefaultOptions().get(BITBUCKET_SERVER_RETRIEVE_STRATEGY));
        GitCredentialsProvider.setGitlabClientId((String)this.getDefaultOptions().get(GITLAB_CLIENT_ID));
        GitCredentialsProvider.setGitlabClientSecret((String)this.getDefaultOptions().get(GITLAB_CLIENT_SECRET));
        GitCredentialsProvider.setGitlabRedirectUri((String)this.getDefaultOptions().get(GITLAB_REDIRECT_URL));
        GitCredentialsProvider.setGitlabRetrieveStrategy((String)this.getDefaultOptions().get(GITLAB_RETRIEVE_STRATEGY));
        GitCredentialsProvider.setGitlabEnterpriseClientId((String)this.getDefaultOptions().get(GITLAB_E_CLIENT_ID));
        GitCredentialsProvider.setGitlabEnterpriseClientSecret((String)this.getDefaultOptions().get(GITLAB_E_CLIENT_SECRET));
        GitCredentialsProvider.setGitlabEnterpriseApiUrl((String)this.getDefaultOptions().get(GITLAB_E_API_URL));
        GitCredentialsProvider.setGitlabEnterpriseRedirectUri((String)this.getDefaultOptions().get(GITLAB_E_REDIRECT_URL));
        GitCredentialsProvider.setGitlabEnterpiseVersion((String)this.getDefaultOptions().get(GITLAB_E_VERSION));
        GitCredentialsProvider.setGitlabEnterpriseRetrieveStrategy((String)this.getDefaultOptions().get(GITLAB_ENTERPRISE_RETRIEVE_STRATEGY));
        GitCredentialsProvider.invalidateAll();
    }

    protected void setOption(String key, String value) {
        if ("".equals(value)) {
            value = null;
        }
        if (GIT_GENERIC_DISABLED.equals(key)) {
            GitCredentialsProvider.setGitGenericDisabled(value);
        }
        if (GIT_RESOLVE_SUBMODULES.equals(key)) {
            GitCredentialsProvider.setGitResolveSubmodules(value);
        }
        if (GITHUB_CLIENT_ID.equals(key)) {
            GitCredentialsProvider.setGitHubClientId(value);
            this.refreshGitHubAuthProvider();
        }
        if (GITHUB_CLIENT_SECRET.equals(key)) {
            GitCredentialsProvider.setGitHubClientSecret(value);
            this.refreshGitHubAuthProvider();
        }
        if (GITHUB_API_URL.equals(key)) {
            if (value != null && value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
            if ("https://api.github.com".equals(value)) {
                value = null;
            }
            GitCredentialsProvider.setGitHubApiUrl(value);
        }
        if (GITHUB_RETRIEVE_STRATEGY.equals(key)) {
            GitCredentialsProvider.setGithubRetrieveStrategy(value);
        }
        if (BITBUCKET_CLIENT_ID.equals(key)) {
            GitCredentialsProvider.setBitbucketClientId(value);
        }
        if (BITBUCKET_CLIENT_SECRET.equals(key)) {
            GitCredentialsProvider.setBitbucketClientSecret(value);
        }
        if (BITBUCKET_RETRIEVE_STRATEGY.equals(key)) {
            GitCredentialsProvider.setBitbucketRetrieveStrategy(value);
        }
        if (BITBUCKET_SERVER_CONSUMER_KEY.equals(key)) {
            GitCredentialsProvider.setBitbucketServerConsumerKey(value);
        }
        if (BITBUCKET_SERVER_PRIVATE_KEY.equals(key)) {
            GitCredentialsProvider.setBitbucketServerPrivateKey(value);
        }
        if (BITBUCKET_SERVER_PUBLIC_KEY.equals(key)) {
            GitCredentialsProvider.setBitbucketServerPublicKey(value);
        }
        if (BITBUCKET_SERVER_API_URL.equals(key)) {
            GitCredentialsProvider.setBitbucketServerUrl(value);
        }
        if (BITBUCKET_SERVER_RETRIEVE_STRATEGY.equals(key)) {
            GitCredentialsProvider.setBitbucketServerRetrieveStrategy(value);
        }
        if (GITLAB_CLIENT_ID.equals(key)) {
            GitCredentialsProvider.setGitlabClientId(value);
            this.refreshGitLabAuthProvider();
        }
        if (GITLAB_CLIENT_SECRET.equals(key)) {
            GitCredentialsProvider.setGitlabClientSecret(value);
            this.refreshGitLabAuthProvider();
        }
        if (GITLAB_REDIRECT_URL.equals(key)) {
            GitCredentialsProvider.setGitlabRedirectUri(value);
            this.refreshGitLabAuthProvider();
        }
        if (GITLAB_RETRIEVE_STRATEGY.equals(key)) {
            GitCredentialsProvider.setGitlabRetrieveStrategy(value);
        }
        if (GITLAB_E_CLIENT_ID.equals(key)) {
            GitCredentialsProvider.setGitlabEnterpriseClientId(value);
            this.refreshGitLabEnterpriseAuthProvider();
        }
        if (GITLAB_E_CLIENT_SECRET.equals(key)) {
            GitCredentialsProvider.setGitlabEnterpriseClientSecret(value);
            this.refreshGitLabEnterpriseAuthProvider();
        }
        if (GITLAB_E_API_URL.equals(key)) {
            GitCredentialsProvider.setGitlabEnterpriseApiUrl(value);
            this.refreshGitLabEnterpriseAuthProvider();
        }
        if (GITLAB_E_REDIRECT_URL.equals(key)) {
            GitCredentialsProvider.setGitlabEnterpriseRedirectUri(value);
            this.refreshGitLabEnterpriseAuthProvider();
        }
        if (GITLAB_E_VERSION.equals(key)) {
            GitCredentialsProvider.setGitlabEnterpiseVersion(value);
            this.refreshGitLabEnterpriseAuthProvider();
        }
        if (GITLAB_ENTERPRISE_RETRIEVE_STRATEGY.equals(key)) {
            GitCredentialsProvider.setGitlabEnterpriseRetrieveStrategy(value);
        }
        if (SECRET_OPTIONS.contains(key)) {
            this.setSecretOption(key, value);
        } else {
            super.setOption(key, value);
        }
    }

    protected String getOption(String key, String defaultValue) {
        if (SECRET_OPTIONS.contains(key)) {
            return this.getOrMigrateSecretOption(key, defaultValue);
        }
        return super.getOption(key, defaultValue);
    }

    private void refreshGitLabEnterpriseAuthProvider() {
        InternalWebappPluginWorkspace pluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ApplicationAuthenticationManager authenticationManager = pluginWorkspace.getApplicationAuthenticationManager();
        ApplicationAuthenticationProvider authenticationProvider = this.gitLabEnterpriseOAuthService.getAuthenticationProvider();
        if (GithubPluginConfigExtension.isGitlabEnterpriseConfigurated()) {
            authenticationManager.removeApplicationAuthenticationProvider(authenticationProvider);
            authenticationManager.addApplicationAuthenticationProvider(authenticationProvider);
        } else {
            authenticationManager.removeApplicationAuthenticationProvider(authenticationProvider);
        }
    }

    private void refreshGitLabAuthProvider() {
        InternalWebappPluginWorkspace pluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ApplicationAuthenticationManager authenticationManager = pluginWorkspace.getApplicationAuthenticationManager();
        ApplicationAuthenticationProvider authenticationProvider = this.gitLabOAuthService.getAuthenticationProvider();
        if (GithubPluginConfigExtension.isGitlabConfigurated()) {
            authenticationManager.removeApplicationAuthenticationProvider(authenticationProvider);
            authenticationManager.addApplicationAuthenticationProvider(authenticationProvider);
        } else {
            authenticationManager.removeApplicationAuthenticationProvider(authenticationProvider);
        }
    }

    private void refreshGitHubAuthProvider() {
        InternalWebappPluginWorkspace pluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ApplicationAuthenticationManager authenticationManager = pluginWorkspace.getApplicationAuthenticationManager();
        ApplicationAuthenticationProvider githubAuthenticationProvider = this.gitHubOAuthService.getGithubAuthenticationProvider();
        if (GithubPluginConfigExtension.isGithubConfigurated()) {
            authenticationManager.removeApplicationAuthenticationProvider(githubAuthenticationProvider);
            authenticationManager.addApplicationAuthenticationProvider(githubAuthenticationProvider);
        } else {
            authenticationManager.removeApplicationAuthenticationProvider(githubAuthenticationProvider);
        }
    }

    public String getOptionsForm() {
        String gitlabEnterpiseVersion;
        String gitlabEnterpriseRedirectUri;
        String gitlabEnterpriseApiUrl;
        String gitlabEnterpriseClientSecret;
        String gitlabEnterpriseClientId;
        String gitlabRedirectUrl;
        String gitlabClientSecret;
        String gitlabClientId;
        String bitbucketServerUrl;
        String bitbucketServerConsumerKey;
        String bitbucketClientSecret;
        String bitbucketClientId;
        String githubApiUrl;
        String githubClientSecret;
        String githubClientId;
        String gitShowSignOffTrailer;
        String gitGenericDisabled = GitCredentialsProvider.isGitGenericDisabled();
        if (gitGenericDisabled == null) {
            gitGenericDisabled = "";
        }
        String gitEnableNewBranch = this.getOption(GIT_ENABLE_NEW_BRANCH, "on");
        String gitResolveSubmodules = GitCredentialsProvider.isGitResolveSubmodules();
        if (gitResolveSubmodules == null) {
            gitResolveSubmodules = "";
        }
        if ((gitShowSignOffTrailer = this.getOption(GIT_SHOW_SIGN_OFF_TRAILER, null)) == null) {
            gitShowSignOffTrailer = "";
        }
        if ((githubClientId = GitCredentialsProvider.getGitHubClientId()) == null) {
            githubClientId = "";
        }
        if ((githubClientSecret = GitCredentialsProvider.getGitHubClientSecret()) == null) {
            githubClientSecret = "";
        }
        if ((githubApiUrl = GitCredentialsProvider.getGitHubApiUrl()) == null) {
            githubApiUrl = "";
        }
        if ((bitbucketClientId = GitCredentialsProvider.getBitbucketClientId()) == null) {
            bitbucketClientId = "";
        }
        if ((bitbucketClientSecret = GitCredentialsProvider.getBitbucketClientSecret()) == null) {
            bitbucketClientSecret = "";
        }
        if ((bitbucketServerConsumerKey = GitCredentialsProvider.getBitbucketServerConsumerKey()) == null) {
            bitbucketServerConsumerKey = "";
        }
        String bitbucketServerPrivateKey = GitCredentialsProvider.getBitbucketServerPrivateKey();
        String bitbucketServerPublicKey = GitCredentialsProvider.getBitbucketServerPublicKey();
        if (bitbucketServerPrivateKey == null && bitbucketServerPublicKey == null) {
            Base64.Encoder encoder = Base64.getEncoder();
            KeyPair rsaKeys = RsaKeysGenerator.generateRsaKeys();
            bitbucketServerPrivateKey = encoder.encodeToString(rsaKeys.getPrivate().getEncoded());
            bitbucketServerPublicKey = encoder.encodeToString(rsaKeys.getPublic().getEncoded());
        }
        if ((bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl()) == null) {
            bitbucketServerUrl = "";
        }
        if ((gitlabClientId = GitCredentialsProvider.getGitlabClientId()) == null) {
            gitlabClientId = "";
        }
        if ((gitlabClientSecret = GitCredentialsProvider.getGitlabClientSecret()) == null) {
            gitlabClientSecret = "";
        }
        if ((gitlabRedirectUrl = GitCredentialsProvider.getGitlabRedirectUri()) == null) {
            gitlabRedirectUrl = "";
        }
        if ((gitlabEnterpriseClientId = GitCredentialsProvider.getGitlabEnterpriseClientId()) == null) {
            gitlabEnterpriseClientId = "";
        }
        if ((gitlabEnterpriseClientSecret = GitCredentialsProvider.getGitlabEnterpriseClientSecret()) == null) {
            gitlabEnterpriseClientSecret = "";
        }
        if ((gitlabEnterpriseApiUrl = GitCredentialsProvider.getGitlabEnterpriseApiUrl()) == null) {
            gitlabEnterpriseApiUrl = "";
        }
        if ((gitlabEnterpriseRedirectUri = GitCredentialsProvider.getGitlabEnterpriseRedirectUri()) == null) {
            gitlabEnterpriseRedirectUri = "";
        }
        if ((gitlabEnterpiseVersion = GitCredentialsProvider.getGitlabEnterpiseVersion()) == null) {
            gitlabEnterpiseVersion = "";
        }
        String defaultJGitRepositories = this.getOption(DEFAULT_JGIT_REPOSITORIES, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("gitGenericDisabled", gitGenericDisabled.equals("on"));
        context.put("GIT_GENERIC_DISABLED", GIT_GENERIC_DISABLED);
        context.put("gitEnableNewBranch", gitEnableNewBranch.equals("on"));
        context.put("GIT_ENABLE_NEW_BRANCH", GIT_ENABLE_NEW_BRANCH);
        context.put("gitResolveSubmodules", gitResolveSubmodules.equals("on"));
        context.put("GIT_RESOLVE_SUBMODULES", GIT_RESOLVE_SUBMODULES);
        context.put("gitShowSignOffTrailer", gitShowSignOffTrailer.equals("on"));
        context.put("GIT_SHOW_SIGN_OFF_TRAILER", GIT_SHOW_SIGN_OFF_TRAILER);
        context.put("useGitHubEnterprise", !githubApiUrl.isEmpty());
        context.put("GITHUB_API_URL", GITHUB_API_URL);
        context.put("githubApiUrl", githubApiUrl);
        context.put("RETRIEVE_STRATEGY_REST_API", "rest-api");
        context.put("RETRIEVE_STRATEGY_HYBRID", RETRIEVE_STRATEGY_HYBRID);
        context.put("GITHUB_RETRIEVE_STRATEGY", GITHUB_RETRIEVE_STRATEGY);
        context.put("githubRetrieveStrategyValue", GitCredentialsProvider.getGithubRetrieveStrategy());
        context.put("GITHUB_CLIENT_ID", GITHUB_CLIENT_ID);
        context.put("githubClientId", githubClientId);
        context.put("GITHUB_CLIENT_SECRET", GITHUB_CLIENT_SECRET);
        context.put("githubClientSecret", githubClientSecret);
        context.put("BITBUCKET_CLIENT_ID", BITBUCKET_CLIENT_ID);
        context.put("bitbucketClientId", bitbucketClientId);
        context.put("BITBUCKET_CLIENT_SECRET", BITBUCKET_CLIENT_SECRET);
        context.put("bitbucketClientSecret", bitbucketClientSecret);
        context.put("BITBUCKET_RETRIEVE_STRATEGY", BITBUCKET_RETRIEVE_STRATEGY);
        context.put("bitbucketRetrieveStrategyValue", GitCredentialsProvider.getBitbucketRetrieveStrategy());
        context.put("BITBUCKET_SERVER_CONSUMER_KEY", BITBUCKET_SERVER_CONSUMER_KEY);
        context.put("bitbucketServerConsumerKey", bitbucketServerConsumerKey);
        context.put("BITBUCKET_SERVER_PRIVATE_KEY", BITBUCKET_SERVER_PRIVATE_KEY);
        context.put("bitbucketServerPrivateKey", bitbucketServerPrivateKey);
        context.put("BITBUCKET_SERVER_PUBLIC_KEY", BITBUCKET_SERVER_PUBLIC_KEY);
        context.put("bitbucketServerPublicKey", bitbucketServerPublicKey);
        context.put("BITBUCKET_SERVER_API_URL", BITBUCKET_SERVER_API_URL);
        context.put("bitbucketServerUrl", bitbucketServerUrl);
        context.put("BITBUCKET_SERVER_RETRIEVE_STRATEGY", BITBUCKET_SERVER_RETRIEVE_STRATEGY);
        context.put("bitbucketServerRetrieveStrategyValue", GitCredentialsProvider.getBitbucketServerRetrieveStrategy());
        context.put("GITLAB_CLIENT_ID", GITLAB_CLIENT_ID);
        context.put("gitlabClientId", gitlabClientId);
        context.put("GITLAB_CLIENT_SECRET", GITLAB_CLIENT_SECRET);
        context.put("gitlabClientSecret", gitlabClientSecret);
        context.put("GITLAB_REDIRECT_URL", GITLAB_REDIRECT_URL);
        context.put("gitlabRedirectUrl", gitlabRedirectUrl);
        context.put("GITLAB_RETRIEVE_STRATEGY", GITLAB_RETRIEVE_STRATEGY);
        context.put("gitlabRetrieveStrategyValue", GitCredentialsProvider.getGitlabRetrieveStrategy());
        context.put("GITLAB_E_CLIENT_ID", GITLAB_E_CLIENT_ID);
        context.put("gitlabEnterpriseClientId", gitlabEnterpriseClientId);
        context.put("GITLAB_E_CLIENT_SECRET", GITLAB_E_CLIENT_SECRET);
        context.put("gitlabEnterpriseClientSecret", gitlabEnterpriseClientSecret);
        context.put("GITLAB_E_REDIRECT_URL", GITLAB_E_REDIRECT_URL);
        context.put("gitlabEnterpriseRedirectUri", gitlabEnterpriseRedirectUri);
        context.put("GITLAB_E_API_URL", GITLAB_E_API_URL);
        context.put("gitlabEnterpriseApiUrl", gitlabEnterpriseApiUrl);
        context.put("GITLAB_E_VERSION", GITLAB_E_VERSION);
        context.put("gitlabEnterpiseVersion", gitlabEnterpiseVersion);
        context.put("GITLAB_E_RETRIEVE_STRATEGY", GITLAB_ENTERPRISE_RETRIEVE_STRATEGY);
        context.put("gitlabEnterpriseRetrieveStrategyValue", GitCredentialsProvider.getGitlabEnterpriseRetrieveStrategy());
        context.put("DEFAULT_JGIT_REPOSITORIES", DEFAULT_JGIT_REPOSITORIES);
        context.put("defaultJGitRepositories", defaultJGitRepositories);
        return this.getConfigurationForm(context);
    }

    public String getOptionsJson() {
        String gitEnableNewBranch;
        String gitGenericDisabled;
        String gitlabEnterpiseVersion;
        boolean isGhCfgd = GithubPluginConfigExtension.isGithubConfigurated();
        String githubApiUrl = GitCredentialsProvider.getGitHubApiUrl();
        if (githubApiUrl == null) {
            githubApiUrl = "";
        }
        boolean isBbCfgd = GithubPluginConfigExtension.isBitbucketConfigurated();
        boolean isBbsvCfgd = GithubPluginConfigExtension.isBitbucketServerConfigured();
        boolean isGlCfgd = GithubPluginConfigExtension.isGitlabConfigurated();
        String gitlabEnterpriseApiUrl = GitCredentialsProvider.getGitlabEnterpriseApiUrl();
        boolean isGleCfgd = GithubPluginConfigExtension.isGitlabEnterpriseConfigurated();
        if (gitlabEnterpriseApiUrl == null) {
            gitlabEnterpriseApiUrl = "";
        }
        if ((gitlabEnterpiseVersion = GitCredentialsProvider.getGitlabEnterpiseVersion()) == null) {
            gitlabEnterpiseVersion = "";
        }
        if ((gitGenericDisabled = GitCredentialsProvider.isGitGenericDisabled()) == null) {
            gitGenericDisabled = "";
        }
        if ((gitEnableNewBranch = this.getOption(GIT_ENABLE_NEW_BRANCH, "on")) == null) {
            gitEnableNewBranch = "";
        }
        boolean usingEnforcedCredentials = GitCredentialsProvider.isUsingEnforcedCredentials();
        String resolveSubmodules = GitCredentialsProvider.isGitResolveSubmodules();
        String gitShowSignOffTrailer = this.getOption(GIT_SHOW_SIGN_OFF_TRAILER, null);
        if (gitShowSignOffTrailer == null) {
            gitShowSignOffTrailer = "";
        }
        String defaultJGitRepositories = this.getOption(DEFAULT_JGIT_REPOSITORIES, "");
        return "{\"git.generic_disabled\":\"" + gitGenericDisabled + "\",\"git.enableNewBranch\":\"" + gitEnableNewBranch + "\",\"git.resolveSubmodules\":\"" + resolveSubmodules + "\",\"git.showSignOffTrailer\":\"" + gitShowSignOffTrailer + "\",\"gh.properly\":" + isGhCfgd + ",\"github.api_url\":\"" + githubApiUrl + "\",\"github.client_id\":\"" + GitCredentialsProvider.getGitHubClientId() + "\",\"bb.properly\":" + isBbCfgd + ",\"bbsv.properly\":" + isBbsvCfgd + ",\"gl.properly\":" + isGlCfgd + ",\"gle.properly\":" + isGleCfgd + ",\"gitlab-e.api_url\":\"" + gitlabEnterpriseApiUrl + "\",\"gitlab-e.version\":\"" + gitlabEnterpiseVersion + "\",\"git.usingEnforcedCredentials\":\"" + usingEnforcedCredentials + "\",\"git.default.jgit.repos\":\"" + defaultJGitRepositories.replaceAll("\n", "\\\\n") + "\"}";
    }

    static boolean isGitlabEnterpriseConfigurated() {
        return GitCredentialsProvider.getGitlabEnterpriseClientId() != null && GitCredentialsProvider.getGitlabEnterpriseClientSecret() != null && GitCredentialsProvider.getGitlabEnterpriseRedirectUri() != null && GitCredentialsProvider.getGitlabEnterpriseApiUrl() != null;
    }

    static boolean isGitlabConfigurated() {
        return GitCredentialsProvider.getGitlabClientId() != null && GitCredentialsProvider.getGitlabClientSecret() != null && GitCredentialsProvider.getGitlabRedirectUri() != null;
    }

    static boolean isBitbucketConfigurated() {
        return GitCredentialsProvider.getBitbucketClientId() != null && GitCredentialsProvider.getBitbucketClientSecret() != null;
    }

    static boolean isBitbucketServerConfigured() {
        return GitCredentialsProvider.getBitbucketServerConsumerKey() != null && GitCredentialsProvider.getBitbucketServerPrivateKey() != null && GitCredentialsProvider.getBitbucketServerPublicKey() != null && GitCredentialsProvider.getBitbucketServerUrl() != null;
    }

    static boolean isGithubConfigurated() {
        return GitCredentialsProvider.getGitHubClientId() != null && GitCredentialsProvider.getGitHubClientSecret() != null;
    }

    private String getConfigurationForm(Map<String, Object> contextMap) {
        Object templatesDir = GitHubPlugin.getBaseDir().getAbsolutePath();
        if (!((String)templatesDir).endsWith("/")) {
            templatesDir = (String)templatesDir + "/";
        }
        TemplateEngine htmlTplEngine = new TemplateEngine();
        FileTemplateResolver htmlTplResplver = new FileTemplateResolver();
        htmlTplResplver.setTemplateMode(TemplateMode.HTML);
        htmlTplResplver.setCacheable(true);
        htmlTplResplver.setPrefix((String)templatesDir);
        htmlTplResplver.setSuffix(".html");
        htmlTplEngine.setTemplateResolver((ITemplateResolver)htmlTplResplver);
        Context context = new Context();
        context.setVariables(contextMap);
        return htmlTplEngine.process("configuration-form", (IContext)context);
    }
}

