/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.github.GitOptionsHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import ro.sync.exml.plugin.workspace.security.CspDirective;
import ro.sync.exml.plugin.workspace.security.CspProviderExtension;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class GithubCspProvider
implements CspProviderExtension {
    public Map<CspDirective, List<String>> getAdditionalCspConfiguration() {
        String bitbucketApiUrl;
        String gitlabEnterpriseApiUrl;
        EnumMap<CspDirective, List<String>> csp = new EnumMap<CspDirective, List<String>>(CspDirective.class);
        ArrayList<String> connectSrc = new ArrayList<String>();
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (GitOptionsHelper.getOption("github.client_id", null, optionsStorage) != null) {
            String githubApiUrl = GitOptionsHelper.getOption("github.api_url", "https://api.github.com", optionsStorage);
            if (githubApiUrl == null) {
                connectSrc.add("https://api.github.com");
            } else {
                connectSrc.add(githubApiUrl);
            }
        }
        if (GitOptionsHelper.getOption("gitlab.client_id", null, optionsStorage) != null) {
            String gitlabApiUrl = "https://gitlab.com";
            connectSrc.add(gitlabApiUrl);
        }
        if (GitOptionsHelper.getOption("gitlab-e.client_id", null, optionsStorage) != null && (gitlabEnterpriseApiUrl = GitOptionsHelper.getOption("gitlab-e.api_url", null, optionsStorage)) != null) {
            connectSrc.add(gitlabEnterpriseApiUrl);
        }
        if (GitOptionsHelper.getOption("bitbucket.client_id", null, optionsStorage) != null) {
            bitbucketApiUrl = "https://api.bitbucket.org";
            connectSrc.add(bitbucketApiUrl);
        }
        if (GitOptionsHelper.getOption("bitbucketserver.consumer_key", null, optionsStorage) != null && (bitbucketApiUrl = GitOptionsHelper.getOption("bitbucketserver.api_url", null, optionsStorage)) != null) {
            connectSrc.add(bitbucketApiUrl);
        }
        if (!connectSrc.isEmpty()) {
            csp.put(CspDirective.CONNECT_SRC, connectSrc);
        }
        return csp;
    }
}

