/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.examples.github.GithubApiResult;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class GitUtil {
    private static final Logger log = LoggerFactory.getLogger(GitUtil.class);

    private GitUtil() {
    }

    public static GithubApiResult parseGithubResult(String githubJson) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        TypeReference<GithubApiResult> typeRef = new TypeReference<GithubApiResult>(){};
        GithubApiResult githubResult = null;
        try {
            githubResult = (GithubApiResult)mapper.readValue(githubJson, (TypeReference)typeRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return githubResult;
    }

    public static List<GithubApiResult> parseGithubListResult(String githubJson) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        TypeReference<ArrayList<GithubApiResult>> typeRef = new TypeReference<ArrayList<GithubApiResult>>(){};
        ArrayList githubResult = null;
        try {
            githubResult = (ArrayList)mapper.readValue(githubJson, (TypeReference)typeRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return githubResult;
    }

    public static String utf8InputStreamToString(InputStream inputStream) {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String inputStreamToString(InputStream inputStream, String encoding) {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)encoding);
            return writer.toString();
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    public static Map<String, Object> parseJSON(String json) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap githubInfo = null;
        try {
            githubInfo = (HashMap)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
        return githubInfo;
    }

    public static List<HashMap<String, Object>> parseListJson(String json) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        TypeReference<List<HashMap<String, Object>>> typeRef = new TypeReference<List<HashMap<String, Object>>>(){};
        List parsedList = Collections.emptyList();
        try {
            parsedList = (List)mapper.readValue(json, (TypeReference)typeRef);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedList;
    }

    public static String encodePath(String path) {
        String uriEncodedPath = Arrays.stream(path.split("/", -1)).map(URLUtil::encodeURIComponent).collect(Collectors.joining("/"));
        List pathSegments = URLEncodedUtils.parsePathSegments((CharSequence)uriEncodedPath);
        String formatedPath = URLEncodedUtils.formatSegments((Iterable)pathSegments, (Charset)StandardCharsets.UTF_8);
        return formatedPath.isEmpty() ? formatedPath : formatedPath.substring(1);
    }

    public static UserActionRequiredException getNotAuthorizedAndNeedLoginEx() {
        String notAuthorized = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle().getMessage("Not_authorized");
        log.warn("Failed login attempt for Git Connection.");
        return new UserActionRequiredException(new WebappMessage(3, notAuthorized, notAuthorized, true));
    }

    public static IOException getNotAuthorizedAndNoLoginEx() {
        String notAuthorized = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle().getMessage("Not_authorized");
        log.warn("Failed login attempt for Git Connection.");
        return new IOException(notAuthorized);
    }
}

