/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.github.GitHubApplicationAuthenticationProvider;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.github.apiclient.GitHubV3Api;
import com.oxygenxml.examples.oauther.OAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import com.oxygenxml.examples.webauthorgitapi.UserInformation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApis;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import ro.sync.basic.io.QuietClosable;
import ro.sync.ecss.extensions.api.webapp.access.InternalWebappPluginWorkspace;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationManager;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationProvider;
import ro.sync.ecss.webapp.auth.ApplicationUser;
import ro.sync.ecss.webapp.auth.ApplicationUserStore;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class GitHubOAuthService
implements OAuthService<String> {
    private ApplicationAuthenticationProvider githubAuthenticationProvider = new GitHubApplicationAuthenticationProvider(this);

    @Override
    public String getAuthorizationUrl(OAuthState state) {
        String gitHubClientId = GitCredentialsProvider.getGitHubClientId();
        return GitHubOAuthService.getGitHubLoginBase() + "/login/oauth/authorize?client_id=" + gitHubClientId + "&scope=public_repo,repo&state=" + state.getCode();
    }

    public static String getGitHubLoginBase() {
        String gitHubApiUrl = GitCredentialsProvider.getGitHubApiUrl();
        if (gitHubApiUrl == null) {
            gitHubApiUrl = "https://github.com";
        }
        return gitHubApiUrl;
    }

    @Override
    public String extractAccessToken(String code) {
        String gitHubClientId = GitCredentialsProvider.getGitHubClientId();
        String gitHubClientSecret = GitCredentialsProvider.getGitHubClientSecret();
        HttpURLConnection conn = null;
        try {
            String githubResponseBody;
            URL githubAccessTokenUrl = new URL(GitHubOAuthService.getGitHubLoginBase() + "/login/oauth/access_token");
            conn = (HttpURLConnection)githubAccessTokenUrl.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String requestBody = "client_id=" + gitHubClientId + "&client_secret=" + gitHubClientSecret + "&code=" + code;
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(requestBody);
            }
            try (InputStream responseStream = QuietClosable.from((InputStream)conn.getInputStream());){
                githubResponseBody = GitUtil.utf8InputStreamToString(responseStream);
            }
            Map<String, Object> tokenInfo = GitUtil.parseJSON(githubResponseBody);
            String string = (String)tokenInfo.get("access_token");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public void onAccessTokenRefreshed(String accessToken, String sessionId) {
        GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.GITHUB, accessToken);
    }

    @Override
    public void onAccessTokenReceived(String accessToken, String sessionId, OAuthState state) {
        GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.GITHUB, accessToken);
        if (state.isForAuthentication()) {
            try {
                GitHubV3Api gitHubApi = WebAuthorGitApis.createGitHubApi(sessionId);
                UserInformation userInformation = gitHubApi.getUserInformation();
                InternalWebappPluginWorkspace pluginWorkspace = (InternalWebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
                ApplicationAuthenticationManager applicationAuthenticationManager = pluginWorkspace.getApplicationAuthenticationManager();
                ApplicationUser applicationUser = new ApplicationUser(userInformation.getId(), userInformation.getDisplayName(), userInformation.getEmail());
                ApplicationUserStore applicationUserStore = applicationAuthenticationManager.getApplicationUserStore();
                applicationUserStore.authenticateApplicationUser(sessionId, applicationUser);
            }
            catch (NotAuthorizedException e) {
                throw new IllegalStateException();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public String refreshAccessToken(String accessToken) {
        return null;
    }

    @Override
    public String toAccessTokenType(String accessToken) {
        return accessToken;
    }

    public ApplicationAuthenticationProvider getGithubAuthenticationProvider() {
        return this.githubAuthenticationProvider;
    }
}

