/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.github;

import com.oxygenxml.examples.github.GitHubOAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import ro.sync.ecss.webapp.auth.ApplicationAuthenticationProvider;

public class GitHubApplicationAuthenticationProvider
implements ApplicationAuthenticationProvider {
    private GitHubOAuthService gitHubOAuthService;

    public GitHubApplicationAuthenticationProvider(GitHubOAuthService gitHubOAuthService) {
        this.gitHubOAuthService = gitHubOAuthService;
    }

    public String getName() {
        return "GitHub";
    }

    public String getIcon() {
        return "../plugin-resources/github-static/Github70.png";
    }

    public String getCallbackPath() {
        return "../plugins-dispatcher/github-oauth";
    }

    public URL prepareAuthenticationRedirect(String sessionId) {
        OAuthState state = this.gitHubOAuthService.createStateForAuthenticationUrl(sessionId);
        try {
            return new URL(this.gitHubOAuthService.getAuthorizationUrl(state));
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isAskingForAuthorization() {
        return true;
    }
}

