/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.google.common.collect.Sets;
import java.util.Set;

public class SynchronizedReposTracker {
    public static final SynchronizedReposTracker INSTANCE = new SynchronizedReposTracker();
    private final ThreadLocal<Set<String>> updatedRepos = new ThreadLocal();

    void trackSynchronizedRepos() {
        this.updatedRepos.set(Sets.newHashSetWithExpectedSize((int)1));
    }

    void forgetSynchronizedRepos() {
        this.updatedRepos.remove();
    }

    public boolean isRepoUpToDate(String repositoryUri) {
        Set<String> repos = this.updatedRepos.get();
        return repos != null && repos.contains(repositoryUri);
    }

    public void markRepoAsUpToDate(String repositoryUri) {
        Set<String> repos = this.updatedRepos.get();
        if (repos != null) {
            repos.add(repositoryUri);
        }
    }
}

