/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.git.GitPrivilegedCode;
import com.oxygenxml.examples.git.GitRepository;
import com.oxygenxml.examples.git.MutableBoolean;
import com.oxygenxml.examples.git.SynchronizedReposTracker;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class RepositoryProvider {
    private static final Logger log = LoggerFactory.getLogger(RepositoryProvider.class);
    private static final int CHECKED_OUT_BRANCH_CACHE_TIMEOUT_MINUTES = 5;
    private final HashMap<String, MutableBoolean> cloningStatus = new HashMap();
    private final Cache<String, AtomicReference<String>> currentBranchPerRepo = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private File reposDir;
    private final SynchronizedReposTracker synchronizedReposTracker;

    public RepositoryProvider(File cloneLocation, SynchronizedReposTracker synchronizedReposTracker) {
        if (cloneLocation.exists() && !cloneLocation.isDirectory()) {
            throw new IllegalArgumentException("The clone location file should be a directory.");
        }
        cloneLocation.mkdirs();
        this.reposDir = cloneLocation;
        this.synchronizedReposTracker = synchronizedReposTracker;
    }

    public boolean isCloning(String repositoryUri) {
        MutableBoolean cloning = this.cloningStatus.get(repositoryUri = URLUtil.decodeURIComponent((String)repositoryUri));
        return cloning != null && cloning.getValue();
    }

    public GitRepository getRepository(String repositoryUri, CredentialsProvider credentialsProvider) throws IOException, GitAPIException, URISyntaxException, NotAuthorizedException {
        try {
            String repoDirName = "r-" + URLUtil.encodeURIComponent((String)repositoryUri);
            File repositoryDir = Functions.canonicalFileInRepo(this.reposDir, repoDirName);
            Git git = null;
            if (!repositoryDir.exists()) {
                git = this.cloneRepository(repositoryUri, repositoryDir, credentialsProvider);
            }
            if (git == null) {
                try {
                    log.debug("starting repo open");
                    git = Git.open((File)repositoryDir.getAbsoluteFile());
                    log.debug("repo opened");
                    boolean fullyCloned = false;
                    Repository repository = git.getRepository();
                    for (Ref ref : repository.getRefDatabase().getRefs()) {
                        if (ref.getObjectId() == null) continue;
                        fullyCloned = true;
                        break;
                    }
                    log.debug("repo checked for partial cloning.");
                    if (!fullyCloned) {
                        log.debug("Repository not fully cloned... recloning");
                        repository.close();
                        git.close();
                        FileUtils.cleanDirectory((File)repositoryDir);
                        git = this.cloneRepository(repositoryUri, repositoryDir, credentialsProvider);
                    }
                }
                catch (RepositoryNotFoundException e) {
                    log.debug("Repository not found... recloning");
                    if (git != null) {
                        git.getRepository().close();
                        git.close();
                    }
                    FileUtils.cleanDirectory((File)repositoryDir);
                    git = this.cloneRepository(repositoryUri, repositoryDir, credentialsProvider);
                }
            }
            git.getRepository().getConfig().setBoolean("core", null, "autocrlf", false);
            AtomicReference<String> currentBranchRef = this.getCurrentBranchReference(repositoryUri);
            return new GitRepository(repositoryUri, git, currentBranchRef, this.synchronizedReposTracker);
        }
        catch (TransportException e) {
            String message = e.getMessage();
            if (message != null && message.contains("not authorized")) {
                throw new NotAuthorizedException(e);
            }
            throw e;
        }
    }

    private AtomicReference<String> getCurrentBranchReference(String repositoryUri) {
        AtomicReference currentBranchRef;
        try {
            currentBranchRef = (AtomicReference)this.currentBranchPerRepo.get((Object)repositoryUri, AtomicReference::new);
        }
        catch (ExecutionException e) {
            currentBranchRef = new AtomicReference();
        }
        return currentBranchRef;
    }

    private Git cloneRepository(String repositoryUri, File repositoryDir, CredentialsProvider credentialsProvider) throws GitAPIException, URISyntaxException {
        Git git;
        MutableBoolean cloning = this.cloningStatus.get(repositoryUri);
        if (cloning == null) {
            cloning = new MutableBoolean(true);
            this.cloningStatus.put(repositoryUri, cloning);
        } else {
            cloning.setValue(true);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Cloning repository: " + repositoryUri);
            }
            git = GitPrivilegedCode.privileged(repositoryDir, () -> ((CloneCommand)Git.cloneRepository().setURI(URLUtil.clearUserInfo((String)repositoryUri).toExternalForm()).setDirectory(repositoryDir.getAbsoluteFile()).setCredentialsProvider(credentialsProvider)).setNoCheckout(true).call());
        }
        catch (PrivilegedActionException e) {
            log.debug((Object)e, (Throwable)e);
            Exception nestedException = e.getException();
            if (nestedException instanceof InvalidRemoteException) {
                log.error((Object)nestedException, (Throwable)nestedException);
                PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                String invalidRepositoryURI = rb.getMessage("INVALID_REPO_URL_");
                throw new InvalidRemoteException(MessageFormat.format(invalidRepositoryURI, repositoryUri));
            }
            if (nestedException instanceof TransportException) {
                throw (TransportException)((Object)nestedException);
            }
            if (nestedException instanceof GitAPIException) {
                throw (GitAPIException)((Object)nestedException);
            }
            if (nestedException instanceof URISyntaxException) {
                throw (URISyntaxException)nestedException;
            }
            throw new RuntimeException(e);
        }
        finally {
            log.debug("Repository cloned.");
        }
        cloning.setValue(false);
        this.synchronizedReposTracker.markRepoAsUpToDate(repositoryUri);
        return git;
    }
}

