/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReadAheadInputStream
extends BufferedInputStream {
    private boolean closed = false;

    protected ReadAheadInputStream(InputStream in) {
        super(new BufferedInputStream(in, 1));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
        }
    }

    private void closeUnderlyingStream() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        this.readAhead();
        return ret;
    }

    private void readAhead() {
        this.in.mark(1);
        try {
            int read = this.in.read();
            if (-1 == read) {
                this.closeUnderlyingStream();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.reset();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        this.readAhead();
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = super.read(b);
        this.readAhead();
        return ret;
    }
}

