/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.authflow.UserPassEmailCredentialsProvider;
import com.oxygenxml.examples.bitbucket.BitbucketAccessToken;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerAccessToken;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.common.ThreeWayMerger;
import com.oxygenxml.examples.git.CredentialsPack;
import com.oxygenxml.examples.git.GitAccess;
import com.oxygenxml.examples.git.RepositoryProvider;
import com.oxygenxml.examples.git.SynchronizedReposTracker;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.gitlab.GitlabAccessToken;
import com.oxygenxml.examples.webauthorgitapi.GitDocumentInfo;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.SubmodulesResolver;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApis;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitReadApi;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultFail;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultMerge;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultOK;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.ecss.extensions.api.webapp.plugin.WebappServletPluginExtension;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.merge.MergeConflictResolutionMethods;
import ro.sync.merge.MergeResult;
import ro.sync.servlet.ServletUtil;

public class RESTGitAccess
extends WebappServletPluginExtension {
    private static final Logger log = LoggerFactory.getLogger(RESTGitAccess.class);
    private static final String REPOSITORY_URI = "repositoryUri";
    private static final String PATH = "path";
    private static final String BRANCH = "branch";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String MERGE_RESULT_HEADER = "OXY-Merge-Result";
    private static final String STATUS_HEADER_NAME = "OXY-C-STATUS";
    private static final String MERGE_RESULT_HEADER_NAME = "OXY-M-RESULT";
    private static final String LATEST_SHA_HEADER_NAME = "OXY-LATEST-SHA";
    private static final String OXY_FILE_HASH_HEADER = "OXY-FILE-HASH";
    private static final String OXY_COMMIT_SHA_HEADER = "OXY-COMMIT-SHA";
    private static final Pattern connectorSuffix = Pattern.compile("auth=([^&]+)");
    public static volatile RepositoryProvider repositoryProvider;
    public static final SubmodulesResolver submodulesResolver;
    public static final ThreeWayMerger merger;

    public String getPath() {
        return "git";
    }

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletConfig().getServletContext();
        File tempDir = (File)servletContext.getAttribute("OXYGEN_WEBAPP_DATA_DIR");
        repositoryProvider = new RepositoryProvider(new File(tempDir, "git-repos-location"), SynchronizedReposTracker.INSTANCE);
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Expires", "0");
            super.service(req, resp);
        }
        catch (Exception e) {
            log.error("Uncaught Exception in RESTGitAccess", (Throwable)e);
            resp.setStatus(500);
            resp.setContentType("text/plain");
            resp.getWriter().write(e.getMessage());
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqPath = req.getPathInfo();
        if (reqPath.indexOf("git/clonestatus/") != -1) {
            this.handleCloneStatusRequest(req, resp);
        } else if (reqPath.indexOf("git/credentials") != -1) {
            this.handleCredentialsRequest(req, resp);
        } else {
            resp.setStatus(404);
        }
    }

    private void handleCloneStatusRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        String fileListUrl = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        String repositoryUri = ServletUtil.dotDecodeURIComponent((String)fileListUrl);
        if (repositoryUri != null) {
            boolean isCloning = repositoryProvider.isCloning(repositoryUri);
            resp.getWriter().write(String.valueOf(isCloning));
        } else {
            resp.setStatus(400);
        }
    }

    private void handleCredentialsRequest(HttpServletRequest req, HttpServletResponse resp) {
        String sessionId = req.getSession().getId();
        String githubAT = (String)GitCredentialsProvider.getAccessToken(sessionId, CredentialTypes.GITHUB);
        BitbucketAccessToken bitbucketAT = (BitbucketAccessToken)GitCredentialsProvider.getAccessToken(sessionId, CredentialTypes.BITBUCKET);
        BitbucketServerAccessToken bitbucketServerAT = (BitbucketServerAccessToken)GitCredentialsProvider.getAccessToken(sessionId, CredentialTypes.BITBUCKET_SERVER);
        GitlabAccessToken gitlabAT = (GitlabAccessToken)GitCredentialsProvider.getAccessToken(sessionId, CredentialTypes.GITLAB);
        GitlabAccessToken gitlabEnterpriseAT = (GitlabAccessToken)GitCredentialsProvider.getAccessToken(sessionId, CredentialTypes.GITLAB_E);
        UserPassEmailCredentialsProvider upeCreds = GitCredentialsProvider.getCredentials(sessionId, CredentialTypes.USERPASS);
        String userName = upeCreds != null ? upeCreds.getUserName() : null;
        String email = upeCreds != null ? upeCreds.getEmail() : null;
        CredentialsPack credentials = new CredentialsPack(githubAT, bitbucketAT != null ? bitbucketAT.getAccessToken() : null, bitbucketServerAT != null ? bitbucketServerAT.getAccessToken() : null, gitlabAT != null ? gitlabAT.getAccessToken() : null, gitlabEnterpriseAT != null ? gitlabEnterpriseAT.getAccessToken() : null, userName, email);
        try {
            resp.setContentType("application/json");
            OBJECT_MAPPER.writeValue((OutputStream)resp.getOutputStream(), (Object)credentials);
        }
        catch (IOException e) {
            log.error("IOException during handleCredentialsRequest", (Throwable)e);
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) {
        String pathInfo = req.getPathInfo();
        if ("/git/expire-session".equals(pathInfo)) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                CredentialTypes credsType = this.extractAuthenticationMethod(req);
                GitCredentialsProvider.invalidateSession(session.getId(), credsType);
            }
        } else {
            resp.setStatus(404);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo;
        switch (pathInfo = req.getPathInfo()) {
            case "/git/usrpass": 
            case "/git/reset_access": 
            case "/git/merge": {
                this.withoutCredentials(pathInfo, req, resp);
                break;
            }
            default: {
                this.withCredentials(pathInfo, req, resp);
            }
        }
    }

    private void withoutCredentials(String requestPath, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if ("/git/usrpass".equals(requestPath)) {
            this.handleUserPassRequest(req, resp);
        } else if ("/git/reset_access".equals(requestPath)) {
            this.handleClearAccessRequest(req, resp);
        } else if ("/git/merge".equals(requestPath)) {
            String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)req.getInputStream());
            Map<String, Object> requestBody = GitUtil.parseJSON(requestBodyString);
            this.handleMergeRequest(requestBody, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void handleClearAccessRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        CredentialTypes type;
        String gitConnector;
        HttpSession session = httpRequest.getSession();
        String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)httpRequest.getInputStream());
        Map<String, Object> requestBody = GitUtil.parseJSON(requestBodyString);
        switch (gitConnector = (String)requestBody.get("connector")) {
            case "github": {
                type = CredentialTypes.GITHUB;
                break;
            }
            case "bitbucket": {
                type = CredentialTypes.BITBUCKET;
                break;
            }
            case "bitbucket-server": {
                type = CredentialTypes.BITBUCKET_SERVER;
                break;
            }
            case "gitlab": {
                type = CredentialTypes.GITLAB;
                break;
            }
            case "gitlab-e": {
                type = CredentialTypes.GITLAB_E;
                break;
            }
            default: {
                type = CredentialTypes.USERPASS;
            }
        }
        GitCredentialsProvider.invalidateSession(session.getId(), type);
        httpResponse.sendError(200);
    }

    private void handleUserPassRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)httpRequest.getInputStream());
        Map<String, Object> requestBody = GitUtil.parseJSON(requestBodyString);
        if (requestBody == null) {
            httpResponse.setStatus(400);
            return;
        }
        String username = (String)requestBody.get("username");
        String password = (String)requestBody.get("password");
        String email = (String)requestBody.get("email");
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            httpResponse.setStatus(400);
            return;
        }
        GitCredentialsProvider.setUserPass(httpRequest.getSession().getId(), username, password, email);
        httpResponse.setStatus(200);
    }

    private void withCredentials(String pathInfo, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setCharacterEncoding("UTF-8");
        HttpSession session = req.getSession();
        String sessionId = session.getId();
        Map<String, Object> requestBody = null;
        try {
            requestBody = this.parseRequestBody(req);
        }
        catch (IOException e) {
            log.error("Error while parsing request body.", (Throwable)e);
            resp.setStatus(500);
            return;
        }
        CredentialTypes credsType = this.extractAuthenticationMethod(req);
        this.appendGitSuffixGitLab(pathInfo, requestBody, credsType);
        UserPassEmailCredentialsProvider credentialsProvider = GitCredentialsProvider.getCredentials(sessionId, credsType);
        if (credentialsProvider == null) {
            resp.setStatus(401);
            resp.getWriter().write("Session expired");
            return;
        }
        this.forwardRequestWithCredentials(pathInfo, resp, sessionId, requestBody, credsType, (CredentialsProvider)credentialsProvider);
    }

    private Map<String, Object> parseRequestBody(HttpServletRequest req) throws IOException {
        String requestBodyString = GitUtil.utf8InputStreamToString((InputStream)req.getInputStream());
        if (!requestBodyString.isEmpty()) {
            return GitUtil.parseJSON(requestBodyString);
        }
        return null;
    }

    private void appendGitSuffixGitLab(String pathInfo, Map<String, Object> requestBody, CredentialTypes credsType) {
        if (!(credsType != CredentialTypes.GITLAB && credsType != CredentialTypes.GITLAB_E || requestBody == null || "/git/submodule-resolve".equals(pathInfo))) {
            requestBody.computeIfPresent(REPOSITORY_URI, (key, value) -> {
                Object repoUri = (String)value;
                if (!((String)repoUri).endsWith(".git")) {
                    repoUri = (String)repoUri + ".git";
                }
                return repoUri;
            });
        }
    }

    private void forwardRequestWithCredentials(String pathInfo, HttpServletResponse resp, String sessionId, Map<String, Object> requestBody, CredentialTypes credsType, CredentialsProvider credentialsProvider) throws IOException {
        if ("/git/content".equals(pathInfo)) {
            this.handleContentRequest(requestBody, resp, (UserPassEmailCredentialsProvider)credentialsProvider);
        } else if ("/git/try-access".equals(pathInfo)) {
            resp.setStatus(200);
        } else if ("/git/commit".equals(pathInfo)) {
            String username = null;
            String email = null;
            if (credentialsProvider instanceof UserPassEmailCredentialsProvider) {
                UserPassEmailCredentialsProvider useCredsProvider = (UserPassEmailCredentialsProvider)credentialsProvider;
                username = useCredsProvider.getUserName();
                email = useCredsProvider.getEmail();
            }
            this.handleCommitRequest(requestBody, resp, (UserPassEmailCredentialsProvider)credentialsProvider, username, email);
        } else if ("/git/write".equals(pathInfo)) {
            this.handleWriteRequest(requestBody, resp, (UserPassEmailCredentialsProvider)credentialsProvider);
        } else if ("/git/branches".equals(pathInfo)) {
            this.handleBranchesRequest(requestBody, resp, (UserPassEmailCredentialsProvider)credentialsProvider);
        } else if ("/git/branch-exists".equals(pathInfo)) {
            this.handleBranchExistsRequest(requestBody, resp, (UserPassEmailCredentialsProvider)credentialsProvider);
        } else if ("/git/branch-create".equals(pathInfo)) {
            this.handleBranchCreateRequest(requestBody, resp, (UserPassEmailCredentialsProvider)credentialsProvider);
        } else if ("/git/submodule-resolve".equals(pathInfo)) {
            this.handleSubmoduleResolveRequest(requestBody, resp, sessionId, credsType);
        } else {
            resp.setStatus(404);
        }
    }

    private CredentialTypes extractAuthenticationMethod(HttpServletRequest req) {
        CredentialTypes credsType;
        String query = req.getQueryString();
        if (query == null) {
            query = "";
        }
        Matcher m = connectorSuffix.matcher(query);
        String suffix = "";
        if (m.find()) {
            suffix = m.group(1);
        }
        switch (suffix) {
            case "gh": {
                credsType = CredentialTypes.GITHUB;
                break;
            }
            case "bb": {
                credsType = CredentialTypes.BITBUCKET;
                break;
            }
            case "bbsv": {
                credsType = CredentialTypes.BITBUCKET_SERVER;
                break;
            }
            case "gl": {
                credsType = CredentialTypes.GITLAB;
                break;
            }
            case "gle": {
                credsType = CredentialTypes.GITLAB_E;
                break;
            }
            default: {
                credsType = CredentialTypes.USERPASS;
            }
        }
        return credsType;
    }

    private void handleContentRequest(Map<String, Object> requestBody, HttpServletResponse resp, UserPassEmailCredentialsProvider credentialsProvider) throws IOException {
        RepositoryLocation location = new RepositoryLocation((String)requestBody.get(REPOSITORY_URI), (String)requestBody.get(BRANCH), (String)requestBody.get(PATH));
        try {
            GitAccess gitAccess = new GitAccess(repositoryProvider, merger, credentialsProvider);
            GitDocumentInfo document = gitAccess.getDocument(location);
            resp.setHeader(OXY_FILE_HASH_HEADER, document.getContentSha());
            resp.setHeader(OXY_COMMIT_SHA_HEADER, document.getCommitSha());
            resp.setContentType("text/plain");
            resp.getWriter().write(document.getContent());
        }
        catch (NotAuthorizedException e) {
            log.error(e.getMessage(), (Throwable)e);
            resp.setStatus(401);
            resp.getWriter().write("Not authorized to access this repository.");
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            resp.setStatus(404);
            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
            resp.getWriter().write(rb.getMessage("FILE_NOT_FOUND_"));
        }
    }

    private void handleWriteRequest(Map<String, Object> requestBody, HttpServletResponse resp, UserPassEmailCredentialsProvider credentialsProvider) {
        String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
        String sourceBranch = (String)requestBody.get("sourceBranch");
        String destinationBranch = (String)requestBody.get("destinationBranch");
        String filePath = (String)requestBody.get("filePath");
        String fileContents = (String)requestBody.get("newFileContent");
        String commitMessage = (String)requestBody.get("commitMessage");
        RepositoryLocation location = new RepositoryLocation(repositoryUri, destinationBranch, filePath);
        try {
            GitAccess gitAccess = new GitAccess(repositoryProvider, merger, credentialsProvider);
            CommitResult result = gitAccess.writeFile(location, sourceBranch, fileContents.getBytes(), commitMessage);
            if (result instanceof CommitResultOK) {
                CommitResultOK ok = (CommitResultOK)result;
                String commitSha = ok.getCommitSha();
                String fileSha = ok.getFileSha();
                resp.addHeader(STATUS_HEADER_NAME, "ok");
                resp.setContentType("text/plain");
                resp.getWriter().write(commitSha + ";;" + fileSha);
            } else if (result instanceof CommitResultFail) {
                CommitResultFail fail = (CommitResultFail)result;
                String reason = fail.getReason();
                resp.addHeader(STATUS_HEADER_NAME, "fail");
                resp.setContentType("text/plain");
                resp.getWriter().write(reason);
            }
        }
        catch (IOException | URISyntaxException | GitAPIException e) {
            this.handleErr(resp, e);
        }
        catch (NotAuthorizedException e) {
            log.debug("Git not authorized exception " + e.getMessage());
            this.handleErr(resp, e);
        }
    }

    private void handleCommitRequest(Map<String, Object> requestBody, HttpServletResponse resp, UserPassEmailCredentialsProvider credentialsProvider, String username, String email) {
        String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
        String sourceBranch = (String)requestBody.get("sourceBranch");
        String destinationBranch = (String)requestBody.get("destinationBranch");
        String filePath = (String)requestBody.get("filePath");
        String fileContents = (String)requestBody.get("newFileContent");
        String commitMessage = (String)requestBody.get("commitMessage");
        String committer = username != null ? username : (String)requestBody.get("committer");
        String initialContent = (String)requestBody.get("initialContent");
        String initialSha = (String)requestBody.get("initialSha");
        RepositoryLocation location = new RepositoryLocation(repositoryUri, destinationBranch, filePath);
        try {
            GitAccess gitAccess = new GitAccess(repositoryProvider, merger, credentialsProvider);
            CommitResult result = gitAccess.commitFile(location, sourceBranch, fileContents, commitMessage, committer, email, initialSha, initialContent);
            if (result instanceof CommitResultOK) {
                CommitResultOK ok = (CommitResultOK)result;
                String commitSha = ok.getCommitSha();
                String fileSha = ok.getFileSha();
                resp.addHeader(STATUS_HEADER_NAME, "ok");
                resp.setContentType("text/plain");
                resp.getWriter().write(commitSha + ";;" + fileSha);
            } else if (result instanceof CommitResultMerge) {
                CommitResultMerge merge = (CommitResultMerge)result;
                MergeResult mergeResult = merge.getMergeResult();
                MergeResult.ResultType resultType = mergeResult.getResultType();
                String mergedString = mergeResult.getMergedString();
                String latestFileSha = merge.getLatestFileSha();
                resp.addHeader(STATUS_HEADER_NAME, "merge");
                resp.addHeader(LATEST_SHA_HEADER_NAME, latestFileSha);
                resp.addHeader(MERGE_RESULT_HEADER_NAME, resultType.name());
                resp.setContentType("text/plain");
                resp.getWriter().write(mergedString);
            } else if (result instanceof CommitResultFail) {
                CommitResultFail fail = (CommitResultFail)result;
                String reason = fail.getReason();
                resp.addHeader(STATUS_HEADER_NAME, "fail");
                resp.setContentType("text/plain");
                resp.getWriter().write(reason);
            }
        }
        catch (IOException | URISyntaxException | GitAPIException e) {
            this.handleErr(resp, e);
        }
        catch (NotAuthorizedException e) {
            log.debug("Git not authorized exception ", (Throwable)e);
            resp.addHeader(STATUS_HEADER_NAME, "no-access");
            try {
                resp.setContentType("text/plain");
                resp.getWriter().write(e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleBranchesRequest(Map<String, Object> requestBody, HttpServletResponse resp, UserPassEmailCredentialsProvider credentialsProvider) {
        String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
        try {
            GitAccess gitAccess = new GitAccess(repositoryProvider, merger, credentialsProvider);
            List<String> branches = gitAccess.listBranches(repositoryUri);
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int size = branches.size();
            for (int i = 0; i < size; ++i) {
                sb.append(OBJECT_MAPPER.writeValueAsString((Object)branches.get(i)));
                if (i >= size - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            try {
                resp.setContentType("application/json");
                resp.getWriter().write(sb.toString());
            }
            catch (IOException e) {
                this.handleErr(resp, new Exception("Internal Server Error"));
            }
        }
        catch (JsonProcessingException | GitAPIException e) {
            this.handleErr(resp, e);
        }
        catch (NotAuthorizedException e) {
            log.debug("Git not authorized exception " + e.getMessage());
            this.handleErr(resp, e);
        }
    }

    private void handleBranchExistsRequest(Map<String, Object> requestBody, HttpServletResponse resp, UserPassEmailCredentialsProvider credentialsProvider) {
        String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
        String branch = (String)requestBody.get(BRANCH);
        branch = branch.replace(" ", "_");
        branch = branch.replace("~", "_");
        branch = branch.replace("^", "_");
        branch = branch.replace(":", "_");
        branch = branch.replace("\\", "_");
        try {
            GitAccess gitAccess = new GitAccess(repositoryProvider, merger, credentialsProvider);
            List<String> branches = gitAccess.listBranches(repositoryUri);
            String newBranch = Functions.branchExistsInListOfBranches(branch, branches);
            resp.addHeader(STATUS_HEADER_NAME, "success");
            if (!branch.equals(newBranch)) {
                resp.setContentType("application/json");
                resp.getWriter().write("{\"branchExists\":true,\"nextAvailable\":\"" + newBranch + "\"}");
            } else {
                resp.setContentType("application/json");
                resp.getWriter().write("{\"branchExists\":false,\"nextAvailable\":\"" + branch + "\"}");
            }
        }
        catch (GitAPIException e) {
            this.handleErr(resp, e);
        }
        catch (NotAuthorizedException e) {
            log.debug("Git not authorized exception " + e.getMessage());
            this.handleErr(resp, e);
        }
        catch (IOException e) {
            this.handleErr(resp, new Exception("Internal Server Error"));
        }
    }

    private void handleBranchCreateRequest(Map<String, Object> requestBody, HttpServletResponse resp, UserPassEmailCredentialsProvider credentialsProvider) throws IOException {
        String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
        String newBranch = (String)requestBody.get("newBranch");
        String sourceRepositoryUri = (String)requestBody.get("sourceRepositoryUri");
        String sourceBranch = (String)requestBody.get("sourceBranch");
        try {
            GitAccess gitAccess = new GitAccess(repositoryProvider, merger, credentialsProvider);
            gitAccess.createBranch(repositoryUri, newBranch, sourceRepositoryUri, sourceBranch);
            resp.addHeader(STATUS_HEADER_NAME, "success");
        }
        catch (NotAuthorizedException e) {
            resp.setStatus(401);
        }
        catch (Exception e) {
            resp.setStatus(500);
            this.handleErr(resp, e);
        }
    }

    private void handleSubmoduleResolveRequest(Map<String, Object> requestBody, HttpServletResponse resp, String sessionId, CredentialTypes credentialsType) throws IOException {
        String repositoryUri = (String)requestBody.get(REPOSITORY_URI);
        String branch = (String)requestBody.get(BRANCH);
        String path = (String)requestBody.get(PATH);
        if (repositoryUri == null || branch == null || path == null) {
            resp.setStatus(400);
            return;
        }
        try {
            WebAuthorGitReadApi gitApi = WebAuthorGitApis.create(sessionId, credentialsType);
            RepositoryLocation resolvedLocation = submodulesResolver.resolveSubmodule(new RepositoryLocation(repositoryUri, branch, path), gitApi);
            resp.setContentType("application/json");
            resp.getWriter().write("{\"repositoryUri\":" + OBJECT_MAPPER.writeValueAsString((Object)resolvedLocation.getRepositoryUri()) + ",\"branch\":" + OBJECT_MAPPER.writeValueAsString((Object)resolvedLocation.getBranch()) + ",\"path\":" + OBJECT_MAPPER.writeValueAsString((Object)resolvedLocation.getPath()) + "}");
        }
        catch (NotAuthorizedException | UserActionRequiredException e) {
            resp.setStatus(401);
        }
    }

    private void handleMergeRequest(Map<String, Object> requestBody, HttpServletResponse resp) throws ServletException, IOException {
        String ancestor = (String)requestBody.get("ancestor");
        String left = (String)requestBody.get("left");
        String right = (String)requestBody.get("right");
        if (!(ancestor == null || ancestor.isEmpty() || left == null || left.isEmpty() || right == null || right.isEmpty())) {
            try {
                MergeResult mergeResult = merger.merge(ancestor, left, right, MergeConflictResolutionMethods.USE_LEFT);
                String mergedString = mergeResult.getMergedString();
                MergeResult.ResultType resultType = mergeResult.getResultType();
                if (resultType == MergeResult.ResultType.CLEAN) {
                    if (mergeResult.mergingOccurred()) {
                        resp.setHeader(MERGE_RESULT_HEADER, "CLEAN");
                    } else {
                        resp.setHeader(MERGE_RESULT_HEADER, "IDENTICAL");
                    }
                } else if (resultType == MergeResult.ResultType.WITH_CONFLICTS) {
                    resp.setHeader(MERGE_RESULT_HEADER, "WITH_CONFLICTS");
                } else if (resultType == MergeResult.ResultType.FAILED) {
                    resp.setHeader(MERGE_RESULT_HEADER, "FAILED");
                }
                resp.setCharacterEncoding("UTF-8");
                resp.setStatus(200);
                resp.setContentType("text/plain");
                resp.getWriter().write(mergedString);
                resp.flushBuffer();
            }
            catch (OutOfMemoryError e) {
                throw new ServletException("Out of memory, cannot auto-merge!");
            }
        } else {
            resp.sendError(400);
        }
    }

    private void handleErr(HttpServletResponse resp, Throwable e) {
        RuntimeException re;
        Throwable cause;
        if (e instanceof RuntimeException && (cause = (re = (RuntimeException)e).getCause()) != null) {
            e = cause;
        }
        resp.addHeader(STATUS_HEADER_NAME, "error");
        try {
            log.error((Object)e, e);
            resp.setContentType("text/plain");
            resp.getWriter().write(e.getMessage());
        }
        catch (IOException ex) {
            log.error("Error while writing error repsonse", (Throwable)ex);
        }
    }

    static {
        submodulesResolver = new SubmodulesResolver();
        merger = new ThreeWayMerger();
    }
}

