/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.oxygenxml.examples.git.IsolatedSystemReader;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class JGitInitializer {
    private static boolean initialized = false;

    private JGitInitializer() {
    }

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            AccessController.doPrivileged(() -> {
                FS.detect();
                SystemReader defaultSystemReader = SystemReader.getInstance();
                SystemReader.setInstance((SystemReader)new IsolatedSystemReader(defaultSystemReader, FS.DETECTED));
                Security.addProvider(new DummyGpgSignerProvider("BC", 0.0, "Dummy GPG provider"));
                GpgSigner.setDefault((GpgSigner)new DummyGpgSigner());
                return null;
            });
        }
    }

    private static final class DummyGpgSignerProvider
    extends Provider {
        private static final long serialVersionUID = 3157770403934780141L;

        private DummyGpgSignerProvider(String name, double version, String info) {
            super(name, version, info);
        }
    }

    private static final class DummyGpgSigner
    extends GpgSigner {
        private DummyGpgSigner() {
        }

        public void sign(CommitBuilder commit, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        }

        public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
            return false;
        }
    }
}

