/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public class IsolatedSystemReader
extends SystemReader {
    private final SystemReader defaultSystemReader;
    private FS detectedFs;

    public IsolatedSystemReader(SystemReader defaultSystemReader, FS detectedFs) {
        this.defaultSystemReader = defaultSystemReader;
        this.detectedFs = detectedFs;
    }

    public FileBasedConfig openUserConfig(Config parent, FS fs) {
        return new EmptyFileBasedConfiguration(fs);
    }

    public FileBasedConfig openSystemConfig(Config parent, FS fs) {
        return new EmptyFileBasedConfiguration(fs);
    }

    public Path getXdgConfigDirectory(FS fileSystem) {
        return null;
    }

    public StoredConfig getJGitConfig() throws ConfigInvalidException, IOException {
        return new EmptyFileBasedConfiguration(this.detectedFs);
    }

    public String getenv(String variable) {
        return this.defaultSystemReader.getenv(variable);
    }

    public int getTimezone(long when) {
        return this.defaultSystemReader.getTimezone(when);
    }

    public String getProperty(String key) {
        return this.defaultSystemReader.getProperty(key);
    }

    public String getHostname() {
        return this.defaultSystemReader.getHostname();
    }

    public long getCurrentTime() {
        return this.defaultSystemReader.getCurrentTime();
    }

    public FileBasedConfig openJGitConfig(Config config, FS fs) {
        return new EmptyFileBasedConfiguration(fs);
    }

    private final class EmptyFileBasedConfiguration
    extends FileBasedConfig {
        private EmptyFileBasedConfiguration(FS fs) {
            super(null, fs);
            this.setBoolean("gc", null, "autoDetach", false);
        }

        public void save() throws IOException {
        }

        public void load() throws IOException, ConfigInvalidException {
        }

        public boolean isOutdated() {
            return false;
        }
    }
}

