/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.oxygenxml.examples.git.HttpConnectionAdapter;
import com.oxygenxml.examples.git.ReadAheadInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class HttpConnectionFactoryInstaller {
    private static final HttpConnectionFactory oldFactory = HttpTransport.getConnectionFactory();
    private static final HttpConnectionFactory newFactory = new HttpConnectionFactory(){

        public HttpConnection create(URL url, Proxy proxy) throws IOException {
            return this.wrapConnection(oldFactory.create(url, proxy));
        }

        public HttpConnection create(URL url) throws IOException {
            return this.wrapConnection(oldFactory.create(url));
        }

        private HttpConnection wrapConnection(HttpConnection connection) {
            return new HttpConnectionAdapter(connection){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new ReadAheadInputStream(super.getInputStream());
                }

                @Override
                public String getResponseMessage() throws IOException {
                    try {
                        return super.getResponseMessage();
                    }
                    catch (HttpExceptionWithDetails e) {
                        return e.getReason();
                    }
                }
            };
        }
    };

    public static void install() {
        if (HttpTransport.getConnectionFactory() != newFactory) {
            HttpTransport.setConnectionFactory((HttpConnectionFactory)newFactory);
        }
    }
}

