/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.oxygenxml.examples.common.BaseUrlConnection;
import com.oxygenxml.examples.git.GitAccess;
import com.oxygenxml.examples.git.RESTGitAccess;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultOK;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.webapp.WebappMessage;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.net.protocol.FolderEntryDescriptor;

public class GitUrlConnection
extends BaseUrlConnection {
    private static final Logger log = LoggerFactory.getLogger(GitUrlConnection.class);
    private RepositoryLocation repositoryLocation;
    private GitAccess gitAccess;

    public GitUrlConnection(RepositoryLocation repositoryLocation, URLConnection delegateConnection, GitAccess gitAccess) {
        super(delegateConnection);
        this.repositoryLocation = repositoryLocation;
        this.gitAccess = gitAccess;
    }

    public InputStream getInputStream() throws IOException {
        try {
            RepositoryLocation location = RESTGitAccess.submodulesResolver.resolveSubmodule(this.repositoryLocation, this.gitAccess);
            return this.gitAccess.read(location);
        }
        catch (NotAuthorizedException e) {
            log.debug("Git not authorized exception " + e.getMessage());
            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
            String notAuthorized = rb.getMessage("Not_authorized");
            throw new UserActionRequiredException(new WebappMessage(3, notAuthorized, notAuthorized, true));
        }
        catch (NotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                byte[] fileContents = this.toByteArray();
                try {
                    PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                    String createdWithWAMsg = rb.getMessage("Created_with_oxygen_web_author");
                    RepositoryLocation location = RESTGitAccess.submodulesResolver.resolveSubmodule(GitUrlConnection.this.repositoryLocation, GitUrlConnection.this.gitAccess);
                    CommitResult result = GitUrlConnection.this.gitAccess.writeFile(location, location.getBranch(), fileContents, createdWithWAMsg);
                    if (!(result instanceof CommitResultOK)) {
                        throw new IOException("Failed to create file.");
                    }
                }
                catch (URISyntaxException e) {
                    log.debug("URISyntaxException in close", (Throwable)e);
                    throw new IOException(e.getMessage());
                }
                catch (TransportException e) {
                    log.debug("TransportException in close", (Throwable)e);
                    if (e.getMessage().contains("git-receive-pack not permitted") || e.getMessage().endsWith("not authorized")) {
                        PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                        String notAuthorized = rb.getMessage("Not_authorized");
                        log.debug("Git not authorized exception " + e.getMessage());
                        throw new UserActionRequiredException(new WebappMessage(3, notAuthorized, notAuthorized, true));
                    }
                    throw new IOException(e.getMessage());
                }
                catch (GitAPIException e) {
                    log.debug("GitAPIException in close", (Throwable)e);
                    throw new IOException(e.getMessage());
                }
                catch (NotAuthorizedException e) {
                    throw GitUtil.getNotAuthorizedAndNoLoginEx();
                }
            }
        };
    }

    public List<FolderEntryDescriptor> listFolder() throws IOException {
        ArrayList<FolderEntryDescriptor> filesList = null;
        try {
            RepositoryLocation location = RESTGitAccess.submodulesResolver.resolveSubmodule(this.repositoryLocation, this.gitAccess);
            File[] fileList = this.gitAccess.listFiles(location);
            filesList = new ArrayList<FolderEntryDescriptor>(fileList.length);
            for (File file : fileList) {
                Object fileName = file.getName();
                if (file.isDirectory()) {
                    if (".git".equals(fileName)) continue;
                    fileName = (String)fileName + "/";
                }
                filesList.add(new FolderEntryDescriptor(GitUtil.encodePath("/" + this.repositoryLocation.getPath() + "/" + (String)fileName)));
            }
        }
        catch (URISyntaxException | GitAPIException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (NotAuthorizedException e) {
            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
            String notAuthorized = rb.getMessage("Not_authorized");
            log.debug("Git not authorized exception " + e.getMessage());
            throw new UserActionRequiredException(new WebappMessage(3, notAuthorized, notAuthorized, true));
        }
        return filesList;
    }
}

