/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.examples.git.SynchronizedReposTracker;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepository
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GitRepository.class);
    private static final String ORIGIN = "origin";
    private String repositoryUri;
    private Git git;
    private AtomicReference<String> checkedOutBranch;
    private final SynchronizedReposTracker synchronizedReposTracker;

    GitRepository(String repositoryUri, Git git, AtomicReference<String> checkedOutBranch, SynchronizedReposTracker synchronizedReposTracker) {
        this.repositoryUri = repositoryUri;
        this.git = git;
        this.checkedOutBranch = checkedOutBranch;
        this.synchronizedReposTracker = synchronizedReposTracker;
    }

    public CheckoutCommand checkout() {
        this.forgetCheckedOutBranch();
        return this.git.checkout();
    }

    public PushCommand push() {
        this.forgetCheckedOutBranch();
        return this.git.push();
    }

    public ListBranchCommand branchList() {
        return this.git.branchList();
    }

    public DeleteBranchCommand branchDelete() {
        this.forgetCheckedOutBranch();
        return this.git.branchDelete();
    }

    @VisibleForTesting
    PullCommand pull() {
        this.forgetCheckedOutBranch();
        return this.git.pull();
    }

    public void pullWithAuthCheck(CredentialsProvider credentialsProvider) throws NotAuthorizedException, GitAPIException {
        if (!this.synchronizedReposTracker.isRepoUpToDate(this.repositoryUri)) {
            String checkedOutBranchBeforePull = this.checkedOutBranch.get();
            this.forgetCheckedOutBranch();
            try {
                ((PullCommand)this.git.pull().setCredentialsProvider(credentialsProvider)).call();
                this.checkedOutBranch.set(checkedOutBranchBeforePull);
                this.synchronizedReposTracker.markRepoAsUpToDate(this.repositoryUri);
            }
            catch (InvalidRemoteException e) {
                throw new NotAuthorizedException(e);
            }
            catch (TransportException e) {
                if (e.getMessage() != null && e.getMessage().contains("not authorized")) {
                    throw new NotAuthorizedException(e);
                }
                log.debug("Exception in checkAuth", (Throwable)e);
                throw e;
            }
        }
    }

    @VisibleForTesting
    ResetCommand reset() {
        this.forgetCheckedOutBranch();
        return this.git.reset();
    }

    public LogCommand log() {
        return this.git.log();
    }

    public AddCommand add() {
        this.forgetCheckedOutBranch();
        return this.git.add();
    }

    public CommitCommand commit() {
        this.forgetCheckedOutBranch();
        return this.git.commit();
    }

    public RemoteAddCommand remoteAdd() {
        return this.git.remoteAdd();
    }

    public RemoteRemoveCommand remoteRemove() {
        return this.git.remoteRemove();
    }

    public FetchCommand fetch() {
        this.forgetCheckedOutBranch();
        return this.git.fetch();
    }

    public File getDirectory() {
        return this.git.getRepository().getWorkTree();
    }

    public String getBranch() throws IOException {
        return this.git.getRepository().getBranch();
    }

    private boolean isRepoClean() {
        File gitRepoDir = this.getDirectory();
        File[] files = gitRepoDir.listFiles();
        return files.length == 1 && ".git".equals(files[0].getName());
    }

    public void createBranch(String destinationBranch) throws GitAPIException, IOException {
        if (!this.isAlreadyCheckedOut(destinationBranch)) {
            this.forgetCheckedOutBranch();
            try {
                this.git.branchCreate().setName(destinationBranch).setStartPoint("origin/" + destinationBranch).call();
            }
            catch (RefAlreadyExistsException refAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    public void resetRepository(String currentBranch) throws GitAPIException {
        block3: {
            if (!this.isRepoClean() && !this.isAlreadyCheckedOut(currentBranch)) {
                this.forgetCheckedOutBranch();
                this.git.clean().setCleanDirectories(true).call();
                try {
                    this.git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/" + currentBranch).call();
                }
                catch (JGitInternalException e) {
                    if (e.getMessage().startsWith("Invalid ref name")) break block3;
                    log.debug("Exception when resetting repository", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    void prepareRepositoryForCheckout() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException {
        this.checkout().setForced(true).setName("HEAD").call();
    }

    public void checkOutBranch(String destinationBranch) throws GitAPIException, IOException {
        if (!this.isAlreadyCheckedOut(destinationBranch)) {
            this.forgetCheckedOutBranch();
            this.prepareRepositoryForCheckout();
            this.git.checkout().setName(destinationBranch).setForced(true).call();
            this.checkedOutBranch.set(destinationBranch);
        }
    }

    public String getShaOfFile(String filePath) throws IOException {
        ObjectId revParse = this.git.getRepository().resolve(":" + filePath);
        return revParse == null ? null : revParse.getName();
    }

    public String getBranchSha(String branchName) throws IOException {
        Ref ref = this.git.getRepository().getRefDatabase().exactRef("refs/heads/" + branchName);
        if (ref == null || ref.getObjectId() == null) {
            throw new IOException("Branch SHA could not be retrieved for: " + branchName);
        }
        return ref.getObjectId().getName();
    }

    public ObjectId getObjectIdOfBranch(String branchName) throws GitAPIException {
        Collection refs = this.git.lsRemote().setRemote(this.repositoryUri).setHeads(true).call();
        for (Ref ref : refs) {
            if (!ref.getName().equals("refs/heads/" + branchName)) continue;
            return ref.getObjectId();
        }
        throw new IllegalStateException(branchName + " was not found in the collection of references.");
    }

    String getRemoteBranchSha(String branch) throws GitAPIException {
        return this.getObjectIdOfBranch(branch).getName();
    }

    private void forgetCheckedOutBranch() {
        this.checkedOutBranch.set(null);
    }

    private boolean isAlreadyCheckedOut(String branch) {
        return branch.equals(this.checkedOutBranch.get());
    }

    @Override
    public void close() {
        this.git.close();
    }

    public void dispose() throws IOException {
        this.forgetCheckedOutBranch();
        this.git.getRepository().close();
        this.git.close();
        FileUtils.cleanDirectory((File)this.getDirectory());
    }
}

