/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import java.io.File;
import java.io.FilePermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URLPermission;
import java.nio.file.LinkPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.PropertyPermission;

public final class GitPrivilegedCode {
    private static AccessControlContext createPrivilegedContext(File repositoryDir) {
        Permissions perms = new Permissions();
        perms.add(new LinkPermission("symbolic"));
        perms.add(new FilePermission(System.getProperty("java.io.tmpdir"), "read,write,delete"));
        perms.add(new FilePermission(System.getProperty("java.io.tmpdir") + File.separator + "-", "read,write,delete"));
        perms.add(new FilePermission(repositoryDir.getAbsolutePath(), "read,write,delete,execute"));
        perms.add(new FilePermission(repositoryDir.getAbsolutePath() + File.separator + "-", "read,write,delete,execute"));
        perms.add(new URLPermission("http:*", "*:*"));
        perms.add(new URLPermission("https:*", "*:*"));
        perms.add(new NetPermission("*"));
        perms.add(new SocketPermission("*", "connect,resolve"));
        perms.add(new PropertyPermission("*", "read"));
        perms.add(new RuntimePermission("*"));
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        AccessControlContext context = new AccessControlContext(new ProtectionDomain[]{domain});
        return context;
    }

    public static <T> T privileged(File repositoryDir, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return AccessController.doPrivileged(action, GitPrivilegedCode.createPrivilegedContext(repositoryDir));
    }
}

