/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.git;

import com.oxygenxml.examples.authflow.UserPassEmailCredentialsProvider;
import com.oxygenxml.examples.common.Functions;
import com.oxygenxml.examples.common.ThreeWayMerger;
import com.oxygenxml.examples.git.GitPrivilegedCode;
import com.oxygenxml.examples.git.GitRepository;
import com.oxygenxml.examples.git.HttpConnectionFactoryInstaller;
import com.oxygenxml.examples.git.NameAndEmail;
import com.oxygenxml.examples.git.RepositoryProvider;
import com.oxygenxml.examples.github.GitUtil;
import com.oxygenxml.examples.webauthorgitapi.DocumentToCommit;
import com.oxygenxml.examples.webauthorgitapi.GitDocumentInfo;
import com.oxygenxml.examples.webauthorgitapi.RepositoryLocation;
import com.oxygenxml.examples.webauthorgitapi.WebAuthorGitApi;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.CommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.FailCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.MergeCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitoperationresults.OkCommitOperationResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResult;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultFail;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultMerge;
import com.oxygenxml.examples.webauthorgitapi.commitresults.CommitResultOK;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotAdvertisedException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.exml.workspace.api.PluginResourceBundle;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.merge.MergeConflictResolutionMethods;
import ro.sync.merge.MergeResult;

public class GitAccess
implements WebAuthorGitApi {
    private static final Logger log = LoggerFactory.getLogger(GitAccess.class);
    private static final ConcurrentHashMap<String, Object> locks;
    private String origin = "origin";
    private RepositoryProvider repositoryProvider;
    private ThreeWayMerger merger = null;
    private final Pattern bitbucketNoAuthzPattern = Pattern.compile(".*bitbucket.org.*not authorized.*");
    private UserPassEmailCredentialsProvider credentialsProvider;
    private static final String ATOMIC_PUSH_NOT_SUPPORTED = "Atomic push not supported.";

    public GitAccess(RepositoryProvider repositoryProvider, ThreeWayMerger merger, UserPassEmailCredentialsProvider credentialsProvider) {
        this.repositoryProvider = repositoryProvider;
        this.merger = merger;
        this.credentialsProvider = credentialsProvider;
    }

    public List<String> listBranches(String repositoryUri) throws GitAPIException, NotAuthorizedException {
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in listBranches (credentialsProvider is null)");
        try {
            Collection lsResult = ((LsRemoteCommand)Git.lsRemoteRepository().setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).setRemote(repositoryUri).setTags(false).setHeads(true).call();
            ArrayList<String> branchesList = new ArrayList<String>(lsResult.size());
            for (Ref ref : lsResult) {
                String longName = ref.getName();
                branchesList.add(longName.substring(11));
            }
            Collections.sort(branchesList);
            return branchesList;
        }
        catch (TransportException e) {
            if (e.getMessage().contains("git-upload-pack not found")) {
                log.debug("Not authorized in listBranches", (Throwable)e);
                throw new NotAuthorizedException(e);
            }
            log.debug("Transport exception in listBranches", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBranchUnsecureForTestsOnly(String repositoryUri, String branch) throws NotAuthorizedException, IOException, GitAPIException, URISyntaxException {
        Object lock;
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in createNewBranch (credentialsProvider is null)");
        Object object = lock = this.getLock(repositoryUri);
        synchronized (object) {
            try (GitRepository git = this.repositoryProvider.getRepository(repositoryUri, (CredentialsProvider)this.credentialsProvider);){
                GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                    List branchesList = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                    if (branchesList.size() <= 1) {
                        log.warn("Cannot remove branch because there is no other branch on which to switch the repository after removal.");
                        return null;
                    }
                    String existingBranch = this.extractBranchNameFromRef((Ref)branchesList.get(0));
                    if (existingBranch.equals(branch)) {
                        existingBranch = this.extractBranchNameFromRef((Ref)branchesList.get(1));
                    }
                    git.checkout().setCreateBranch(true).setName(existingBranch).setStartPoint(this.origin + "/" + existingBranch).call();
                    DeleteBranchCommand branchDelete = git.branchDelete();
                    branchDelete.setBranchNames(new String[]{branch});
                    branchDelete.setForce(true);
                    PushCommand push = git.push();
                    push.setCredentialsProvider((CredentialsProvider)this.credentialsProvider);
                    push.setRemote(this.origin);
                    push.setRefSpecs(new RefSpec[]{new RefSpec().setSource(null).setDestination("refs/heads/" + branch)});
                    push.call();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof NotAuthorizedException) {
                    throw (NotAuthorizedException)ex;
                }
                if (ex instanceof TransportException) {
                    throw (TransportException)((Object)ex);
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof GitAPIException) {
                    throw (GitAPIException)((Object)ex);
                }
                if (ex instanceof URISyntaxException) {
                    throw (URISyntaxException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createBranch(String repositoryUri, String newBranch, String sourceRepositoryUri, String sourceBranch) throws NotAuthorizedException {
        Object lock;
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in createNewBranch (credentialsProvider is null)");
        Object object = lock = this.getLock(repositoryUri);
        synchronized (object) {
            Object repo = repositoryUri.endsWith(".git") ? repositoryUri : repositoryUri + ".git";
            Object source = sourceRepositoryUri.endsWith(".git") ? sourceRepositoryUri : sourceRepositoryUri + ".git";
            try (GitRepository git = this.repositoryProvider.getRepository(repositoryUri, (CredentialsProvider)this.credentialsProvider);){
                GitPrivilegedCode.privileged(git.getDirectory(), () -> this.lambda$createBranch$1((String)repo, (String)source, git, sourceBranch, newBranch, sourceRepositoryUri));
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof NotAuthorizedException) {
                    throw (NotAuthorizedException)ex;
                }
                throw new UnexpectedException(ex.getMessage(), ex);
            }
            catch (IOException | URISyntaxException | GitAPIException e) {
                throw new UnexpectedException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewBranchFromRemote(GitRepository git, String newBranch, String sourceRepositoryUri, String sourceBranch) throws URISyntaxException, GitAPIException, IOException {
        URIish uri = new URIish(URLUtil.clearUserInfo((String)sourceRepositoryUri).toExternalForm());
        String sourceRemote = "source";
        try {
            RemoteAddCommand remoteAdd = git.remoteAdd();
            remoteAdd.setUri(uri);
            remoteAdd.setName(sourceRemote);
            remoteAdd.call();
            try {
                FetchCommand fetch = git.fetch();
                fetch.setRefSpecs(new RefSpec[]{new RefSpec("+refs/heads/" + sourceBranch + ":refs/remotes/" + sourceRemote + "/" + sourceBranch)});
                fetch.setRemote(sourceRemote);
                fetch.setCredentialsProvider((CredentialsProvider)this.credentialsProvider);
                fetch.call();
                git.prepareRepositoryForCheckout();
                CheckoutCommand checkout = git.checkout();
                checkout.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
                checkout.setStartPoint(sourceRemote + "/" + sourceBranch);
                checkout.setCreateBranch(true);
                checkout.setName(newBranch);
                checkout.setForced(true);
                checkout.call();
                PushCommand push = git.push();
                push.setCredentialsProvider((CredentialsProvider)this.credentialsProvider);
                push.setRemote(this.origin);
                push.call();
            }
            catch (GitAPIException e) {
                DeleteBranchCommand branchDelete;
                try {
                    List branchesList = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                    if (branchesList.isEmpty()) {
                        log.debug("Something went wrong, cleaning up repository for recloning.");
                        git.dispose();
                        throw e;
                    }
                    String currentBranch = this.extractBranchNameFromRef((Ref)branchesList.get(0));
                    if (newBranch.equals(currentBranch)) {
                        currentBranch = this.extractBranchNameFromRef((Ref)branchesList.get(1));
                    }
                    try {
                        git.checkout().setCreateBranch(true).setName(currentBranch).setStartPoint(this.origin + "/" + currentBranch).call();
                    }
                    catch (RefAlreadyExistsException ex) {
                        git.checkout().setName(currentBranch).setStartPoint(this.origin + "/" + currentBranch).call();
                    }
                    branchDelete = git.branchDelete();
                }
                catch (GitAPIException ex) {
                    DeleteBranchCommand branchDelete2;
                    try {
                        log.error((Throwable)ex);
                        branchDelete2 = git.branchDelete();
                    }
                    catch (Throwable throwable) {
                        DeleteBranchCommand branchDelete3 = git.branchDelete();
                        branchDelete3.setBranchNames(new String[]{newBranch});
                        branchDelete3.setForce(true);
                        branchDelete3.call();
                        throw throwable;
                    }
                    branchDelete2.setBranchNames(new String[]{newBranch});
                    branchDelete2.setForce(true);
                    branchDelete2.call();
                }
                branchDelete.setBranchNames(new String[]{newBranch});
                branchDelete.setForce(true);
                branchDelete.call();
                throw e;
            }
        }
        finally {
            RemoteRemoveCommand remoteRemove = git.remoteRemove();
            remoteRemove.setRemoteName(sourceRemote);
            remoteRemove.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitResult writeFile(RepositoryLocation location, String sourceBranch, byte[] fileContents, String commitMessage) throws URISyntaxException, IOException, GitAPIException, NotAuthorizedException {
        Object lock;
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in writeFile (credentialsProvider is null)");
        String repoUri = location.getRepositoryUri();
        Object object = lock = this.getLock(repoUri);
        synchronized (object) {
            CommitResult commitResult;
            block12: {
                GitRepository git = this.repositoryProvider.getRepository(repoUri, (CredentialsProvider)this.credentialsProvider);
                try {
                    commitResult = GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                        String committerEmail;
                        this.prepareRepositoryForWrite(git, sourceBranch, location.getBranch());
                        String filePath = location.getPath();
                        File repoRootDir = git.getDirectory();
                        File latestContentFile = Functions.canonicalFileInRepo(repoRootDir, filePath);
                        Files.write(latestContentFile.toPath(), fileContents, new OpenOption[0]);
                        git.add().addFilepattern(filePath).call();
                        String committer = this.credentialsProvider.getUserName();
                        String email = this.credentialsProvider.getEmail();
                        String committerName = committer;
                        if (committerName == null) {
                            committerName = "oXygen Web Author";
                        }
                        if ((committerEmail = email) == null) {
                            committerEmail = "";
                        }
                        RevCommit commit = git.commit().setCommitter(committerName, committerEmail).setAuthor(committerName, committerEmail).setMessage(commitMessage).call();
                        Iterable results = ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).call();
                        PushResult result = (PushResult)results.iterator().next();
                        RemoteRefUpdate refUpdate = (RemoteRefUpdate)result.getRemoteUpdates().iterator().next();
                        if (refUpdate.getStatus() == RemoteRefUpdate.Status.OK) {
                            String shaOfFile = git.getShaOfFile(filePath);
                            if (shaOfFile == null) {
                                return new CommitResultFail("Push succeeded but failed to retrieve file sha.");
                            }
                            return new CommitResultOK(commit.getName(), shaOfFile);
                        }
                        return new CommitResultFail(refUpdate.getMessage());
                    });
                    if (git == null) break block12;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        this.throwWrappedException(e);
                        return null;
                    }
                }
            }
            return commitResult;
        }
    }

    private void validateCredentialsProvider(UserPassEmailCredentialsProvider credentialsProvider, String debugMessage) throws NotAuthorizedException {
        if (credentialsProvider == null) {
            log.debug(debugMessage);
            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
            throw new NotAuthorizedException(rb.getMessage("Not_authenticated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitResult commitFile(RepositoryLocation location, String sourceBranch, String newFileContent, String commitMessage, String committer, String email, String initialSha, String initialContent) throws URISyntaxException, IOException, GitAPIException, NotAuthorizedException {
        Object lock;
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in commitFile (credentialsProvider is null)");
        String repoUri = location.getRepositoryUri();
        Object object = lock = this.getLock(repoUri);
        synchronized (object) {
            CommitResult commitResult;
            block12: {
                GitRepository git = this.repositoryProvider.getRepository(repoUri, (CredentialsProvider)this.credentialsProvider);
                try {
                    commitResult = GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                        String committerEmail;
                        String latestContent;
                        MergeResult mergeResult;
                        String latestSha;
                        this.prepareRepositoryForWrite(git, sourceBranch, location.getBranch());
                        String filePath = location.getPath();
                        File repoRootDir = git.getDirectory();
                        File latestContentFile = Functions.canonicalFileInRepo(repoRootDir, filePath);
                        if (latestContentFile.exists() && !initialSha.equals(latestSha = git.getShaOfFile(filePath)) && (mergeResult = this.merge(initialContent, newFileContent, latestContent = FileUtils.readFileToString((File)latestContentFile, (Charset)StandardCharsets.UTF_8))).mergingOccurred()) {
                            return new CommitResultMerge(mergeResult, latestSha);
                        }
                        FileUtils.writeStringToFile((File)latestContentFile, (String)newFileContent, (Charset)StandardCharsets.UTF_8);
                        git.add().addFilepattern(filePath).call();
                        String committerName = committer;
                        if (committerName == null) {
                            committerName = "oXygen Web Author";
                        }
                        if ((committerEmail = email) == null) {
                            committerEmail = "";
                        }
                        RevCommit commit = git.commit().setCommitter(committerName, committerEmail).setAuthor(committerName, committerEmail).setMessage(commitMessage).call();
                        try {
                            Iterable results = ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).call();
                            PushResult result = (PushResult)results.iterator().next();
                            RemoteRefUpdate refUpdate = (RemoteRefUpdate)result.getRemoteUpdates().iterator().next();
                            if (refUpdate.getStatus() == RemoteRefUpdate.Status.OK) {
                                String shaOfFile = git.getShaOfFile(filePath);
                                return new CommitResultOK(commit.getName(), shaOfFile);
                            }
                            if ("permission denied".equals(refUpdate.getMessage())) {
                                PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                                throw new NotAuthorizedException(rb.getMessage("No_commit_access"));
                            }
                            return new CommitResultFail(refUpdate.getMessage());
                        }
                        catch (TransportException e) {
                            String message = e.getMessage();
                            if (message.contains(ATOMIC_PUSH_NOT_SUPPORTED)) {
                                throw new NotAuthorizedException(ATOMIC_PUSH_NOT_SUPPORTED);
                            }
                            log.debug("TransportException in commitFile", (Throwable)e);
                            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                            throw new NotAuthorizedException(rb.getMessage("No_commit_access"));
                        }
                    });
                    if (git == null) break block12;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        this.throwWrappedException(e);
                        return null;
                    }
                }
            }
            return commitResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitOperationResult commitDocuments(List<DocumentToCommit> documents, String repositoryUri, String branch, String latestCommitSha, String commitMessage, boolean forcePush) {
        Object lock;
        try {
            this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in commitDocuments (credentialsProvider is null)");
        }
        catch (NotAuthorizedException e) {
            return new FailCommitOperationResult(Functions.getExceptionStatus(e), e.getMessage());
        }
        Object object = lock = this.getLock(repositoryUri);
        synchronized (object) {
            CommitOperationResult commitOperationResult;
            block15: {
                GitRepository git = this.repositoryProvider.getRepository(repositoryUri, (CredentialsProvider)this.credentialsProvider);
                try {
                    commitOperationResult = GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                        this.prepareRepositoryForWrite(git, null, branch);
                        String branchSha = git.getBranchSha(branch);
                        if (!latestCommitSha.equals(branchSha) && !forcePush) {
                            return new MergeCommitOperationResult(false, branchSha, null);
                        }
                        this.writeContentToDocuments(git, documents);
                        this.addDocuments(git, documents);
                        NameAndEmail committerNameAndEmail = new NameAndEmail(this.credentialsProvider.getUserName(), this.credentialsProvider.getEmail());
                        RevCommit commit = git.commit().setCommitter(committerNameAndEmail.getName(), committerNameAndEmail.getEmail()).setAuthor(committerNameAndEmail.getName(), committerNameAndEmail.getEmail()).setMessage(commitMessage).call();
                        try {
                            Iterable results = ((PushCommand)git.push().setForce(forcePush).setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).call();
                            PushResult result = (PushResult)results.iterator().next();
                            RemoteRefUpdate refUpdate = (RemoteRefUpdate)result.getRemoteUpdates().iterator().next();
                            if (refUpdate.getStatus() == RemoteRefUpdate.Status.OK) {
                                return new OkCommitOperationResult(commit.getName(), documents);
                            }
                            if (refUpdate.getStatus() == RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD) {
                                String latestBranchSha = git.getRemoteBranchSha(branch);
                                return new MergeCommitOperationResult(false, latestBranchSha, null);
                            }
                            return new FailCommitOperationResult(500, refUpdate.getMessage());
                        }
                        catch (TransportException e) {
                            log.error(e.getMessage(), (Throwable)e);
                            String message = e.getMessage();
                            if (message.contains(ATOMIC_PUSH_NOT_SUPPORTED)) {
                                NotAuthorizedException result = new NotAuthorizedException(ATOMIC_PUSH_NOT_SUPPORTED);
                            }
                            PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                            NotAuthorizedException notAuthEx = new NotAuthorizedException(rb.getMessage("No_commit_access"));
                            return new FailCommitOperationResult(Functions.getExceptionStatus(notAuthEx), notAuthEx.getMessage());
                        }
                    });
                    if (git == null) break block15;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NotAuthorizedException | IOException | URISyntaxException | GitAPIException e) {
                        log.error(e.getMessage(), e);
                        return new FailCommitOperationResult(Functions.getExceptionStatus((Exception)e), e.getMessage());
                    }
                    catch (PrivilegedActionException e) {
                        Exception ex = e.getException();
                        log.error(ex.getMessage(), (Throwable)ex);
                        return new FailCommitOperationResult(Functions.getExceptionStatus(ex), ex.getMessage());
                    }
                }
            }
            return commitOperationResult;
        }
    }

    private void writeContentToDocuments(GitRepository git, List<DocumentToCommit> documents) throws IOException {
        File repoRootDir = git.getDirectory();
        for (DocumentToCommit document : documents) {
            File file = Functions.canonicalFileInRepo(repoRootDir, document.getLocation().getPath());
            FileUtils.writeByteArrayToFile((File)file, (byte[])document.getContentToCommit());
        }
    }

    private void addDocuments(GitRepository git, List<DocumentToCommit> documents) throws GitAPIException {
        AddCommand addCommand = git.add();
        for (DocumentToCommit document : documents) {
            addCommand.addFilepattern(document.getLocation().getPath());
        }
        addCommand.call();
    }

    private void throwWrappedException(PrivilegedActionException e) throws NotAuthorizedException, GitAPIException, TransportException, IOException, URISyntaxException {
        Exception ex = e.getException();
        if (ex instanceof NotAuthorizedException) {
            throw (NotAuthorizedException)ex;
        }
        if (ex instanceof TransportException) {
            throw (TransportException)((Object)ex);
        }
        if (ex instanceof GitAPIException) {
            throw (GitAPIException)((Object)ex);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof URISyntaxException) {
            throw (URISyntaxException)ex;
        }
        throw new RuntimeException(ex);
    }

    private MergeResult merge(String ancestor, String left, String right) {
        return this.merger.merge(ancestor, left, right, MergeConflictResolutionMethods.USE_LEFT);
    }

    void prepareRepositoryForWrite(GitRepository git, String sourceBranch, String destinationBranch) throws IOException, GitAPIException, NotAuthorizedException {
        String currentBranch = git.getBranch();
        git.resetRepository(currentBranch);
        try {
            git.createBranch(destinationBranch);
            git.checkOutBranch(destinationBranch);
            git.pullWithAuthCheck((CredentialsProvider)this.credentialsProvider);
        }
        catch (RefNotFoundException e) {
            if (!sourceBranch.equals(destinationBranch)) {
                this.prepareRepositoryForWriteFallback(git, sourceBranch, destinationBranch, currentBranch);
            }
            log.debug((Throwable)e);
            throw e;
        }
    }

    private void prepareRepositoryForWriteFallback(GitRepository git, String sourceBranch, String destinationBranch, String initialBranch) throws GitAPIException, NotAuthorizedException, IOException {
        git.checkout().setCreateBranch(true).setName(destinationBranch).setStartPoint(this.origin + "/" + sourceBranch).call();
        try {
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)this.credentialsProvider)).call();
        }
        catch (TransportException ex) {
            String errMessage = ex.getMessage();
            if (errMessage.contains("git-receive-pack not permitted") || this.bitbucketNoAuthzPattern.matcher(errMessage).find()) {
                try {
                    git.checkout().setName(initialBranch).setStartPoint(this.origin + "/" + initialBranch).call();
                }
                catch (RefNotFoundException ex2) {
                    List branchesList = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                    if (branchesList.isEmpty()) {
                        log.debug("Something went wrong, cleaning up repository for recloning.", (Throwable)ex2);
                        git.dispose();
                        throw ex2;
                    }
                    initialBranch = this.extractBranchNameFromRef((Ref)branchesList.get(0));
                    git.checkout().setCreateBranch(true).setName(initialBranch).setStartPoint(this.origin + "/" + initialBranch).call();
                }
                git.branchDelete().setBranchNames(new String[]{destinationBranch}).setForce(true).call();
                git.resetRepository(initialBranch);
                log.debug("Not authorized in prepareRepositoryForWrite");
                PluginResourceBundle rb = ((WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace()).getResourceBundle();
                throw new NotAuthorizedException(rb.getMessage("No_commit_access"));
            }
            log.debug((Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareRepositoryForRead(GitRepository git, String destinationBranch) throws IOException, GitAPIException, NotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("Getting repo up to date: " + git.getDirectory().getParentFile());
        }
        String currentBranch = git.getBranch();
        git.resetRepository(currentBranch);
        log.debug("Reset repo done");
        try {
            git.createBranch(destinationBranch);
            git.checkOutBranch(destinationBranch);
            log.debug("Checkout finished");
            try {
                git.pullWithAuthCheck((CredentialsProvider)this.credentialsProvider);
            }
            catch (RefNotAdvertisedException refNotAdvertisedException) {
                // empty catch block
            }
        }
        catch (RefNotFoundException e) {
            git.prepareRepositoryForCheckout();
            git.checkout().setCreateBranch(true).setForced(true).setName(destinationBranch).setStartPoint(destinationBranch).call();
        }
        finally {
            log.debug("Repo update finished");
        }
    }

    @Override
    public GitDocumentInfo getDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        Object lock;
        if (location.getPath().isEmpty()) {
            throw new IllegalArgumentException("The file path should not be empty.");
        }
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in getDocument (credentialsProvider is null)");
        String repositoryUri = location.getRepositoryUri();
        Object object = lock = this.getLock(repositoryUri);
        synchronized (object) {
            GitDocumentInfo gitDocumentInfo;
            block16: {
                String branchName = location.getBranch();
                String filePath = location.getPath();
                GitRepository git = this.repositoryProvider.getRepository(repositoryUri, (CredentialsProvider)this.credentialsProvider);
                try {
                    gitDocumentInfo = GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                        this.prepareRepositoryForRead(git, branchName);
                        Iterable commits = git.log().setMaxCount(1).call();
                        RevCommit commit = (RevCommit)commits.iterator().next();
                        String commitSha = commit.getName();
                        String fileSha = git.getShaOfFile(filePath);
                        if (fileSha == null) {
                            throw new FileNotFoundException();
                        }
                        File directory = git.getDirectory();
                        File fileToRead = Functions.canonicalFileInRepo(directory, filePath);
                        String fileContent = FileUtils.readFileToString((File)fileToRead, (Charset)StandardCharsets.UTF_8);
                        return new GitDocumentInfo(fileContent, fileSha, commitSha);
                    });
                    if (git == null) break block16;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        log.debug("Get document file not found");
                        throw new NotFoundException(location);
                    }
                    catch (PrivilegedActionException e) {
                        Exception ex = e.getException();
                        if (ex instanceof NotAuthorizedException) {
                            throw (NotAuthorizedException)ex;
                        }
                        throw new UnexpectedException(ex.getMessage(), ex);
                    }
                    catch (IOException | URISyntaxException | GitAPIException e) {
                        throw new UnexpectedException(e.getMessage(), e);
                    }
                }
            }
            return gitDocumentInfo;
        }
    }

    @Override
    public InputStream read(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        Object lock;
        if (location.getPath().isEmpty()) {
            throw new IllegalArgumentException("The file path should not be empty.");
        }
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in getFileContents (credentialsProvider is null)");
        String repositoryUri = location.getRepositoryUri();
        String branchName = location.getBranch();
        String filePath = location.getPath();
        if (log.isDebugEnabled()) {
            log.debug("Reading file: " + filePath + " from repo " + repositoryUri + " branch " + branchName);
        }
        Object object = lock = this.getLock(repositoryUri);
        synchronized (object) {
            InputStream inputStream;
            block17: {
                GitRepository git = this.repositoryProvider.getRepository(repositoryUri, (CredentialsProvider)this.credentialsProvider);
                try {
                    inputStream = GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                        this.prepareRepositoryForRead(git, branchName);
                        File directory = git.getDirectory();
                        File fileToRead = Functions.canonicalFileInRepo(directory, filePath);
                        return new FileInputStream(fileToRead);
                    });
                    if (git == null) break block17;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        Exception ex = e.getException();
                        if (ex instanceof NotAuthorizedException) {
                            throw (NotAuthorizedException)ex;
                        }
                        if (ex instanceof FileNotFoundException) {
                            throw new NotFoundException(location);
                        }
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                    catch (FileNotFoundException e) {
                        throw new NotFoundException(location);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
            return inputStream;
        }
    }

    @Override
    public String getContentAtCommit(RepositoryLocation location, String commitSha, String encoding) throws NotAuthorizedException, NotFoundException {
        String content;
        RepositoryLocation updatedLocation = new RepositoryLocation(location.getRepositoryUri(), commitSha, location.getPath());
        try (InputStream contentInputStream = this.read(updatedLocation);){
            content = GitUtil.inputStreamToString(contentInputStream, encoding);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.deleteLocalBranch(location.getRepositoryUri(), commitSha, location.getBranch());
        return content;
    }

    @Override
    public String getShaOfCommitThatCreatedDocument(RepositoryLocation location) throws NotAuthorizedException, NotFoundException {
        Object lock;
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in getShaOfCommitThatCreatedDocument (credentialsProvider is null)");
        Object object = lock = this.getLock(location.getRepositoryUri());
        synchronized (object) {
            String string;
            block12: {
                GitRepository git = this.repositoryProvider.getRepository(location.getRepositoryUri(), (CredentialsProvider)this.credentialsProvider);
                try {
                    ObjectId branchObjectId = git.getObjectIdOfBranch(location.getBranch());
                    Iterable commits = git.log().add((AnyObjectId)branchObjectId).addPath(location.getPath()).call();
                    Iterator commitsIterator = commits.iterator();
                    RevCommit firstCommit = (RevCommit)commitsIterator.next();
                    while (commitsIterator.hasNext()) {
                        firstCommit = (RevCommit)commitsIterator.next();
                    }
                    string = firstCommit.getName();
                    if (git == null) break block12;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | URISyntaxException | GitAPIException e) {
                        throw new UnexpectedException(e.getMessage(), e);
                    }
                }
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLocalBranch(String repositoryUri, String branchToDelete, String branchToSwitchOn) throws NotAuthorizedException {
        Object lock;
        Object object = lock = this.getLock(repositoryUri);
        synchronized (object) {
            try (GitRepository git = this.repositoryProvider.getRepository(repositoryUri, (CredentialsProvider)this.credentialsProvider);){
                GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                    git.checkOutBranch(branchToSwitchOn);
                    git.branchDelete().setBranchNames(new String[]{branchToDelete}).setForce(true).call();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof NotAuthorizedException) {
                    throw (NotAuthorizedException)ex;
                }
                throw new UnexpectedException(ex.getMessage(), ex);
            }
            catch (IOException | URISyntaxException | GitAPIException e) {
                throw new UnexpectedException(e.getMessage(), e);
            }
        }
    }

    String toGithubSha1(String fileContent) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String contentWithPreamble = "blob " + fileContent.length() + "\u0000" + fileContent;
        digest.update(contentWithPreamble.getBytes(StandardCharsets.UTF_8));
        return new String(Hex.encodeHex((byte[])digest.digest(), (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listFiles(RepositoryLocation location) throws IOException, GitAPIException, URISyntaxException, NotAuthorizedException {
        Object lock;
        this.validateCredentialsProvider(this.credentialsProvider, "Not authenticated in listFiles (credentialsProvider is null)");
        Object object = lock = this.getLock(location.getRepositoryUri());
        synchronized (object) {
            File[] fileArray;
            block12: {
                GitRepository git = this.repositoryProvider.getRepository(location.getRepositoryUri(), (CredentialsProvider)this.credentialsProvider);
                try {
                    fileArray = GitPrivilegedCode.privileged(git.getDirectory(), () -> {
                        this.prepareRepositoryForRead(git, location.getBranch());
                        File rootDir = git.getDirectory();
                        File folderToListFileFor = Functions.canonicalFileInRepo(rootDir, location.getPath());
                        File[] filesList = null;
                        if (folderToListFileFor.isDirectory()) {
                            filesList = folderToListFileFor.listFiles();
                        }
                        return filesList != null ? filesList : new File[]{};
                    });
                    if (git == null) break block12;
                    git.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (git != null) {
                            try {
                                git.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        this.throwWrappedException(e);
                        return new File[0];
                    }
                }
            }
            return fileArray;
        }
    }

    private String extractBranchNameFromRef(Ref ref) {
        String name = ref.getName();
        return name.substring(20);
    }

    private Object getLock(String key) {
        key = "git" + ((String)key).substring(((String)key).indexOf(58)) + (!((String)key).endsWith(".git") ? ".git" : "");
        return locks.computeIfAbsent((String)key, k -> new Object());
    }

    private /* synthetic */ String lambda$createBranch$1(String repo, String source, GitRepository git, String sourceBranch, String newBranch, String sourceRepositoryUri) throws Exception {
        if (repo.equals(source)) {
            this.prepareRepositoryForWrite(git, sourceBranch, newBranch);
        } else {
            Object sourceRepoUri = sourceRepositoryUri;
            if (!((String)sourceRepoUri).endsWith(".git")) {
                sourceRepoUri = (String)sourceRepoUri + ".git";
            }
            this.createNewBranchFromRemote(git, newBranch, (String)sourceRepoUri, sourceBranch);
        }
        return newBranch;
    }

    static {
        HttpConnectionFactoryInstaller.install();
        locks = new ConcurrentHashMap();
    }
}

