/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotAuthorizedException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.NotFoundException;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.net.protocol.http.HttpExceptionWithDetails;

public class Functions {
    private static final Pattern BRANCH_AND_SUFFIX_PATTERN = Pattern.compile("(.+-)(\\d+)$");
    private static final String GITHUB_PROPERTY_NAME_FOR_SIZE_OF_READ_FILE = "github.size_in_megabytes_for_a_read_file";
    private static final int GITHUB_DEFAULT_SIZE_FOR_READ_FILE = 50;

    private Functions() {
    }

    public static <T> T parseJson(InputStream inputStream, Class<T> clazz) throws IOException {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        int maximumFileSizeInMegaBytes = 50;
        if (optionsStorage != null) {
            String maxFileSizeStr = optionsStorage.getOption(GITHUB_PROPERTY_NAME_FOR_SIZE_OF_READ_FILE, String.valueOf(50));
            try {
                maximumFileSizeInMegaBytes = Integer.parseInt(maxFileSizeStr);
            }
            catch (RuntimeException e) {
                throw new IOException("Invalid file size in options storage: " + maxFileSizeStr, e);
            }
        }
        try {
            JsonFactory jf = JsonFactory.builder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Functions.convertFromMegaToGithubStringValue(maximumFileSizeInMegaBytes)).build()).build();
            return (T)new ObjectMapper(jf).readValue(inputStream, clazz);
        }
        catch (JsonMappingException e) {
            throw new IOException("File size exceed value " + maximumFileSizeInMegaBytes + " MB. " + e.getMessage());
        }
    }

    private static int convertFromMegaToGithubStringValue(int fileSize) {
        return (int)((double)(fileSize * 1024 * 1024) / 3.0 * 4.0 + 1048576.0);
    }

    public static String encodeCredentials(String username, String password) {
        byte[] unencodedConsumerAuth = (username + ":" + password).getBytes(StandardCharsets.UTF_8);
        byte[] encodedConsumerAuth = Base64.getEncoder().encode(unencodedConsumerAuth);
        return new String(encodedConsumerAuth, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static void addFormData(StringBuilder body, String key, String value, String boundary) {
        String crlf = "\r\n";
        body.append("--").append(boundary).append(crlf);
        body.append("Content-Disposition: form-data; name=\"").append(key).append("\"").append(crlf);
        body.append(crlf);
        body.append(value + crlf);
    }

    public static String toGitSha1(String fileContent) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            String prefixedContent = "blob " + fileContent.length() + "\u0000" + fileContent;
            digest.update(prefixedContent.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])digest.digest(), (boolean)true));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    public static String getQueryParamFromQueryString(String queryParam, String queryString) {
        String[] parameters = queryString.split("&");
        for (int i = 0; i < parameters.length; ++i) {
            int equalSignIndex = parameters[i].indexOf(61);
            if (!queryParam.equals(parameters[i].substring(0, equalSignIndex))) continue;
            return URLUtil.decodeURIComponent((String)parameters[i].substring(equalSignIndex + 1));
        }
        return null;
    }

    public static String branchExistsInListOfBranches(String branch, List<String> branches) {
        branch = ((String)branch).toLowerCase();
        branches = branches.stream().map(String::toLowerCase).collect(Collectors.toList());
        while (branches.contains(branch)) {
            Matcher matcher = BRANCH_AND_SUFFIX_PATTERN.matcher((CharSequence)branch);
            if (matcher.matches()) {
                Integer lastNumber;
                try {
                    lastNumber = NumberParserUtil.valueOfInteger((String)matcher.group(2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Could not perform branch name checking due to String to Integer conversion.");
                }
                branch = matcher.group(1) + (lastNumber + 1);
                continue;
            }
            branch = (String)branch + "-2";
        }
        return branch;
    }

    public static int getExceptionStatus(Exception e) {
        int status = e instanceof NotAuthorizedException || e instanceof UserActionRequiredException ? 401 : (e instanceof NotFoundException ? 404 : (e instanceof HttpExceptionWithDetails ? ((HttpExceptionWithDetails)((Object)e)).getReasonCode() : 500));
        return status;
    }

    public static File canonicalFileInRepo(File directory, String path) throws IOException {
        File file = new File(directory, path);
        String directoryCanonicalPath = directory.getCanonicalPath();
        String fileCanonicalPath = file.getCanonicalPath();
        if (fileCanonicalPath.startsWith(directoryCanonicalPath) && fileCanonicalPath.length() >= directoryCanonicalPath.length()) {
            return file;
        }
        throw new IllegalArgumentException();
    }
}

