/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver.oauth;

import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class RsaSigner {
    static final String SIGNATURE_METHOD = "RSA-SHA1";

    static String sign(String text, String privateKey) {
        try {
            Signature signatureAlgorithm = Signature.getInstance("SHA1withRSA");
            signatureAlgorithm.initSign(RsaSigner.getPrivateKey(privateKey));
            signatureAlgorithm.update(text.getBytes(StandardCharsets.UTF_8));
            byte[] signature = signatureAlgorithm.sign();
            return Base64.getEncoder().encodeToString(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privateBytes = Base64.getDecoder().decode(privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }
}

