/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver.oauth;

import com.oxygenxml.examples.bitbucketserver.oauth.RsaSigner;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationHeader {
    private static final Logger log = LoggerFactory.getLogger(OAuthAuthorizationHeader.class);
    private static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    private static final String OAUTH_NONCE = "oauth_nonce";
    private static final String OAUTH_SIGNATURE = "oauth_signature";
    private static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    private static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    private static final String OAUTH_TOKEN = "oauth_token";
    private static final String OAUTH_VERIFIER = "oauth_verifier";
    private static final String OAUTH_VERSION = "oauth_version";
    private String requestMethod;
    private URL requestUrl;
    private String consumerKey;
    private String nonce;
    private String signatureMethod;
    private String privateKey;
    private String timestamp;
    private String token;
    private String verifier;
    private String version;

    public OAuthAuthorizationHeader(String requestMethod, URL requestUrl, String consumerKey, String privateKey, String token, String verifier) {
        this.requestMethod = requestMethod;
        this.requestUrl = requestUrl;
        this.consumerKey = consumerKey;
        this.nonce = this.getNonce();
        this.signatureMethod = "RSA-SHA1";
        this.privateKey = privateKey;
        this.token = token;
        this.verifier = verifier;
        this.version = "1.0";
    }

    public String getContent() {
        StringBuilder authorizationHeader = new StringBuilder("OAuth ");
        this.appendToHeader(authorizationHeader, OAUTH_CONSUMER_KEY, this.consumerKey);
        this.appendToHeader(authorizationHeader, OAUTH_NONCE, this.nonce);
        this.timestamp = this.getTimestamp();
        String signature = RsaSigner.sign(this.generateStringToSign(), this.privateKey);
        this.appendToHeader(authorizationHeader, OAUTH_SIGNATURE, signature);
        this.appendToHeader(authorizationHeader, OAUTH_SIGNATURE_METHOD, this.signatureMethod);
        this.appendToHeader(authorizationHeader, OAUTH_TIMESTAMP, this.timestamp);
        this.appendToHeader(authorizationHeader, OAUTH_TOKEN, this.token);
        this.appendToHeader(authorizationHeader, OAUTH_VERIFIER, this.verifier);
        this.appendToHeader(authorizationHeader, OAUTH_VERSION, this.version);
        authorizationHeader.deleteCharAt(authorizationHeader.length() - 1);
        String authHeaderString = authorizationHeader.toString();
        if (log.isDebugEnabled()) {
            log.debug("[BB-Server Auth Header]: {}", (Object)authHeaderString);
        }
        return authHeaderString;
    }

    private String generateStringToSign() {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        this.putToMap(parameters, OAUTH_CONSUMER_KEY, this.consumerKey);
        this.putToMap(parameters, OAUTH_NONCE, this.nonce);
        this.putToMap(parameters, OAUTH_SIGNATURE_METHOD, this.signatureMethod);
        this.putToMap(parameters, OAUTH_TIMESTAMP, this.timestamp);
        this.putToMap(parameters, OAUTH_TOKEN, this.token);
        this.putToMap(parameters, OAUTH_VERIFIER, this.verifier);
        this.putToMap(parameters, OAUTH_VERSION, this.version);
        String query = this.requestUrl.getQuery();
        if (query != null && !query.isEmpty()) {
            for (String pair : query.split("&")) {
                int idx = pair.indexOf(61);
                parameters.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        StringBuilder normalizedParams = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                normalizedParams.append("&");
            }
            normalizedParams.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        String normalizedParameters = normalizedParams.toString();
        int port = this.requestUrl.getPort();
        String normalizedRequestUrl = this.requestUrl.getProtocol() + "://" + this.requestUrl.getHost() + (String)(port == -1 ? "" : ":" + port) + this.requestUrl.getPath();
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(this.encode(this.requestMethod)).append("&");
        stringToSign.append(this.encode(normalizedRequestUrl)).append("&");
        stringToSign.append(this.encode(normalizedParameters));
        return stringToSign.toString();
    }

    private void putToMap(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(this.encode(key), this.encode(value));
        }
    }

    private void appendToHeader(StringBuilder authorizationHeader, String key, String value) {
        if (value != null) {
            authorizationHeader.append(this.encode(key)).append("=\"").append(this.encode(value)).append("\",");
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private String getTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private String getNonce() {
        return Long.toHexString(Math.abs(Math.max(new SecureRandom().nextLong(), -9223372036854775807L)));
    }
}

