/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver.oauth;

import com.oxygenxml.examples.authflow.CredentialTypes;
import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerAccessToken;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerApiResponseParser;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerUrls;
import com.oxygenxml.examples.bitbucketserver.oauth.OAuthAuthorizationHeader;
import com.oxygenxml.examples.oauther.OAuthService;
import com.oxygenxml.examples.oauther.OAuthState;
import com.oxygenxml.examples.webauthorgitapi.exceptions.UnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import ro.sync.ecss.extensions.api.webapp.SessionStore;
import ro.sync.ecss.extensions.api.webapp.access.WebappPluginWorkspace;
import ro.sync.ecss.extensions.api.webapp.plugin.servlet.http.HttpServletRequest;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class BitbucketServerOAuthService
implements OAuthService<BitbucketServerAccessToken> {
    private static final String CODE_SEPARATOR = "<<split>>";

    @Override
    public String getAuthorizationUrl(OAuthState state) {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String bitbucketServerAuthorizeApiEndpoint = "/plugins/servlet/oauth/authorize";
        String queryString = "?oauth_token=" + state.getCode();
        String bitbucketServerAuthorizeUrl = bitbucketServerUrl + bitbucketServerAuthorizeApiEndpoint + queryString;
        return bitbucketServerAuthorizeUrl;
    }

    @Override
    public BitbucketServerAccessToken extractAccessToken(String code) {
        try {
            String accessToken = this.getAccessToken(code);
            String userName = this.getUserName(accessToken);
            return new BitbucketServerAccessToken(accessToken, userName);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private String getUserName(String accessToken) throws IOException {
        String userInfoUrl = BitbucketServerUrls.getUserInformationUrl();
        URL url = new URL(userInfoUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        OAuthAuthorizationHeader oAuthAuthorizationHeader = new OAuthAuthorizationHeader("GET", url, GitCredentialsProvider.getBitbucketServerConsumerKey(), GitCredentialsProvider.getBitbucketServerPrivateKey(), accessToken, null);
        conn.setRequestProperty("Authorization", oAuthAuthorizationHeader.getContent());
        try (InputStream response = conn.getInputStream();){
            String string = URLDecoder.decode(conn.getHeaderField("X-AUSERNAME"), StandardCharsets.UTF_8.toString());
            return string;
        }
    }

    @Override
    public void onAccessTokenReceived(BitbucketServerAccessToken accessToken, String sessionId, OAuthState state) {
        GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.BITBUCKET_SERVER, accessToken);
    }

    @Override
    public void onAccessTokenRefreshed(BitbucketServerAccessToken accessToken, String sessionId) {
        GitCredentialsProvider.setCredentials(sessionId, CredentialTypes.BITBUCKET_SERVER, accessToken);
    }

    @Override
    public BitbucketServerAccessToken toAccessTokenType(String accessToken) {
        String userName;
        int oxyIndex = accessToken.indexOf("<oxy>");
        if (oxyIndex != -1) {
            userName = accessToken.substring(0, oxyIndex);
            accessToken = accessToken.substring(oxyIndex);
        } else {
            try {
                userName = this.getUserName(accessToken);
            }
            catch (IOException e) {
                throw new UnexpectedException(e.getMessage(), e);
            }
        }
        return new BitbucketServerAccessToken(accessToken, userName);
    }

    private String getUnauthorizedRequestToken() throws IOException {
        String unauthorizedRequestToken;
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String bitbucketServerUnauthorizedRequestTokenApiEndpoint = "/plugins/servlet/oauth/request-token";
        String unauthorizedRequestTokenUrl = bitbucketServerUrl + bitbucketServerUnauthorizedRequestTokenApiEndpoint;
        URL requestUrl = new URL(unauthorizedRequestTokenUrl);
        HttpURLConnection conn = (HttpURLConnection)requestUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        OAuthAuthorizationHeader oAuthAuthorizationHeader = new OAuthAuthorizationHeader("POST", requestUrl, GitCredentialsProvider.getBitbucketServerConsumerKey(), GitCredentialsProvider.getBitbucketServerPrivateKey(), null, null);
        conn.addRequestProperty("Authorization", oAuthAuthorizationHeader.getContent());
        try (InputStream response = conn.getInputStream();){
            unauthorizedRequestToken = BitbucketServerApiResponseParser.parseOAuthToken(response);
        }
        return unauthorizedRequestToken;
    }

    private String getAccessToken(String code) throws IOException {
        String accessToken;
        String[] split = code.split(CODE_SEPARATOR);
        String verificationCode = split[0];
        String stateToken = split[1];
        String bitbucketServerApiUri = GitCredentialsProvider.getBitbucketServerUrl();
        String bitbucketServerAccessTokenApiEndpoint = "/plugins/servlet/oauth/access-token";
        String accessTokenUrl = bitbucketServerApiUri + bitbucketServerAccessTokenApiEndpoint;
        URL requestUrl = new URL(accessTokenUrl);
        HttpURLConnection conn = (HttpURLConnection)requestUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        OAuthAuthorizationHeader oAuthAuthorizationHeader = new OAuthAuthorizationHeader("POST", requestUrl, GitCredentialsProvider.getBitbucketServerConsumerKey(), GitCredentialsProvider.getBitbucketServerPrivateKey(), stateToken, verificationCode);
        conn.addRequestProperty("Authorization", oAuthAuthorizationHeader.getContent());
        try (InputStream response = conn.getInputStream();){
            accessToken = BitbucketServerApiResponseParser.parseOAuthToken(response);
        }
        return accessToken;
    }

    @Override
    public BitbucketServerAccessToken refreshAccessToken(BitbucketServerAccessToken accessToken) {
        return null;
    }

    @Override
    public OAuthState createStateForAuthorizationUrl(String sessionId) {
        try {
            String unauthorizedRequestToken = this.getUnauthorizedRequestToken();
            OAuthState state = new OAuthState(unauthorizedRequestToken);
            WebappPluginWorkspace pluginWorkspace = (WebappPluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
            SessionStore sessionStore = pluginWorkspace.getSessionStore();
            sessionStore.put(sessionId, "oauth::sess::key", (Object)state);
            return state;
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    @Override
    public String getAuthorizedCode(HttpServletRequest req, OAuthState state) {
        return req.getParameter("oauth_token") + CODE_SEPARATOR + state.getCode();
    }

    @Override
    public OAuthState getStateFromAuthorizationCallback(HttpServletRequest req) {
        String oauthToken = req.getParameter("oauth_token");
        return new OAuthState(oauthToken);
    }
}

