/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.examples.bitbucketserver;

import com.oxygenxml.examples.authflow.GitCredentialsProvider;
import com.oxygenxml.examples.bitbucketserver.BitbucketServerUrls;
import ro.sync.basic.util.URLUtil;

public class RepoBranchesUrlBuilder {
    private String projectUrl;
    private boolean forRetrieval;
    private int pageOffset;
    private String filterText;

    public RepoBranchesUrlBuilder repository(String repositoryUrl) {
        this.projectUrl = BitbucketServerUrls.getProjRepoUri(repositoryUrl);
        return this;
    }

    public RepoBranchesUrlBuilder forRetrieval() {
        this.forRetrieval = true;
        return this;
    }

    public RepoBranchesUrlBuilder fromOffset(int offset) {
        this.pageOffset = offset;
        return this;
    }

    public RepoBranchesUrlBuilder withFilterText(String filter) {
        this.filterText = filter;
        return this;
    }

    public String build() {
        String bitbucketServerUrl = GitCredentialsProvider.getBitbucketServerUrl();
        String branchesApiEndpoint = "/branches";
        String repoBranchesUrl = bitbucketServerUrl + "/rest/api/1.0" + this.projectUrl + branchesApiEndpoint;
        if (this.forRetrieval) {
            String queryString = "?orderBy=MODIFICATION&limit=500";
            repoBranchesUrl = repoBranchesUrl + queryString;
            if (this.pageOffset != 0) {
                repoBranchesUrl = repoBranchesUrl + "&start=" + this.pageOffset;
            }
            if (this.filterText != null) {
                repoBranchesUrl = repoBranchesUrl + "&filterText=" + URLUtil.encodeURIComponent((String)this.filterText);
            }
        }
        return repoBranchesUrl;
    }
}

